/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1ModifierOption;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="V1ModifierList")
public class V1ModifierList {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="selection_type")
    private SelectionTypeEnum selectionType = null;
    @JsonProperty(value="modifier_options")
    private List<V1ModifierOption> modifierOptions = new ArrayList<V1ModifierOption>();

    public V1ModifierList id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The modifier list's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1ModifierList name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The modifier list's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ModifierList selectionType(SelectionTypeEnum selectionType) {
        this.selectionType = selectionType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether MULTIPLE options or a SINGLE option from the modifier list can be applied to a single item. See [V1ModifierListSelectionType](#type-v1modifierlistselectiontype) for possible values")
    public SelectionTypeEnum getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(SelectionTypeEnum selectionType) {
        this.selectionType = selectionType;
    }

    public V1ModifierList modifierOptions(List<V1ModifierOption> modifierOptions) {
        this.modifierOptions = modifierOptions;
        return this;
    }

    public V1ModifierList addModifierOptionsItem(V1ModifierOption modifierOptionsItem) {
        this.modifierOptions.add(modifierOptionsItem);
        return this;
    }

    @ApiModelProperty(value="The options included in the modifier list.")
    public List<V1ModifierOption> getModifierOptions() {
        return this.modifierOptions;
    }

    public void setModifierOptions(List<V1ModifierOption> modifierOptions) {
        this.modifierOptions = modifierOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ModifierList v1ModifierList = (V1ModifierList)o;
        return Objects.equals(this.id, v1ModifierList.id) && Objects.equals(this.name, v1ModifierList.name) && Objects.equals((Object)this.selectionType, (Object)v1ModifierList.selectionType) && Objects.equals(this.modifierOptions, v1ModifierList.modifierOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.selectionType, this.modifierOptions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ModifierList {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    selectionType: ").append(this.toIndentedString((Object)this.selectionType)).append("\n");
        sb.append("    modifierOptions: ").append(this.toIndentedString(this.modifierOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SelectionTypeEnum {
        SINGLE("SINGLE"),
        MULTIPLE("MULTIPLE");

        private String value;

        private SelectionTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SelectionTypeEnum fromValue(String text) {
            for (SelectionTypeEnum b : SelectionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

