/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Address;
import com.squareup.connect.models.Error;
import com.squareup.connect.models.V1Money;
import com.squareup.connect.models.V1OrderHistoryEntry;
import com.squareup.connect.models.V1Tender;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="V1Order")
public class V1Order {
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="buyer_email")
    private String buyerEmail = null;
    @JsonProperty(value="recipient_name")
    private String recipientName = null;
    @JsonProperty(value="recipient_phone_number")
    private String recipientPhoneNumber = null;
    @JsonProperty(value="state")
    private StateEnum state = null;
    @JsonProperty(value="shipping_address")
    private Address shippingAddress = null;
    @JsonProperty(value="subtotal_money")
    private V1Money subtotalMoney = null;
    @JsonProperty(value="total_shipping_money")
    private V1Money totalShippingMoney = null;
    @JsonProperty(value="total_tax_money")
    private V1Money totalTaxMoney = null;
    @JsonProperty(value="total_price_money")
    private V1Money totalPriceMoney = null;
    @JsonProperty(value="total_discount_money")
    private V1Money totalDiscountMoney = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="updated_at")
    private String updatedAt = null;
    @JsonProperty(value="expires_at")
    private String expiresAt = null;
    @JsonProperty(value="payment_id")
    private String paymentId = null;
    @JsonProperty(value="buyer_note")
    private String buyerNote = null;
    @JsonProperty(value="completed_note")
    private String completedNote = null;
    @JsonProperty(value="refunded_note")
    private String refundedNote = null;
    @JsonProperty(value="canceled_note")
    private String canceledNote = null;
    @JsonProperty(value="tender")
    private V1Tender tender = null;
    @JsonProperty(value="order_history")
    private List<V1OrderHistoryEntry> orderHistory = new ArrayList<V1OrderHistoryEntry>();
    @JsonProperty(value="promo_code")
    private String promoCode = null;
    @JsonProperty(value="btc_receive_address")
    private String btcReceiveAddress = null;
    @JsonProperty(value="btc_price_satoshi")
    private BigDecimal btcPriceSatoshi = null;

    public V1Order errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public V1Order addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public V1Order id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The order's unique identifier.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Order buyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
        return this;
    }

    @ApiModelProperty(value="The email address of the order's buyer.")
    public String getBuyerEmail() {
        return this.buyerEmail;
    }

    public void setBuyerEmail(String buyerEmail) {
        this.buyerEmail = buyerEmail;
    }

    public V1Order recipientName(String recipientName) {
        this.recipientName = recipientName;
        return this;
    }

    @ApiModelProperty(value="The name of the order's buyer.")
    public String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    public V1Order recipientPhoneNumber(String recipientPhoneNumber) {
        this.recipientPhoneNumber = recipientPhoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number to use for the order's delivery.")
    public String getRecipientPhoneNumber() {
        return this.recipientPhoneNumber;
    }

    public void setRecipientPhoneNumber(String recipientPhoneNumber) {
        this.recipientPhoneNumber = recipientPhoneNumber;
    }

    public V1Order state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="Whether the tax is an ADDITIVE tax or an INCLUSIVE tax. See [V1OrderState](#type-v1orderstate) for possible values")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public V1Order shippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @ApiModelProperty(value="The address to ship the order to.")
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public V1Order subtotalMoney(V1Money subtotalMoney) {
        this.subtotalMoney = subtotalMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of all items purchased in the order, before taxes and shipping.")
    public V1Money getSubtotalMoney() {
        return this.subtotalMoney;
    }

    public void setSubtotalMoney(V1Money subtotalMoney) {
        this.subtotalMoney = subtotalMoney;
    }

    public V1Order totalShippingMoney(V1Money totalShippingMoney) {
        this.totalShippingMoney = totalShippingMoney;
        return this;
    }

    @ApiModelProperty(value="The shipping cost for the order.")
    public V1Money getTotalShippingMoney() {
        return this.totalShippingMoney;
    }

    public void setTotalShippingMoney(V1Money totalShippingMoney) {
        this.totalShippingMoney = totalShippingMoney;
    }

    public V1Order totalTaxMoney(V1Money totalTaxMoney) {
        this.totalTaxMoney = totalTaxMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all taxes applied to the order.")
    public V1Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    public void setTotalTaxMoney(V1Money totalTaxMoney) {
        this.totalTaxMoney = totalTaxMoney;
    }

    public V1Order totalPriceMoney(V1Money totalPriceMoney) {
        this.totalPriceMoney = totalPriceMoney;
        return this;
    }

    @ApiModelProperty(value="The total cost of the order.")
    public V1Money getTotalPriceMoney() {
        return this.totalPriceMoney;
    }

    public void setTotalPriceMoney(V1Money totalPriceMoney) {
        this.totalPriceMoney = totalPriceMoney;
    }

    public V1Order totalDiscountMoney(V1Money totalDiscountMoney) {
        this.totalDiscountMoney = totalDiscountMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all discounts applied to the order.")
    public V1Money getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    public void setTotalDiscountMoney(V1Money totalDiscountMoney) {
        this.totalDiscountMoney = totalDiscountMoney;
    }

    public V1Order createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the order was created, in ISO 8601 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public V1Order updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="The time when the order was last modified, in ISO 8601 format.")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public V1Order expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(value="The time when the order expires if no action is taken, in ISO 8601 format.")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public V1Order paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the payment associated with the order.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public V1Order buyerNote(String buyerNote) {
        this.buyerNote = buyerNote;
        return this;
    }

    @ApiModelProperty(value="A note provided by the buyer when the order was created, if any.")
    public String getBuyerNote() {
        return this.buyerNote;
    }

    public void setBuyerNote(String buyerNote) {
        this.buyerNote = buyerNote;
    }

    public V1Order completedNote(String completedNote) {
        this.completedNote = completedNote;
        return this;
    }

    @ApiModelProperty(value="A note provided by the merchant when the order's state was set to COMPLETED, if any")
    public String getCompletedNote() {
        return this.completedNote;
    }

    public void setCompletedNote(String completedNote) {
        this.completedNote = completedNote;
    }

    public V1Order refundedNote(String refundedNote) {
        this.refundedNote = refundedNote;
        return this;
    }

    @ApiModelProperty(value="A note provided by the merchant when the order's state was set to REFUNDED, if any.")
    public String getRefundedNote() {
        return this.refundedNote;
    }

    public void setRefundedNote(String refundedNote) {
        this.refundedNote = refundedNote;
    }

    public V1Order canceledNote(String canceledNote) {
        this.canceledNote = canceledNote;
        return this;
    }

    @ApiModelProperty(value="A note provided by the merchant when the order's state was set to CANCELED, if any.")
    public String getCanceledNote() {
        return this.canceledNote;
    }

    public void setCanceledNote(String canceledNote) {
        this.canceledNote = canceledNote;
    }

    public V1Order tender(V1Tender tender) {
        this.tender = tender;
        return this;
    }

    @ApiModelProperty(value="The tender used to pay for the order.")
    public V1Tender getTender() {
        return this.tender;
    }

    public void setTender(V1Tender tender) {
        this.tender = tender;
    }

    public V1Order orderHistory(List<V1OrderHistoryEntry> orderHistory) {
        this.orderHistory = orderHistory;
        return this;
    }

    public V1Order addOrderHistoryItem(V1OrderHistoryEntry orderHistoryItem) {
        this.orderHistory.add(orderHistoryItem);
        return this;
    }

    @ApiModelProperty(value="The history of actions associated with the order.")
    public List<V1OrderHistoryEntry> getOrderHistory() {
        return this.orderHistory;
    }

    public void setOrderHistory(List<V1OrderHistoryEntry> orderHistory) {
        this.orderHistory = orderHistory;
    }

    public V1Order promoCode(String promoCode) {
        this.promoCode = promoCode;
        return this;
    }

    @ApiModelProperty(value="The promo code provided by the buyer, if any.")
    public String getPromoCode() {
        return this.promoCode;
    }

    public void setPromoCode(String promoCode) {
        this.promoCode = promoCode;
    }

    public V1Order btcReceiveAddress(String btcReceiveAddress) {
        this.btcReceiveAddress = btcReceiveAddress;
        return this;
    }

    @ApiModelProperty(value="For Bitcoin transactions, the address that the buyer sent Bitcoin to.")
    public String getBtcReceiveAddress() {
        return this.btcReceiveAddress;
    }

    public void setBtcReceiveAddress(String btcReceiveAddress) {
        this.btcReceiveAddress = btcReceiveAddress;
    }

    public V1Order btcPriceSatoshi(BigDecimal btcPriceSatoshi) {
        this.btcPriceSatoshi = btcPriceSatoshi;
        return this;
    }

    @ApiModelProperty(value="For Bitcoin transactions, the price of the buyer's order in satoshi (100 million satoshi equals 1 BTC).")
    public BigDecimal getBtcPriceSatoshi() {
        return this.btcPriceSatoshi;
    }

    public void setBtcPriceSatoshi(BigDecimal btcPriceSatoshi) {
        this.btcPriceSatoshi = btcPriceSatoshi;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Order v1Order = (V1Order)o;
        return Objects.equals(this.errors, v1Order.errors) && Objects.equals(this.id, v1Order.id) && Objects.equals(this.buyerEmail, v1Order.buyerEmail) && Objects.equals(this.recipientName, v1Order.recipientName) && Objects.equals(this.recipientPhoneNumber, v1Order.recipientPhoneNumber) && Objects.equals((Object)this.state, (Object)v1Order.state) && Objects.equals(this.shippingAddress, v1Order.shippingAddress) && Objects.equals(this.subtotalMoney, v1Order.subtotalMoney) && Objects.equals(this.totalShippingMoney, v1Order.totalShippingMoney) && Objects.equals(this.totalTaxMoney, v1Order.totalTaxMoney) && Objects.equals(this.totalPriceMoney, v1Order.totalPriceMoney) && Objects.equals(this.totalDiscountMoney, v1Order.totalDiscountMoney) && Objects.equals(this.createdAt, v1Order.createdAt) && Objects.equals(this.updatedAt, v1Order.updatedAt) && Objects.equals(this.expiresAt, v1Order.expiresAt) && Objects.equals(this.paymentId, v1Order.paymentId) && Objects.equals(this.buyerNote, v1Order.buyerNote) && Objects.equals(this.completedNote, v1Order.completedNote) && Objects.equals(this.refundedNote, v1Order.refundedNote) && Objects.equals(this.canceledNote, v1Order.canceledNote) && Objects.equals(this.tender, v1Order.tender) && Objects.equals(this.orderHistory, v1Order.orderHistory) && Objects.equals(this.promoCode, v1Order.promoCode) && Objects.equals(this.btcReceiveAddress, v1Order.btcReceiveAddress) && Objects.equals(this.btcPriceSatoshi, v1Order.btcPriceSatoshi);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errors, this.id, this.buyerEmail, this.recipientName, this.recipientPhoneNumber, this.state, this.shippingAddress, this.subtotalMoney, this.totalShippingMoney, this.totalTaxMoney, this.totalPriceMoney, this.totalDiscountMoney, this.createdAt, this.updatedAt, this.expiresAt, this.paymentId, this.buyerNote, this.completedNote, this.refundedNote, this.canceledNote, this.tender, this.orderHistory, this.promoCode, this.btcReceiveAddress, this.btcPriceSatoshi});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Order {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    buyerEmail: ").append(this.toIndentedString(this.buyerEmail)).append("\n");
        sb.append("    recipientName: ").append(this.toIndentedString(this.recipientName)).append("\n");
        sb.append("    recipientPhoneNumber: ").append(this.toIndentedString(this.recipientPhoneNumber)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    subtotalMoney: ").append(this.toIndentedString(this.subtotalMoney)).append("\n");
        sb.append("    totalShippingMoney: ").append(this.toIndentedString(this.totalShippingMoney)).append("\n");
        sb.append("    totalTaxMoney: ").append(this.toIndentedString(this.totalTaxMoney)).append("\n");
        sb.append("    totalPriceMoney: ").append(this.toIndentedString(this.totalPriceMoney)).append("\n");
        sb.append("    totalDiscountMoney: ").append(this.toIndentedString(this.totalDiscountMoney)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    buyerNote: ").append(this.toIndentedString(this.buyerNote)).append("\n");
        sb.append("    completedNote: ").append(this.toIndentedString(this.completedNote)).append("\n");
        sb.append("    refundedNote: ").append(this.toIndentedString(this.refundedNote)).append("\n");
        sb.append("    canceledNote: ").append(this.toIndentedString(this.canceledNote)).append("\n");
        sb.append("    tender: ").append(this.toIndentedString(this.tender)).append("\n");
        sb.append("    orderHistory: ").append(this.toIndentedString(this.orderHistory)).append("\n");
        sb.append("    promoCode: ").append(this.toIndentedString(this.promoCode)).append("\n");
        sb.append("    btcReceiveAddress: ").append(this.toIndentedString(this.btcReceiveAddress)).append("\n");
        sb.append("    btcPriceSatoshi: ").append(this.toIndentedString(this.btcPriceSatoshi)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        PENDING("PENDING"),
        OPEN("OPEN"),
        COMPLETED("COMPLETED"),
        CANCELED("CANCELED"),
        REFUNDED("REFUNDED"),
        REJECTED("REJECTED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String text) {
            for (StateEnum b : StateEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

