/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Device;
import com.squareup.connect.models.V1Money;
import com.squareup.connect.models.V1PaymentItemization;
import com.squareup.connect.models.V1PaymentSurcharge;
import com.squareup.connect.models.V1PaymentTax;
import com.squareup.connect.models.V1Refund;
import com.squareup.connect.models.V1Tender;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A payment represents a paid transaction between a Square merchant and a customer. Payment details are usually available from Connect API endpoints within a few minutes after the transaction completes.  Each Payment object includes several fields that end in `_money`. These fields describe the various amounts of money that contribute to the payment total:  <ul> <li> Monetary values are <b>positive</b> if they represent an <em>increase</em> in the amount of money the merchant receives (e.g., <code>tax_money</code>, <code>tip_money</code>). </li> <li> Monetary values are <b>negative</b> if they represent an <em>decrease</em> in the amount of money the merchant receives (e.g., <code>discount_money</code>, <code>refunded_money</code>). </li> </ul>")
public class V1Payment {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="merchant_id")
    private String merchantId = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="creator_id")
    private String creatorId = null;
    @JsonProperty(value="device")
    private Device device = null;
    @JsonProperty(value="payment_url")
    private String paymentUrl = null;
    @JsonProperty(value="receipt_url")
    private String receiptUrl = null;
    @JsonProperty(value="inclusive_tax_money")
    private V1Money inclusiveTaxMoney = null;
    @JsonProperty(value="additive_tax_money")
    private V1Money additiveTaxMoney = null;
    @JsonProperty(value="tax_money")
    private V1Money taxMoney = null;
    @JsonProperty(value="tip_money")
    private V1Money tipMoney = null;
    @JsonProperty(value="discount_money")
    private V1Money discountMoney = null;
    @JsonProperty(value="total_collected_money")
    private V1Money totalCollectedMoney = null;
    @JsonProperty(value="processing_fee_money")
    private V1Money processingFeeMoney = null;
    @JsonProperty(value="net_total_money")
    private V1Money netTotalMoney = null;
    @JsonProperty(value="refunded_money")
    private V1Money refundedMoney = null;
    @JsonProperty(value="swedish_rounding_money")
    private V1Money swedishRoundingMoney = null;
    @JsonProperty(value="gross_sales_money")
    private V1Money grossSalesMoney = null;
    @JsonProperty(value="net_sales_money")
    private V1Money netSalesMoney = null;
    @JsonProperty(value="inclusive_tax")
    private List<V1PaymentTax> inclusiveTax = new ArrayList<V1PaymentTax>();
    @JsonProperty(value="additive_tax")
    private List<V1PaymentTax> additiveTax = new ArrayList<V1PaymentTax>();
    @JsonProperty(value="tender")
    private List<V1Tender> tender = new ArrayList<V1Tender>();
    @JsonProperty(value="refunds")
    private List<V1Refund> refunds = new ArrayList<V1Refund>();
    @JsonProperty(value="itemizations")
    private List<V1PaymentItemization> itemizations = new ArrayList<V1PaymentItemization>();
    @JsonProperty(value="surcharge_money")
    private V1Money surchargeMoney = null;
    @JsonProperty(value="surcharges")
    private List<V1PaymentSurcharge> surcharges = new ArrayList<V1PaymentSurcharge>();
    @JsonProperty(value="is_partial")
    private Boolean isPartial = null;

    public V1Payment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The payment's unique identifier.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Payment merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the merchant that took the payment.")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public V1Payment createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the payment was created, in ISO 8601 format. Reflects the time of the first payment if the object represents an incomplete partial payment, and the time of the last or complete payment otherwise.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public V1Payment creatorId(String creatorId) {
        this.creatorId = creatorId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the Square account that took the payment.")
    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public V1Payment device(Device device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(value="The device that took the payment.")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public V1Payment paymentUrl(String paymentUrl) {
        this.paymentUrl = paymentUrl;
        return this;
    }

    @ApiModelProperty(value="The URL of the payment's detail page in the merchant dashboard. The merchant must be signed in to the merchant dashboard to view this page.")
    public String getPaymentUrl() {
        return this.paymentUrl;
    }

    public void setPaymentUrl(String paymentUrl) {
        this.paymentUrl = paymentUrl;
    }

    public V1Payment receiptUrl(String receiptUrl) {
        this.receiptUrl = receiptUrl;
        return this;
    }

    @ApiModelProperty(value="The URL of the receipt for the payment. Note that for split tender payments, this URL corresponds to the receipt for the first tender listed in the payment's tender field. Each Tender object has its own receipt_url field you can use to get the other receipts associated with a split tender payment.")
    public String getReceiptUrl() {
        return this.receiptUrl;
    }

    public void setReceiptUrl(String receiptUrl) {
        this.receiptUrl = receiptUrl;
    }

    public V1Payment inclusiveTaxMoney(V1Money inclusiveTaxMoney) {
        this.inclusiveTaxMoney = inclusiveTaxMoney;
        return this;
    }

    @ApiModelProperty(value="The sum of all inclusive taxes associated with the payment.")
    public V1Money getInclusiveTaxMoney() {
        return this.inclusiveTaxMoney;
    }

    public void setInclusiveTaxMoney(V1Money inclusiveTaxMoney) {
        this.inclusiveTaxMoney = inclusiveTaxMoney;
    }

    public V1Payment additiveTaxMoney(V1Money additiveTaxMoney) {
        this.additiveTaxMoney = additiveTaxMoney;
        return this;
    }

    @ApiModelProperty(value="The sum of all additive taxes associated with the payment.")
    public V1Money getAdditiveTaxMoney() {
        return this.additiveTaxMoney;
    }

    public void setAdditiveTaxMoney(V1Money additiveTaxMoney) {
        this.additiveTaxMoney = additiveTaxMoney;
    }

    public V1Payment taxMoney(V1Money taxMoney) {
        this.taxMoney = taxMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all taxes applied to the payment. This is always the sum of inclusive_tax_money and additive_tax_money.")
    public V1Money getTaxMoney() {
        return this.taxMoney;
    }

    public void setTaxMoney(V1Money taxMoney) {
        this.taxMoney = taxMoney;
    }

    public V1Payment tipMoney(V1Money tipMoney) {
        this.tipMoney = tipMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all tips applied to the payment.")
    public V1Money getTipMoney() {
        return this.tipMoney;
    }

    public void setTipMoney(V1Money tipMoney) {
        this.tipMoney = tipMoney;
    }

    public V1Payment discountMoney(V1Money discountMoney) {
        this.discountMoney = discountMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all discounts applied to the payment.")
    public V1Money getDiscountMoney() {
        return this.discountMoney;
    }

    public void setDiscountMoney(V1Money discountMoney) {
        this.discountMoney = discountMoney;
    }

    public V1Payment totalCollectedMoney(V1Money totalCollectedMoney) {
        this.totalCollectedMoney = totalCollectedMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all discounts applied to the payment.")
    public V1Money getTotalCollectedMoney() {
        return this.totalCollectedMoney;
    }

    public void setTotalCollectedMoney(V1Money totalCollectedMoney) {
        this.totalCollectedMoney = totalCollectedMoney;
    }

    public V1Payment processingFeeMoney(V1Money processingFeeMoney) {
        this.processingFeeMoney = processingFeeMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all processing fees collected by Square for the payment.")
    public V1Money getProcessingFeeMoney() {
        return this.processingFeeMoney;
    }

    public void setProcessingFeeMoney(V1Money processingFeeMoney) {
        this.processingFeeMoney = processingFeeMoney;
    }

    public V1Payment netTotalMoney(V1Money netTotalMoney) {
        this.netTotalMoney = netTotalMoney;
        return this;
    }

    @ApiModelProperty(value="The amount to be deposited into the merchant's bank account for the payment.")
    public V1Money getNetTotalMoney() {
        return this.netTotalMoney;
    }

    public void setNetTotalMoney(V1Money netTotalMoney) {
        this.netTotalMoney = netTotalMoney;
    }

    public V1Payment refundedMoney(V1Money refundedMoney) {
        this.refundedMoney = refundedMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all refunds applied to the payment.")
    public V1Money getRefundedMoney() {
        return this.refundedMoney;
    }

    public void setRefundedMoney(V1Money refundedMoney) {
        this.refundedMoney = refundedMoney;
    }

    public V1Payment swedishRoundingMoney(V1Money swedishRoundingMoney) {
        this.swedishRoundingMoney = swedishRoundingMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all sales, including any applicable taxes, rounded to the smallest legal unit of currency (e.g., the nearest penny in USD, the nearest nickel in CAD)")
    public V1Money getSwedishRoundingMoney() {
        return this.swedishRoundingMoney;
    }

    public void setSwedishRoundingMoney(V1Money swedishRoundingMoney) {
        this.swedishRoundingMoney = swedishRoundingMoney;
    }

    public V1Payment grossSalesMoney(V1Money grossSalesMoney) {
        this.grossSalesMoney = grossSalesMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all sales, including any applicable taxes.")
    public V1Money getGrossSalesMoney() {
        return this.grossSalesMoney;
    }

    public void setGrossSalesMoney(V1Money grossSalesMoney) {
        this.grossSalesMoney = grossSalesMoney;
    }

    public V1Payment netSalesMoney(V1Money netSalesMoney) {
        this.netSalesMoney = netSalesMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all sales, minus any applicable taxes.")
    public V1Money getNetSalesMoney() {
        return this.netSalesMoney;
    }

    public void setNetSalesMoney(V1Money netSalesMoney) {
        this.netSalesMoney = netSalesMoney;
    }

    public V1Payment inclusiveTax(List<V1PaymentTax> inclusiveTax) {
        this.inclusiveTax = inclusiveTax;
        return this;
    }

    public V1Payment addInclusiveTaxItem(V1PaymentTax inclusiveTaxItem) {
        this.inclusiveTax.add(inclusiveTaxItem);
        return this;
    }

    @ApiModelProperty(value="All of the inclusive taxes associated with the payment.")
    public List<V1PaymentTax> getInclusiveTax() {
        return this.inclusiveTax;
    }

    public void setInclusiveTax(List<V1PaymentTax> inclusiveTax) {
        this.inclusiveTax = inclusiveTax;
    }

    public V1Payment additiveTax(List<V1PaymentTax> additiveTax) {
        this.additiveTax = additiveTax;
        return this;
    }

    public V1Payment addAdditiveTaxItem(V1PaymentTax additiveTaxItem) {
        this.additiveTax.add(additiveTaxItem);
        return this;
    }

    @ApiModelProperty(value="All of the additive taxes associated with the payment.")
    public List<V1PaymentTax> getAdditiveTax() {
        return this.additiveTax;
    }

    public void setAdditiveTax(List<V1PaymentTax> additiveTax) {
        this.additiveTax = additiveTax;
    }

    public V1Payment tender(List<V1Tender> tender) {
        this.tender = tender;
        return this;
    }

    public V1Payment addTenderItem(V1Tender tenderItem) {
        this.tender.add(tenderItem);
        return this;
    }

    @ApiModelProperty(value="All of the tenders associated with the payment.")
    public List<V1Tender> getTender() {
        return this.tender;
    }

    public void setTender(List<V1Tender> tender) {
        this.tender = tender;
    }

    public V1Payment refunds(List<V1Refund> refunds) {
        this.refunds = refunds;
        return this;
    }

    public V1Payment addRefundsItem(V1Refund refundsItem) {
        this.refunds.add(refundsItem);
        return this;
    }

    @ApiModelProperty(value="All of the refunds applied to the payment. Note that the value of all refunds on a payment can exceed the value of all tenders if a merchant chooses to refund money to a tender after previously accepting returned goods as part of an exchange.")
    public List<V1Refund> getRefunds() {
        return this.refunds;
    }

    public void setRefunds(List<V1Refund> refunds) {
        this.refunds = refunds;
    }

    public V1Payment itemizations(List<V1PaymentItemization> itemizations) {
        this.itemizations = itemizations;
        return this;
    }

    public V1Payment addItemizationsItem(V1PaymentItemization itemizationsItem) {
        this.itemizations.add(itemizationsItem);
        return this;
    }

    @ApiModelProperty(value="The items purchased in the payment.")
    public List<V1PaymentItemization> getItemizations() {
        return this.itemizations;
    }

    public void setItemizations(List<V1PaymentItemization> itemizations) {
        this.itemizations = itemizations;
    }

    public V1Payment surchargeMoney(V1Money surchargeMoney) {
        this.surchargeMoney = surchargeMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all surcharges applied to the payment.")
    public V1Money getSurchargeMoney() {
        return this.surchargeMoney;
    }

    public void setSurchargeMoney(V1Money surchargeMoney) {
        this.surchargeMoney = surchargeMoney;
    }

    public V1Payment surcharges(List<V1PaymentSurcharge> surcharges) {
        this.surcharges = surcharges;
        return this;
    }

    public V1Payment addSurchargesItem(V1PaymentSurcharge surchargesItem) {
        this.surcharges.add(surchargesItem);
        return this;
    }

    @ApiModelProperty(value="A list of all surcharges associated with the payment.")
    public List<V1PaymentSurcharge> getSurcharges() {
        return this.surcharges;
    }

    public void setSurcharges(List<V1PaymentSurcharge> surcharges) {
        this.surcharges = surcharges;
    }

    public V1Payment isPartial(Boolean isPartial) {
        this.isPartial = isPartial;
        return this;
    }

    @ApiModelProperty(value="Indicates whether or not the payment is only partially paid for. If true, this payment will have the tenders collected so far, but the itemizations will be empty until the payment is completed.")
    public Boolean getIsPartial() {
        return this.isPartial;
    }

    public void setIsPartial(Boolean isPartial) {
        this.isPartial = isPartial;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Payment v1Payment = (V1Payment)o;
        return Objects.equals(this.id, v1Payment.id) && Objects.equals(this.merchantId, v1Payment.merchantId) && Objects.equals(this.createdAt, v1Payment.createdAt) && Objects.equals(this.creatorId, v1Payment.creatorId) && Objects.equals(this.device, v1Payment.device) && Objects.equals(this.paymentUrl, v1Payment.paymentUrl) && Objects.equals(this.receiptUrl, v1Payment.receiptUrl) && Objects.equals(this.inclusiveTaxMoney, v1Payment.inclusiveTaxMoney) && Objects.equals(this.additiveTaxMoney, v1Payment.additiveTaxMoney) && Objects.equals(this.taxMoney, v1Payment.taxMoney) && Objects.equals(this.tipMoney, v1Payment.tipMoney) && Objects.equals(this.discountMoney, v1Payment.discountMoney) && Objects.equals(this.totalCollectedMoney, v1Payment.totalCollectedMoney) && Objects.equals(this.processingFeeMoney, v1Payment.processingFeeMoney) && Objects.equals(this.netTotalMoney, v1Payment.netTotalMoney) && Objects.equals(this.refundedMoney, v1Payment.refundedMoney) && Objects.equals(this.swedishRoundingMoney, v1Payment.swedishRoundingMoney) && Objects.equals(this.grossSalesMoney, v1Payment.grossSalesMoney) && Objects.equals(this.netSalesMoney, v1Payment.netSalesMoney) && Objects.equals(this.inclusiveTax, v1Payment.inclusiveTax) && Objects.equals(this.additiveTax, v1Payment.additiveTax) && Objects.equals(this.tender, v1Payment.tender) && Objects.equals(this.refunds, v1Payment.refunds) && Objects.equals(this.itemizations, v1Payment.itemizations) && Objects.equals(this.surchargeMoney, v1Payment.surchargeMoney) && Objects.equals(this.surcharges, v1Payment.surcharges) && Objects.equals(this.isPartial, v1Payment.isPartial);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.merchantId, this.createdAt, this.creatorId, this.device, this.paymentUrl, this.receiptUrl, this.inclusiveTaxMoney, this.additiveTaxMoney, this.taxMoney, this.tipMoney, this.discountMoney, this.totalCollectedMoney, this.processingFeeMoney, this.netTotalMoney, this.refundedMoney, this.swedishRoundingMoney, this.grossSalesMoney, this.netSalesMoney, this.inclusiveTax, this.additiveTax, this.tender, this.refunds, this.itemizations, this.surchargeMoney, this.surcharges, this.isPartial);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Payment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    creatorId: ").append(this.toIndentedString(this.creatorId)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    paymentUrl: ").append(this.toIndentedString(this.paymentUrl)).append("\n");
        sb.append("    receiptUrl: ").append(this.toIndentedString(this.receiptUrl)).append("\n");
        sb.append("    inclusiveTaxMoney: ").append(this.toIndentedString(this.inclusiveTaxMoney)).append("\n");
        sb.append("    additiveTaxMoney: ").append(this.toIndentedString(this.additiveTaxMoney)).append("\n");
        sb.append("    taxMoney: ").append(this.toIndentedString(this.taxMoney)).append("\n");
        sb.append("    tipMoney: ").append(this.toIndentedString(this.tipMoney)).append("\n");
        sb.append("    discountMoney: ").append(this.toIndentedString(this.discountMoney)).append("\n");
        sb.append("    totalCollectedMoney: ").append(this.toIndentedString(this.totalCollectedMoney)).append("\n");
        sb.append("    processingFeeMoney: ").append(this.toIndentedString(this.processingFeeMoney)).append("\n");
        sb.append("    netTotalMoney: ").append(this.toIndentedString(this.netTotalMoney)).append("\n");
        sb.append("    refundedMoney: ").append(this.toIndentedString(this.refundedMoney)).append("\n");
        sb.append("    swedishRoundingMoney: ").append(this.toIndentedString(this.swedishRoundingMoney)).append("\n");
        sb.append("    grossSalesMoney: ").append(this.toIndentedString(this.grossSalesMoney)).append("\n");
        sb.append("    netSalesMoney: ").append(this.toIndentedString(this.netSalesMoney)).append("\n");
        sb.append("    inclusiveTax: ").append(this.toIndentedString(this.inclusiveTax)).append("\n");
        sb.append("    additiveTax: ").append(this.toIndentedString(this.additiveTax)).append("\n");
        sb.append("    tender: ").append(this.toIndentedString(this.tender)).append("\n");
        sb.append("    refunds: ").append(this.toIndentedString(this.refunds)).append("\n");
        sb.append("    itemizations: ").append(this.toIndentedString(this.itemizations)).append("\n");
        sb.append("    surchargeMoney: ").append(this.toIndentedString(this.surchargeMoney)).append("\n");
        sb.append("    surcharges: ").append(this.toIndentedString(this.surcharges)).append("\n");
        sb.append("    isPartial: ").append(this.toIndentedString(this.isPartial)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

