/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import com.squareup.connect.models.V1PaymentTax;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="V1PaymentSurcharge")
public class V1PaymentSurcharge {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="applied_money")
    private V1Money appliedMoney = null;
    @JsonProperty(value="rate")
    private String rate = null;
    @JsonProperty(value="amount_money")
    private V1Money amountMoney = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="taxable")
    private Boolean taxable = null;
    @JsonProperty(value="taxes")
    private List<V1PaymentTax> taxes = new ArrayList<V1PaymentTax>();
    @JsonProperty(value="surcharge_id")
    private String surchargeId = null;

    public V1PaymentSurcharge name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the surcharge.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1PaymentSurcharge appliedMoney(V1Money appliedMoney) {
        this.appliedMoney = appliedMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money applied to the order as a result of the surcharge.")
    public V1Money getAppliedMoney() {
        return this.appliedMoney;
    }

    public void setAppliedMoney(V1Money appliedMoney) {
        this.appliedMoney = appliedMoney;
    }

    public V1PaymentSurcharge rate(String rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(value="The amount of the surcharge as a percentage. The percentage is provided as a string representing the decimal equivalent of the percentage. For example, \"0.7\" corresponds to a 7% surcharge. Exactly one of rate or amount_money should be set.")
    public String getRate() {
        return this.rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public V1PaymentSurcharge amountMoney(V1Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of the surcharge as a Money object. Exactly one of rate or amount_money should be set.")
    public V1Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(V1Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public V1PaymentSurcharge type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Indicates the source of the surcharge. For example, if it was applied as an automatic gratuity for a large group. See [V1PaymentSurchargeType](#type-v1paymentsurchargetype) for possible values")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public V1PaymentSurcharge taxable(Boolean taxable) {
        this.taxable = taxable;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the surcharge is taxable.")
    public Boolean getTaxable() {
        return this.taxable;
    }

    public void setTaxable(Boolean taxable) {
        this.taxable = taxable;
    }

    public V1PaymentSurcharge taxes(List<V1PaymentTax> taxes) {
        this.taxes = taxes;
        return this;
    }

    public V1PaymentSurcharge addTaxesItem(V1PaymentTax taxesItem) {
        this.taxes.add(taxesItem);
        return this;
    }

    @ApiModelProperty(value="The list of taxes that should be applied to the surcharge.")
    public List<V1PaymentTax> getTaxes() {
        return this.taxes;
    }

    public void setTaxes(List<V1PaymentTax> taxes) {
        this.taxes = taxes;
    }

    public V1PaymentSurcharge surchargeId(String surchargeId) {
        this.surchargeId = surchargeId;
        return this;
    }

    @ApiModelProperty(value="A Square-issued unique identifier associated with the surcharge.")
    public String getSurchargeId() {
        return this.surchargeId;
    }

    public void setSurchargeId(String surchargeId) {
        this.surchargeId = surchargeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PaymentSurcharge v1PaymentSurcharge = (V1PaymentSurcharge)o;
        return Objects.equals(this.name, v1PaymentSurcharge.name) && Objects.equals(this.appliedMoney, v1PaymentSurcharge.appliedMoney) && Objects.equals(this.rate, v1PaymentSurcharge.rate) && Objects.equals(this.amountMoney, v1PaymentSurcharge.amountMoney) && Objects.equals((Object)this.type, (Object)v1PaymentSurcharge.type) && Objects.equals(this.taxable, v1PaymentSurcharge.taxable) && Objects.equals(this.taxes, v1PaymentSurcharge.taxes) && Objects.equals(this.surchargeId, v1PaymentSurcharge.surchargeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.appliedMoney, this.rate, this.amountMoney, this.type, this.taxable, this.taxes, this.surchargeId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PaymentSurcharge {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    appliedMoney: ").append(this.toIndentedString(this.appliedMoney)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    taxable: ").append(this.toIndentedString(this.taxable)).append("\n");
        sb.append("    taxes: ").append(this.toIndentedString(this.taxes)).append("\n");
        sb.append("    surchargeId: ").append(this.toIndentedString(this.surchargeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        UNKNOWN("UNKNOWN"),
        AUTO_GRATUITY("AUTO_GRATUITY"),
        CUSTOM("CUSTOM");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

