/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Error;
import com.squareup.connect.models.V1Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="V1PaymentTax")
public class V1PaymentTax {
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="applied_money")
    private V1Money appliedMoney = null;
    @JsonProperty(value="rate")
    private String rate = null;
    @JsonProperty(value="inclusion_type")
    private InclusionTypeEnum inclusionType = null;
    @JsonProperty(value="fee_id")
    private String feeId = null;

    public V1PaymentTax errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public V1PaymentTax addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public V1PaymentTax name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The merchant-defined name of the tax.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1PaymentTax appliedMoney(V1Money appliedMoney) {
        this.appliedMoney = appliedMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money that this tax adds to the payment.")
    public V1Money getAppliedMoney() {
        return this.appliedMoney;
    }

    public void setAppliedMoney(V1Money appliedMoney) {
        this.appliedMoney = appliedMoney;
    }

    public V1PaymentTax rate(String rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(value="The rate of the tax, as a string representation of a decimal number. A value of 0.07 corresponds to a rate of 7%.")
    public String getRate() {
        return this.rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public V1PaymentTax inclusionType(InclusionTypeEnum inclusionType) {
        this.inclusionType = inclusionType;
        return this;
    }

    @ApiModelProperty(value="Whether the tax is an ADDITIVE tax or an INCLUSIVE tax. See [V1PaymentTaxInclusionType](#type-v1paymenttaxinclusiontype) for possible values")
    public InclusionTypeEnum getInclusionType() {
        return this.inclusionType;
    }

    public void setInclusionType(InclusionTypeEnum inclusionType) {
        this.inclusionType = inclusionType;
    }

    public V1PaymentTax feeId(String feeId) {
        this.feeId = feeId;
        return this;
    }

    @ApiModelProperty(value="The ID of the tax, if available. Taxes applied in older versions of Square Register might not have an ID.")
    public String getFeeId() {
        return this.feeId;
    }

    public void setFeeId(String feeId) {
        this.feeId = feeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PaymentTax v1PaymentTax = (V1PaymentTax)o;
        return Objects.equals(this.errors, v1PaymentTax.errors) && Objects.equals(this.name, v1PaymentTax.name) && Objects.equals(this.appliedMoney, v1PaymentTax.appliedMoney) && Objects.equals(this.rate, v1PaymentTax.rate) && Objects.equals((Object)this.inclusionType, (Object)v1PaymentTax.inclusionType) && Objects.equals(this.feeId, v1PaymentTax.feeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errors, this.name, this.appliedMoney, this.rate, this.inclusionType, this.feeId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PaymentTax {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    appliedMoney: ").append(this.toIndentedString(this.appliedMoney)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    inclusionType: ").append(this.toIndentedString((Object)this.inclusionType)).append("\n");
        sb.append("    feeId: ").append(this.toIndentedString(this.feeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InclusionTypeEnum {
        ADDITIVE("ADDITIVE"),
        INCLUSIVE("INCLUSIVE");

        private String value;

        private InclusionTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InclusionTypeEnum fromValue(String text) {
            for (InclusionTypeEnum b : InclusionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

