/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import com.squareup.connect.models.V1PaymentSurcharge;
import com.squareup.connect.models.V1PaymentTax;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="V1Refund")
public class V1Refund {
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="refunded_money")
    private V1Money refundedMoney = null;
    @JsonProperty(value="refunded_processing_fee_money")
    private V1Money refundedProcessingFeeMoney = null;
    @JsonProperty(value="refunded_tax_money")
    private V1Money refundedTaxMoney = null;
    @JsonProperty(value="refunded_additive_tax_money")
    private V1Money refundedAdditiveTaxMoney = null;
    @JsonProperty(value="refunded_additive_tax")
    private List<V1PaymentTax> refundedAdditiveTax = new ArrayList<V1PaymentTax>();
    @JsonProperty(value="refunded_inclusive_tax_money")
    private V1Money refundedInclusiveTaxMoney = null;
    @JsonProperty(value="refunded_inclusive_tax")
    private List<V1PaymentTax> refundedInclusiveTax = new ArrayList<V1PaymentTax>();
    @JsonProperty(value="refunded_tip_money")
    private V1Money refundedTipMoney = null;
    @JsonProperty(value="refunded_discount_money")
    private V1Money refundedDiscountMoney = null;
    @JsonProperty(value="refunded_surcharge_money")
    private V1Money refundedSurchargeMoney = null;
    @JsonProperty(value="refunded_surcharges")
    private List<V1PaymentSurcharge> refundedSurcharges = new ArrayList<V1PaymentSurcharge>();
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="processed_at")
    private String processedAt = null;
    @JsonProperty(value="payment_id")
    private String paymentId = null;
    @JsonProperty(value="merchant_id")
    private String merchantId = null;
    @JsonProperty(value="is_exchange")
    private Boolean isExchange = null;

    public V1Refund type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of refund See [V1RefundType](#type-v1refundtype) for possible values")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public V1Refund reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The merchant-specified reason for the refund.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1Refund refundedMoney(V1Money refundedMoney) {
        this.refundedMoney = refundedMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money refunded. This amount is always negative.")
    public V1Money getRefundedMoney() {
        return this.refundedMoney;
    }

    public void setRefundedMoney(V1Money refundedMoney) {
        this.refundedMoney = refundedMoney;
    }

    public V1Refund refundedProcessingFeeMoney(V1Money refundedProcessingFeeMoney) {
        this.refundedProcessingFeeMoney = refundedProcessingFeeMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of processing fee money refunded. This amount is always positive.")
    public V1Money getRefundedProcessingFeeMoney() {
        return this.refundedProcessingFeeMoney;
    }

    public void setRefundedProcessingFeeMoney(V1Money refundedProcessingFeeMoney) {
        this.refundedProcessingFeeMoney = refundedProcessingFeeMoney;
    }

    public V1Refund refundedTaxMoney(V1Money refundedTaxMoney) {
        this.refundedTaxMoney = refundedTaxMoney;
        return this;
    }

    @ApiModelProperty(value="The total amount of tax money refunded. This amount is always negative.")
    public V1Money getRefundedTaxMoney() {
        return this.refundedTaxMoney;
    }

    public void setRefundedTaxMoney(V1Money refundedTaxMoney) {
        this.refundedTaxMoney = refundedTaxMoney;
    }

    public V1Refund refundedAdditiveTaxMoney(V1Money refundedAdditiveTaxMoney) {
        this.refundedAdditiveTaxMoney = refundedAdditiveTaxMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of additive tax money refunded. This amount is always negative.")
    public V1Money getRefundedAdditiveTaxMoney() {
        return this.refundedAdditiveTaxMoney;
    }

    public void setRefundedAdditiveTaxMoney(V1Money refundedAdditiveTaxMoney) {
        this.refundedAdditiveTaxMoney = refundedAdditiveTaxMoney;
    }

    public V1Refund refundedAdditiveTax(List<V1PaymentTax> refundedAdditiveTax) {
        this.refundedAdditiveTax = refundedAdditiveTax;
        return this;
    }

    public V1Refund addRefundedAdditiveTaxItem(V1PaymentTax refundedAdditiveTaxItem) {
        this.refundedAdditiveTax.add(refundedAdditiveTaxItem);
        return this;
    }

    @ApiModelProperty(value="All of the additive taxes associated with the refund.")
    public List<V1PaymentTax> getRefundedAdditiveTax() {
        return this.refundedAdditiveTax;
    }

    public void setRefundedAdditiveTax(List<V1PaymentTax> refundedAdditiveTax) {
        this.refundedAdditiveTax = refundedAdditiveTax;
    }

    public V1Refund refundedInclusiveTaxMoney(V1Money refundedInclusiveTaxMoney) {
        this.refundedInclusiveTaxMoney = refundedInclusiveTaxMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of inclusive tax money refunded. This amount is always negative.")
    public V1Money getRefundedInclusiveTaxMoney() {
        return this.refundedInclusiveTaxMoney;
    }

    public void setRefundedInclusiveTaxMoney(V1Money refundedInclusiveTaxMoney) {
        this.refundedInclusiveTaxMoney = refundedInclusiveTaxMoney;
    }

    public V1Refund refundedInclusiveTax(List<V1PaymentTax> refundedInclusiveTax) {
        this.refundedInclusiveTax = refundedInclusiveTax;
        return this;
    }

    public V1Refund addRefundedInclusiveTaxItem(V1PaymentTax refundedInclusiveTaxItem) {
        this.refundedInclusiveTax.add(refundedInclusiveTaxItem);
        return this;
    }

    @ApiModelProperty(value="All of the inclusive taxes associated with the refund.")
    public List<V1PaymentTax> getRefundedInclusiveTax() {
        return this.refundedInclusiveTax;
    }

    public void setRefundedInclusiveTax(List<V1PaymentTax> refundedInclusiveTax) {
        this.refundedInclusiveTax = refundedInclusiveTax;
    }

    public V1Refund refundedTipMoney(V1Money refundedTipMoney) {
        this.refundedTipMoney = refundedTipMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of tip money refunded. This amount is always negative.")
    public V1Money getRefundedTipMoney() {
        return this.refundedTipMoney;
    }

    public void setRefundedTipMoney(V1Money refundedTipMoney) {
        this.refundedTipMoney = refundedTipMoney;
    }

    public V1Refund refundedDiscountMoney(V1Money refundedDiscountMoney) {
        this.refundedDiscountMoney = refundedDiscountMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of discount money refunded. This amount is always positive.")
    public V1Money getRefundedDiscountMoney() {
        return this.refundedDiscountMoney;
    }

    public void setRefundedDiscountMoney(V1Money refundedDiscountMoney) {
        this.refundedDiscountMoney = refundedDiscountMoney;
    }

    public V1Refund refundedSurchargeMoney(V1Money refundedSurchargeMoney) {
        this.refundedSurchargeMoney = refundedSurchargeMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of surcharge money refunded. This amount is always negative.")
    public V1Money getRefundedSurchargeMoney() {
        return this.refundedSurchargeMoney;
    }

    public void setRefundedSurchargeMoney(V1Money refundedSurchargeMoney) {
        this.refundedSurchargeMoney = refundedSurchargeMoney;
    }

    public V1Refund refundedSurcharges(List<V1PaymentSurcharge> refundedSurcharges) {
        this.refundedSurcharges = refundedSurcharges;
        return this;
    }

    public V1Refund addRefundedSurchargesItem(V1PaymentSurcharge refundedSurchargesItem) {
        this.refundedSurcharges.add(refundedSurchargesItem);
        return this;
    }

    @ApiModelProperty(value="A list of all surcharges associated with the refund.")
    public List<V1PaymentSurcharge> getRefundedSurcharges() {
        return this.refundedSurcharges;
    }

    public void setRefundedSurcharges(List<V1PaymentSurcharge> refundedSurcharges) {
        this.refundedSurcharges = refundedSurcharges;
    }

    public V1Refund createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the merchant initiated the refund for Square to process, in ISO 8601 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public V1Refund processedAt(String processedAt) {
        this.processedAt = processedAt;
        return this;
    }

    @ApiModelProperty(value="The time when Square processed the refund on behalf of the merchant, in ISO 8601 format.")
    public String getProcessedAt() {
        return this.processedAt;
    }

    public void setProcessedAt(String processedAt) {
        this.processedAt = processedAt;
    }

    public V1Refund paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(value="A Square-issued ID associated with the refund. For single-tender refunds, payment_id is the ID of the original payment ID. For split-tender refunds, payment_id is the ID of the original tender. For exchange-based refunds (is_exchange == true), payment_id is the ID of the original payment ID even if the payment includes other tenders.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public V1Refund merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public V1Refund isExchange(Boolean isExchange) {
        this.isExchange = isExchange;
        return this;
    }

    @ApiModelProperty(value="Indicates whether or not the refund is associated with an exchange. If is_exchange is true, the refund reflects the value of goods returned in the exchange not the total money refunded.")
    public Boolean getIsExchange() {
        return this.isExchange;
    }

    public void setIsExchange(Boolean isExchange) {
        this.isExchange = isExchange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Refund v1Refund = (V1Refund)o;
        return Objects.equals((Object)this.type, (Object)v1Refund.type) && Objects.equals(this.reason, v1Refund.reason) && Objects.equals(this.refundedMoney, v1Refund.refundedMoney) && Objects.equals(this.refundedProcessingFeeMoney, v1Refund.refundedProcessingFeeMoney) && Objects.equals(this.refundedTaxMoney, v1Refund.refundedTaxMoney) && Objects.equals(this.refundedAdditiveTaxMoney, v1Refund.refundedAdditiveTaxMoney) && Objects.equals(this.refundedAdditiveTax, v1Refund.refundedAdditiveTax) && Objects.equals(this.refundedInclusiveTaxMoney, v1Refund.refundedInclusiveTaxMoney) && Objects.equals(this.refundedInclusiveTax, v1Refund.refundedInclusiveTax) && Objects.equals(this.refundedTipMoney, v1Refund.refundedTipMoney) && Objects.equals(this.refundedDiscountMoney, v1Refund.refundedDiscountMoney) && Objects.equals(this.refundedSurchargeMoney, v1Refund.refundedSurchargeMoney) && Objects.equals(this.refundedSurcharges, v1Refund.refundedSurcharges) && Objects.equals(this.createdAt, v1Refund.createdAt) && Objects.equals(this.processedAt, v1Refund.processedAt) && Objects.equals(this.paymentId, v1Refund.paymentId) && Objects.equals(this.merchantId, v1Refund.merchantId) && Objects.equals(this.isExchange, v1Refund.isExchange);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.reason, this.refundedMoney, this.refundedProcessingFeeMoney, this.refundedTaxMoney, this.refundedAdditiveTaxMoney, this.refundedAdditiveTax, this.refundedInclusiveTaxMoney, this.refundedInclusiveTax, this.refundedTipMoney, this.refundedDiscountMoney, this.refundedSurchargeMoney, this.refundedSurcharges, this.createdAt, this.processedAt, this.paymentId, this.merchantId, this.isExchange});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Refund {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    refundedMoney: ").append(this.toIndentedString(this.refundedMoney)).append("\n");
        sb.append("    refundedProcessingFeeMoney: ").append(this.toIndentedString(this.refundedProcessingFeeMoney)).append("\n");
        sb.append("    refundedTaxMoney: ").append(this.toIndentedString(this.refundedTaxMoney)).append("\n");
        sb.append("    refundedAdditiveTaxMoney: ").append(this.toIndentedString(this.refundedAdditiveTaxMoney)).append("\n");
        sb.append("    refundedAdditiveTax: ").append(this.toIndentedString(this.refundedAdditiveTax)).append("\n");
        sb.append("    refundedInclusiveTaxMoney: ").append(this.toIndentedString(this.refundedInclusiveTaxMoney)).append("\n");
        sb.append("    refundedInclusiveTax: ").append(this.toIndentedString(this.refundedInclusiveTax)).append("\n");
        sb.append("    refundedTipMoney: ").append(this.toIndentedString(this.refundedTipMoney)).append("\n");
        sb.append("    refundedDiscountMoney: ").append(this.toIndentedString(this.refundedDiscountMoney)).append("\n");
        sb.append("    refundedSurchargeMoney: ").append(this.toIndentedString(this.refundedSurchargeMoney)).append("\n");
        sb.append("    refundedSurcharges: ").append(this.toIndentedString(this.refundedSurcharges)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    processedAt: ").append(this.toIndentedString(this.processedAt)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    isExchange: ").append(this.toIndentedString(this.isExchange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FULL("FULL"),
        PARTIAL("PARTIAL");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

