/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A tender represents a discrete monetary exchange. Square represents this exchange as a money object with a specific currency and amount, where the amount is given in the smallest denomination of the given currency.  Square POS can accept more than one form of tender for a single payment (such as by splitting a bill between a credit card and a gift card). The `tender` field of the Payment object lists all forms of tender used for the payment.  Split tender payments behave slightly differently from single tender payments:  The receipt_url for a split tender corresponds only to the first tender listed in the tender field. To get the receipt URLs for the remaining tenders, use the receipt_url fields of the corresponding Tender objects.  *A note on gift cards**: when a customer purchases a Square gift card from a merchant, the merchant receives the full amount of the gift card in the associated payment.  When that gift card is used as a tender, the balance of the gift card is reduced and the merchant receives no funds. A `Tender` object with a type of `SQUARE_GIFT_CARD` indicates a gift card was used for some or all of the associated payment.")
public class V1Tender {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="employee_id")
    private String employeeId = null;
    @JsonProperty(value="receipt_url")
    private String receiptUrl = null;
    @JsonProperty(value="card_brand")
    private CardBrandEnum cardBrand = null;
    @JsonProperty(value="pan_suffix")
    private String panSuffix = null;
    @JsonProperty(value="entry_method")
    private EntryMethodEnum entryMethod = null;
    @JsonProperty(value="payment_note")
    private String paymentNote = null;
    @JsonProperty(value="total_money")
    private V1Money totalMoney = null;
    @JsonProperty(value="tendered_money")
    private V1Money tenderedMoney = null;
    @JsonProperty(value="tendered_at")
    private String tenderedAt = null;
    @JsonProperty(value="settled_at")
    private String settledAt = null;
    @JsonProperty(value="change_back_money")
    private V1Money changeBackMoney = null;
    @JsonProperty(value="refunded_money")
    private V1Money refundedMoney = null;
    @JsonProperty(value="is_exchange")
    private Boolean isExchange = null;

    public V1Tender id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The tender's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Tender type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of tender. See [V1TenderType](#type-v1tendertype) for possible values")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public V1Tender name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="A human-readable description of the tender.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Tender employeeId(String employeeId) {
        this.employeeId = employeeId;
        return this;
    }

    @ApiModelProperty(value="The ID of the employee that processed the tender.")
    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    public V1Tender receiptUrl(String receiptUrl) {
        this.receiptUrl = receiptUrl;
        return this;
    }

    @ApiModelProperty(value="The URL of the receipt for the tender.")
    public String getReceiptUrl() {
        return this.receiptUrl;
    }

    public void setReceiptUrl(String receiptUrl) {
        this.receiptUrl = receiptUrl;
    }

    public V1Tender cardBrand(CardBrandEnum cardBrand) {
        this.cardBrand = cardBrand;
        return this;
    }

    @ApiModelProperty(value="The brand of credit card provided. See [CardBrand](#type-cardbrand) for possible values")
    public CardBrandEnum getCardBrand() {
        return this.cardBrand;
    }

    public void setCardBrand(CardBrandEnum cardBrand) {
        this.cardBrand = cardBrand;
    }

    public V1Tender panSuffix(String panSuffix) {
        this.panSuffix = panSuffix;
        return this;
    }

    @ApiModelProperty(value="The last four digits of the provided credit card's account number.")
    public String getPanSuffix() {
        return this.panSuffix;
    }

    public void setPanSuffix(String panSuffix) {
        this.panSuffix = panSuffix;
    }

    public V1Tender entryMethod(EntryMethodEnum entryMethod) {
        this.entryMethod = entryMethod;
        return this;
    }

    @ApiModelProperty(value="The tender's unique ID. See [V1TenderEntryMethod](#type-v1tenderentrymethod) for possible values")
    public EntryMethodEnum getEntryMethod() {
        return this.entryMethod;
    }

    public void setEntryMethod(EntryMethodEnum entryMethod) {
        this.entryMethod = entryMethod;
    }

    public V1Tender paymentNote(String paymentNote) {
        this.paymentNote = paymentNote;
        return this;
    }

    @ApiModelProperty(value="Notes entered by the merchant about the tender at the time of payment, if any. Typically only present for tender with the type: OTHER.")
    public String getPaymentNote() {
        return this.paymentNote;
    }

    public void setPaymentNote(String paymentNote) {
        this.paymentNote = paymentNote;
    }

    public V1Tender totalMoney(V1Money totalMoney) {
        this.totalMoney = totalMoney;
        return this;
    }

    @ApiModelProperty(value="The total amount of money provided in this form of tender.")
    public V1Money getTotalMoney() {
        return this.totalMoney;
    }

    public void setTotalMoney(V1Money totalMoney) {
        this.totalMoney = totalMoney;
    }

    public V1Tender tenderedMoney(V1Money tenderedMoney) {
        this.tenderedMoney = tenderedMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of total_money applied to the payment.")
    public V1Money getTenderedMoney() {
        return this.tenderedMoney;
    }

    public void setTenderedMoney(V1Money tenderedMoney) {
        this.tenderedMoney = tenderedMoney;
    }

    public V1Tender tenderedAt(String tenderedAt) {
        this.tenderedAt = tenderedAt;
        return this;
    }

    @ApiModelProperty(value="The time when the tender was created, in ISO 8601 format.")
    public String getTenderedAt() {
        return this.tenderedAt;
    }

    public void setTenderedAt(String tenderedAt) {
        this.tenderedAt = tenderedAt;
    }

    public V1Tender settledAt(String settledAt) {
        this.settledAt = settledAt;
        return this;
    }

    @ApiModelProperty(value="The time when the tender was settled, in ISO 8601 format.")
    public String getSettledAt() {
        return this.settledAt;
    }

    public void setSettledAt(String settledAt) {
        this.settledAt = settledAt;
    }

    public V1Tender changeBackMoney(V1Money changeBackMoney) {
        this.changeBackMoney = changeBackMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of total_money returned to the buyer as change.")
    public V1Money getChangeBackMoney() {
        return this.changeBackMoney;
    }

    public void setChangeBackMoney(V1Money changeBackMoney) {
        this.changeBackMoney = changeBackMoney;
    }

    public V1Tender refundedMoney(V1Money refundedMoney) {
        this.refundedMoney = refundedMoney;
        return this;
    }

    @ApiModelProperty(value="The total of all refunds applied to this tender. This amount is always negative or zero.")
    public V1Money getRefundedMoney() {
        return this.refundedMoney;
    }

    public void setRefundedMoney(V1Money refundedMoney) {
        this.refundedMoney = refundedMoney;
    }

    public V1Tender isExchange(Boolean isExchange) {
        this.isExchange = isExchange;
        return this;
    }

    @ApiModelProperty(value="Indicates whether or not the tender is associated with an exchange. If is_exchange is true, the tender represents the value of goods returned in an exchange not the actual money paid. The exchange value reduces the tender amounts needed to pay for items purchased in the exchange.")
    public Boolean getIsExchange() {
        return this.isExchange;
    }

    public void setIsExchange(Boolean isExchange) {
        this.isExchange = isExchange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Tender v1Tender = (V1Tender)o;
        return Objects.equals(this.id, v1Tender.id) && Objects.equals((Object)this.type, (Object)v1Tender.type) && Objects.equals(this.name, v1Tender.name) && Objects.equals(this.employeeId, v1Tender.employeeId) && Objects.equals(this.receiptUrl, v1Tender.receiptUrl) && Objects.equals((Object)this.cardBrand, (Object)v1Tender.cardBrand) && Objects.equals(this.panSuffix, v1Tender.panSuffix) && Objects.equals((Object)this.entryMethod, (Object)v1Tender.entryMethod) && Objects.equals(this.paymentNote, v1Tender.paymentNote) && Objects.equals(this.totalMoney, v1Tender.totalMoney) && Objects.equals(this.tenderedMoney, v1Tender.tenderedMoney) && Objects.equals(this.tenderedAt, v1Tender.tenderedAt) && Objects.equals(this.settledAt, v1Tender.settledAt) && Objects.equals(this.changeBackMoney, v1Tender.changeBackMoney) && Objects.equals(this.refundedMoney, v1Tender.refundedMoney) && Objects.equals(this.isExchange, v1Tender.isExchange);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.name, this.employeeId, this.receiptUrl, this.cardBrand, this.panSuffix, this.entryMethod, this.paymentNote, this.totalMoney, this.tenderedMoney, this.tenderedAt, this.settledAt, this.changeBackMoney, this.refundedMoney, this.isExchange});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Tender {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    employeeId: ").append(this.toIndentedString(this.employeeId)).append("\n");
        sb.append("    receiptUrl: ").append(this.toIndentedString(this.receiptUrl)).append("\n");
        sb.append("    cardBrand: ").append(this.toIndentedString((Object)this.cardBrand)).append("\n");
        sb.append("    panSuffix: ").append(this.toIndentedString(this.panSuffix)).append("\n");
        sb.append("    entryMethod: ").append(this.toIndentedString((Object)this.entryMethod)).append("\n");
        sb.append("    paymentNote: ").append(this.toIndentedString(this.paymentNote)).append("\n");
        sb.append("    totalMoney: ").append(this.toIndentedString(this.totalMoney)).append("\n");
        sb.append("    tenderedMoney: ").append(this.toIndentedString(this.tenderedMoney)).append("\n");
        sb.append("    tenderedAt: ").append(this.toIndentedString(this.tenderedAt)).append("\n");
        sb.append("    settledAt: ").append(this.toIndentedString(this.settledAt)).append("\n");
        sb.append("    changeBackMoney: ").append(this.toIndentedString(this.changeBackMoney)).append("\n");
        sb.append("    refundedMoney: ").append(this.toIndentedString(this.refundedMoney)).append("\n");
        sb.append("    isExchange: ").append(this.toIndentedString(this.isExchange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EntryMethodEnum {
        MANUAL("MANUAL"),
        SCANNED("SCANNED"),
        SQUARE_CASH("SQUARE_CASH"),
        SQUARE_WALLET("SQUARE_WALLET"),
        SWIPED("SWIPED"),
        WEB_FORM("WEB_FORM"),
        OTHER("OTHER");

        private String value;

        private EntryMethodEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntryMethodEnum fromValue(String text) {
            for (EntryMethodEnum b : EntryMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum CardBrandEnum {
        OTHER_BRAND("OTHER_BRAND"),
        VISA("VISA"),
        MASTERCARD("MASTERCARD"),
        AMERICAN_EXPRESS("AMERICAN_EXPRESS"),
        DISCOVER("DISCOVER"),
        DISCOVER_DINERS("DISCOVER_DINERS"),
        JCB("JCB"),
        CHINA_UNIONPAY("CHINA_UNIONPAY"),
        SQUARE_GIFT_CARD("SQUARE_GIFT_CARD");

        private String value;

        private CardBrandEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CardBrandEnum fromValue(String text) {
            for (CardBrandEnum b : CardBrandEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TypeEnum {
        CREDIT_CARD("CREDIT_CARD"),
        CASH("CASH"),
        THIRD_PARTY_CARD("THIRD_PARTY_CARD"),
        NO_SALE("NO_SALE"),
        SQUARE_WALLET("SQUARE_WALLET"),
        SQUARE_GIFT_CARD("SQUARE_GIFT_CARD"),
        UNKNOWN("UNKNOWN"),
        OTHER("OTHER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

