/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="V1TimecardEvent")
public class V1TimecardEvent {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="event_type")
    private EventTypeEnum eventType = null;
    @JsonProperty(value="clockin_time")
    private String clockinTime = null;
    @JsonProperty(value="clockout_time")
    private String clockoutTime = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;

    public V1TimecardEvent id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The event's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1TimecardEvent eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(value="The ID of the timecard to list events for. See [V1TimecardEventEventType](#type-v1timecardeventeventtype) for possible values")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public V1TimecardEvent clockinTime(String clockinTime) {
        this.clockinTime = clockinTime;
        return this;
    }

    @ApiModelProperty(value="The time the employee clocked in, in ISO 8601 format.")
    public String getClockinTime() {
        return this.clockinTime;
    }

    public void setClockinTime(String clockinTime) {
        this.clockinTime = clockinTime;
    }

    public V1TimecardEvent clockoutTime(String clockoutTime) {
        this.clockoutTime = clockoutTime;
        return this;
    }

    @ApiModelProperty(value="The time the employee clocked out, in ISO 8601 format.")
    public String getClockoutTime() {
        return this.clockoutTime;
    }

    public void setClockoutTime(String clockoutTime) {
        this.clockoutTime = clockoutTime;
    }

    public V1TimecardEvent createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the event was created, in ISO 8601 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TimecardEvent v1TimecardEvent = (V1TimecardEvent)o;
        return Objects.equals(this.id, v1TimecardEvent.id) && Objects.equals((Object)this.eventType, (Object)v1TimecardEvent.eventType) && Objects.equals(this.clockinTime, v1TimecardEvent.clockinTime) && Objects.equals(this.clockoutTime, v1TimecardEvent.clockoutTime) && Objects.equals(this.createdAt, v1TimecardEvent.createdAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.eventType, this.clockinTime, this.clockoutTime, this.createdAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1TimecardEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    clockinTime: ").append(this.toIndentedString(this.clockinTime)).append("\n");
        sb.append("    clockoutTime: ").append(this.toIndentedString(this.clockoutTime)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EventTypeEnum {
        API_CREATE("API_CREATE"),
        API_EDIT("API_EDIT"),
        API_DELETE("API_DELETE"),
        REGISTER_CLOCKIN("REGISTER_CLOCKIN"),
        REGISTER_CLOCKOUT("REGISTER_CLOCKOUT"),
        DASHBOARD_SUPERVISOR_CLOSE("DASHBOARD_SUPERVISOR_CLOSE"),
        DASHBOARD_EDIT("DASHBOARD_EDIT"),
        DASHBOARD_DELETE("DASHBOARD_DELETE");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EventTypeEnum fromValue(String text) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

