/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="V1Variation")
public class V1Variation {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="item_id")
    private String itemId = null;
    @JsonProperty(value="ordinal")
    private Integer ordinal = null;
    @JsonProperty(value="pricing_type")
    private PricingTypeEnum pricingType = null;
    @JsonProperty(value="price_money")
    private V1Money priceMoney = null;
    @JsonProperty(value="sku")
    private String sku = null;
    @JsonProperty(value="track_inventory")
    private Boolean trackInventory = null;
    @JsonProperty(value="inventory_alert_type")
    private InventoryAlertTypeEnum inventoryAlertType = null;
    @JsonProperty(value="inventory_alert_threshold")
    private Integer inventoryAlertThreshold = null;
    @JsonProperty(value="user_data")
    private String userData = null;

    public V1Variation id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The item variation's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Variation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The item variation's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Variation itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(value="The ID of the variation's associated item.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public V1Variation ordinal(Integer ordinal) {
        this.ordinal = ordinal;
        return this;
    }

    @ApiModelProperty(value="Indicates the variation's list position when displayed in Square Register and the merchant dashboard. If more than one variation for the same item has the same ordinal value, those variations are displayed in alphabetical order")
    public Integer getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(Integer ordinal) {
        this.ordinal = ordinal;
    }

    public V1Variation pricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the item variation's price is fixed or determined at the time of sale. See [V1VariationPricingType](#type-v1variationpricingtype) for possible values")
    public PricingTypeEnum getPricingType() {
        return this.pricingType;
    }

    public void setPricingType(PricingTypeEnum pricingType) {
        this.pricingType = pricingType;
    }

    public V1Variation priceMoney(V1Money priceMoney) {
        this.priceMoney = priceMoney;
        return this;
    }

    @ApiModelProperty(value="The item variation's price, if any.")
    public V1Money getPriceMoney() {
        return this.priceMoney;
    }

    public void setPriceMoney(V1Money priceMoney) {
        this.priceMoney = priceMoney;
    }

    public V1Variation sku(String sku) {
        this.sku = sku;
        return this;
    }

    @ApiModelProperty(value="The item variation's SKU, if any.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public V1Variation trackInventory(Boolean trackInventory) {
        this.trackInventory = trackInventory;
        return this;
    }

    @ApiModelProperty(value="If true, inventory tracking is active for the variation.")
    public Boolean getTrackInventory() {
        return this.trackInventory;
    }

    public void setTrackInventory(Boolean trackInventory) {
        this.trackInventory = trackInventory;
    }

    public V1Variation inventoryAlertType(InventoryAlertTypeEnum inventoryAlertType) {
        this.inventoryAlertType = inventoryAlertType;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the item variation displays an alert when its inventory quantity is less than or equal to its inventory_alert_threshold. See [V1VariationInventoryAlertType](#type-v1variationinventoryalerttype) for possible values")
    public InventoryAlertTypeEnum getInventoryAlertType() {
        return this.inventoryAlertType;
    }

    public void setInventoryAlertType(InventoryAlertTypeEnum inventoryAlertType) {
        this.inventoryAlertType = inventoryAlertType;
    }

    public V1Variation inventoryAlertThreshold(Integer inventoryAlertThreshold) {
        this.inventoryAlertThreshold = inventoryAlertThreshold;
        return this;
    }

    @ApiModelProperty(value="If the inventory quantity for the variation is less than or equal to this value and inventory_alert_type is LOW_QUANTITY, the variation displays an alert in the merchant dashboard.")
    public Integer getInventoryAlertThreshold() {
        return this.inventoryAlertThreshold;
    }

    public void setInventoryAlertThreshold(Integer inventoryAlertThreshold) {
        this.inventoryAlertThreshold = inventoryAlertThreshold;
    }

    public V1Variation userData(String userData) {
        this.userData = userData;
        return this;
    }

    @ApiModelProperty(value="Arbitrary metadata associated with the variation. Cannot exceed 255 characters.")
    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Variation v1Variation = (V1Variation)o;
        return Objects.equals(this.id, v1Variation.id) && Objects.equals(this.name, v1Variation.name) && Objects.equals(this.itemId, v1Variation.itemId) && Objects.equals(this.ordinal, v1Variation.ordinal) && Objects.equals((Object)this.pricingType, (Object)v1Variation.pricingType) && Objects.equals(this.priceMoney, v1Variation.priceMoney) && Objects.equals(this.sku, v1Variation.sku) && Objects.equals(this.trackInventory, v1Variation.trackInventory) && Objects.equals((Object)this.inventoryAlertType, (Object)v1Variation.inventoryAlertType) && Objects.equals(this.inventoryAlertThreshold, v1Variation.inventoryAlertThreshold) && Objects.equals(this.userData, v1Variation.userData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.itemId, this.ordinal, this.pricingType, this.priceMoney, this.sku, this.trackInventory, this.inventoryAlertType, this.inventoryAlertThreshold, this.userData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Variation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    ordinal: ").append(this.toIndentedString(this.ordinal)).append("\n");
        sb.append("    pricingType: ").append(this.toIndentedString((Object)this.pricingType)).append("\n");
        sb.append("    priceMoney: ").append(this.toIndentedString(this.priceMoney)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    trackInventory: ").append(this.toIndentedString(this.trackInventory)).append("\n");
        sb.append("    inventoryAlertType: ").append(this.toIndentedString((Object)this.inventoryAlertType)).append("\n");
        sb.append("    inventoryAlertThreshold: ").append(this.toIndentedString(this.inventoryAlertThreshold)).append("\n");
        sb.append("    userData: ").append(this.toIndentedString(this.userData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InventoryAlertTypeEnum {
        LOW_QUANTITY("LOW_QUANTITY"),
        NONE("NONE"),
        INVESTMENT("INVESTMENT"),
        LOAN("LOAN"),
        SAVINGS("SAVINGS"),
        OTHER("OTHER");

        private String value;

        private InventoryAlertTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InventoryAlertTypeEnum fromValue(String text) {
            for (InventoryAlertTypeEnum b : InventoryAlertTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum PricingTypeEnum {
        FIXED_PRICING("FIXED_PRICING"),
        VARIABLE_PRICING("VARIABLE_PRICING");

        private String value;

        private PricingTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricingTypeEnum fromValue(String text) {
            for (PricingTypeEnum b : PricingTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

