/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Sets the Day of the week and hour of the day that a business starts a  work week. Used for the calculation of overtime pay.")
public class WorkweekConfig {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="start_of_week")
    private StartOfWeekEnum startOfWeek = null;
    @JsonProperty(value="start_of_day_local_time")
    private String startOfDayLocalTime = null;
    @JsonProperty(value="version")
    private Integer version = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="updated_at")
    private String updatedAt = null;

    public WorkweekConfig id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="UUID for this object")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public WorkweekConfig startOfWeek(StartOfWeekEnum startOfWeek) {
        this.startOfWeek = startOfWeek;
        return this;
    }

    @ApiModelProperty(required=true, value="The day of the week on which a business week cuts over for compensation purposes. See [Weekday](#type-weekday) for possible values")
    public StartOfWeekEnum getStartOfWeek() {
        return this.startOfWeek;
    }

    public void setStartOfWeek(StartOfWeekEnum startOfWeek) {
        this.startOfWeek = startOfWeek;
    }

    public WorkweekConfig startOfDayLocalTime(String startOfDayLocalTime) {
        this.startOfDayLocalTime = startOfDayLocalTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The local time at which a business week cuts over. Represented as a string in `HH:MM` format (`HH:MM:SS` is also accepted, but seconds are truncated).")
    public String getStartOfDayLocalTime() {
        return this.startOfDayLocalTime;
    }

    public void setStartOfDayLocalTime(String startOfDayLocalTime) {
        this.startOfDayLocalTime = startOfDayLocalTime;
    }

    public WorkweekConfig version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="Used for resolving concurrency issues; request will fail if version provided does not match server version at time of request. If not provided, Square executes a blind write; potentially overwriting data from another write.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public WorkweekConfig createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format; presented in UTC")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public WorkweekConfig updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="A read-only timestamp in RFC 3339 format; presented in UTC")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkweekConfig workweekConfig = (WorkweekConfig)o;
        return Objects.equals(this.id, workweekConfig.id) && Objects.equals((Object)this.startOfWeek, (Object)workweekConfig.startOfWeek) && Objects.equals(this.startOfDayLocalTime, workweekConfig.startOfDayLocalTime) && Objects.equals(this.version, workweekConfig.version) && Objects.equals(this.createdAt, workweekConfig.createdAt) && Objects.equals(this.updatedAt, workweekConfig.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.startOfWeek, this.startOfDayLocalTime, this.version, this.createdAt, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkweekConfig {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    startOfWeek: ").append(this.toIndentedString((Object)this.startOfWeek)).append("\n");
        sb.append("    startOfDayLocalTime: ").append(this.toIndentedString(this.startOfDayLocalTime)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StartOfWeekEnum {
        MON("MON"),
        TUE("TUE"),
        WED("WED"),
        THU("THU"),
        FRI("FRI"),
        SAT("SAT"),
        SUN("SUN");

        private String value;

        private StartOfWeekEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StartOfWeekEnum fromValue(String text) {
            for (StartOfWeekEnum b : StartOfWeekEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

