/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.api;

import com.squareup.connect.ApiClient;
import com.squareup.connect.ApiException;
import com.squareup.connect.CompleteResponse;
import com.squareup.connect.Configuration;
import com.squareup.connect.Pair;
import com.squareup.connect.models.BatchDeleteCatalogObjectsRequest;
import com.squareup.connect.models.BatchDeleteCatalogObjectsResponse;
import com.squareup.connect.models.BatchRetrieveCatalogObjectsRequest;
import com.squareup.connect.models.BatchRetrieveCatalogObjectsResponse;
import com.squareup.connect.models.BatchUpsertCatalogObjectsRequest;
import com.squareup.connect.models.BatchUpsertCatalogObjectsResponse;
import com.squareup.connect.models.CatalogInfoResponse;
import com.squareup.connect.models.DeleteCatalogObjectResponse;
import com.squareup.connect.models.ListCatalogResponse;
import com.squareup.connect.models.RetrieveCatalogObjectResponse;
import com.squareup.connect.models.SearchCatalogObjectsRequest;
import com.squareup.connect.models.SearchCatalogObjectsResponse;
import com.squareup.connect.models.UpdateItemModifierListsRequest;
import com.squareup.connect.models.UpdateItemModifierListsResponse;
import com.squareup.connect.models.UpdateItemTaxesRequest;
import com.squareup.connect.models.UpdateItemTaxesResponse;
import com.squareup.connect.models.UpsertCatalogObjectRequest;
import com.squareup.connect.models.UpsertCatalogObjectResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class CatalogApi {
    private ApiClient apiClient;

    public CatalogApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CatalogApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public BatchDeleteCatalogObjectsResponse batchDeleteCatalogObjects(BatchDeleteCatalogObjectsRequest body) throws ApiException {
        BatchDeleteCatalogObjectsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchDeleteCatalogObjects");
        }
        String localVarPath = "/v2/catalog/batch-delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchDeleteCatalogObjectsResponse> localVarReturnType = new GenericType<BatchDeleteCatalogObjectsResponse>(){};
        CompleteResponse<BatchDeleteCatalogObjectsResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<BatchDeleteCatalogObjectsResponse> batchDeleteCatalogObjectsWithHttpInfo(BatchDeleteCatalogObjectsRequest body) throws ApiException {
        BatchDeleteCatalogObjectsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchDeleteCatalogObjects");
        }
        String localVarPath = "/v2/catalog/batch-delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchDeleteCatalogObjectsResponse> localVarReturnType = new GenericType<BatchDeleteCatalogObjectsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BatchRetrieveCatalogObjectsResponse batchRetrieveCatalogObjects(BatchRetrieveCatalogObjectsRequest body) throws ApiException {
        BatchRetrieveCatalogObjectsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchRetrieveCatalogObjects");
        }
        String localVarPath = "/v2/catalog/batch-retrieve";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchRetrieveCatalogObjectsResponse> localVarReturnType = new GenericType<BatchRetrieveCatalogObjectsResponse>(){};
        CompleteResponse<BatchRetrieveCatalogObjectsResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<BatchRetrieveCatalogObjectsResponse> batchRetrieveCatalogObjectsWithHttpInfo(BatchRetrieveCatalogObjectsRequest body) throws ApiException {
        BatchRetrieveCatalogObjectsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchRetrieveCatalogObjects");
        }
        String localVarPath = "/v2/catalog/batch-retrieve";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchRetrieveCatalogObjectsResponse> localVarReturnType = new GenericType<BatchRetrieveCatalogObjectsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public BatchUpsertCatalogObjectsResponse batchUpsertCatalogObjects(BatchUpsertCatalogObjectsRequest body) throws ApiException {
        BatchUpsertCatalogObjectsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchUpsertCatalogObjects");
        }
        String localVarPath = "/v2/catalog/batch-upsert";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchUpsertCatalogObjectsResponse> localVarReturnType = new GenericType<BatchUpsertCatalogObjectsResponse>(){};
        CompleteResponse<BatchUpsertCatalogObjectsResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<BatchUpsertCatalogObjectsResponse> batchUpsertCatalogObjectsWithHttpInfo(BatchUpsertCatalogObjectsRequest body) throws ApiException {
        BatchUpsertCatalogObjectsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling batchUpsertCatalogObjects");
        }
        String localVarPath = "/v2/catalog/batch-upsert";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<BatchUpsertCatalogObjectsResponse> localVarReturnType = new GenericType<BatchUpsertCatalogObjectsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CatalogInfoResponse catalogInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/catalog/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<CatalogInfoResponse> localVarReturnType = new GenericType<CatalogInfoResponse>(){};
        CompleteResponse<CatalogInfoResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<CatalogInfoResponse> catalogInfoWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/catalog/info";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<CatalogInfoResponse> localVarReturnType = new GenericType<CatalogInfoResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeleteCatalogObjectResponse deleteCatalogObject(String objectId) throws ApiException {
        Object localVarPostBody = null;
        if (objectId == null) {
            throw new ApiException(400, "Missing the required parameter 'objectId' when calling deleteCatalogObject");
        }
        String localVarPath = "/v2/catalog/object/{object_id}".replaceAll("\\{object_id\\}", this.apiClient.escapeString(objectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<DeleteCatalogObjectResponse> localVarReturnType = new GenericType<DeleteCatalogObjectResponse>(){};
        CompleteResponse<DeleteCatalogObjectResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<DeleteCatalogObjectResponse> deleteCatalogObjectWithHttpInfo(String objectId) throws ApiException {
        Object localVarPostBody = null;
        if (objectId == null) {
            throw new ApiException(400, "Missing the required parameter 'objectId' when calling deleteCatalogObject");
        }
        String localVarPath = "/v2/catalog/object/{object_id}".replaceAll("\\{object_id\\}", this.apiClient.escapeString(objectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<DeleteCatalogObjectResponse> localVarReturnType = new GenericType<DeleteCatalogObjectResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ListCatalogResponse listCatalog(String cursor, String types) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/catalog/list";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "types", types));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ListCatalogResponse> localVarReturnType = new GenericType<ListCatalogResponse>(){};
        CompleteResponse<ListCatalogResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<ListCatalogResponse> listCatalogWithHttpInfo(String cursor, String types) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/catalog/list";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "types", types));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ListCatalogResponse> localVarReturnType = new GenericType<ListCatalogResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RetrieveCatalogObjectResponse retrieveCatalogObject(String objectId, Boolean includeRelatedObjects) throws ApiException {
        Object localVarPostBody = null;
        if (objectId == null) {
            throw new ApiException(400, "Missing the required parameter 'objectId' when calling retrieveCatalogObject");
        }
        String localVarPath = "/v2/catalog/object/{object_id}".replaceAll("\\{object_id\\}", this.apiClient.escapeString(objectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_related_objects", includeRelatedObjects));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveCatalogObjectResponse> localVarReturnType = new GenericType<RetrieveCatalogObjectResponse>(){};
        CompleteResponse<RetrieveCatalogObjectResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<RetrieveCatalogObjectResponse> retrieveCatalogObjectWithHttpInfo(String objectId, Boolean includeRelatedObjects) throws ApiException {
        Object localVarPostBody = null;
        if (objectId == null) {
            throw new ApiException(400, "Missing the required parameter 'objectId' when calling retrieveCatalogObject");
        }
        String localVarPath = "/v2/catalog/object/{object_id}".replaceAll("\\{object_id\\}", this.apiClient.escapeString(objectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_related_objects", includeRelatedObjects));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveCatalogObjectResponse> localVarReturnType = new GenericType<RetrieveCatalogObjectResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SearchCatalogObjectsResponse searchCatalogObjects(SearchCatalogObjectsRequest body) throws ApiException {
        SearchCatalogObjectsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling searchCatalogObjects");
        }
        String localVarPath = "/v2/catalog/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<SearchCatalogObjectsResponse> localVarReturnType = new GenericType<SearchCatalogObjectsResponse>(){};
        CompleteResponse<SearchCatalogObjectsResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<SearchCatalogObjectsResponse> searchCatalogObjectsWithHttpInfo(SearchCatalogObjectsRequest body) throws ApiException {
        SearchCatalogObjectsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling searchCatalogObjects");
        }
        String localVarPath = "/v2/catalog/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<SearchCatalogObjectsResponse> localVarReturnType = new GenericType<SearchCatalogObjectsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpdateItemModifierListsResponse updateItemModifierLists(UpdateItemModifierListsRequest body) throws ApiException {
        UpdateItemModifierListsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateItemModifierLists");
        }
        String localVarPath = "/v2/catalog/update-item-modifier-lists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<UpdateItemModifierListsResponse> localVarReturnType = new GenericType<UpdateItemModifierListsResponse>(){};
        CompleteResponse<UpdateItemModifierListsResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<UpdateItemModifierListsResponse> updateItemModifierListsWithHttpInfo(UpdateItemModifierListsRequest body) throws ApiException {
        UpdateItemModifierListsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateItemModifierLists");
        }
        String localVarPath = "/v2/catalog/update-item-modifier-lists";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<UpdateItemModifierListsResponse> localVarReturnType = new GenericType<UpdateItemModifierListsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpdateItemTaxesResponse updateItemTaxes(UpdateItemTaxesRequest body) throws ApiException {
        UpdateItemTaxesRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateItemTaxes");
        }
        String localVarPath = "/v2/catalog/update-item-taxes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<UpdateItemTaxesResponse> localVarReturnType = new GenericType<UpdateItemTaxesResponse>(){};
        CompleteResponse<UpdateItemTaxesResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<UpdateItemTaxesResponse> updateItemTaxesWithHttpInfo(UpdateItemTaxesRequest body) throws ApiException {
        UpdateItemTaxesRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateItemTaxes");
        }
        String localVarPath = "/v2/catalog/update-item-taxes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<UpdateItemTaxesResponse> localVarReturnType = new GenericType<UpdateItemTaxesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UpsertCatalogObjectResponse upsertCatalogObject(UpsertCatalogObjectRequest body) throws ApiException {
        UpsertCatalogObjectRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling upsertCatalogObject");
        }
        String localVarPath = "/v2/catalog/object";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<UpsertCatalogObjectResponse> localVarReturnType = new GenericType<UpsertCatalogObjectResponse>(){};
        CompleteResponse<UpsertCatalogObjectResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<UpsertCatalogObjectResponse> upsertCatalogObjectWithHttpInfo(UpsertCatalogObjectRequest body) throws ApiException {
        UpsertCatalogObjectRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling upsertCatalogObject");
        }
        String localVarPath = "/v2/catalog/object";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<UpsertCatalogObjectResponse> localVarReturnType = new GenericType<UpsertCatalogObjectResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

