/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.api;

import com.squareup.connect.ApiClient;
import com.squareup.connect.ApiException;
import com.squareup.connect.CompleteResponse;
import com.squareup.connect.Configuration;
import com.squareup.connect.Pair;
import com.squareup.connect.models.CaptureTransactionResponse;
import com.squareup.connect.models.ChargeRequest;
import com.squareup.connect.models.ChargeResponse;
import com.squareup.connect.models.CreateRefundRequest;
import com.squareup.connect.models.CreateRefundResponse;
import com.squareup.connect.models.ListRefundsResponse;
import com.squareup.connect.models.ListTransactionsResponse;
import com.squareup.connect.models.RetrieveTransactionResponse;
import com.squareup.connect.models.VoidTransactionResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class TransactionsApi {
    private ApiClient apiClient;

    public TransactionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransactionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CaptureTransactionResponse captureTransaction(String locationId, String transactionId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling captureTransaction");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling captureTransaction");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions/{transaction_id}/capture".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{transaction_id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<CaptureTransactionResponse> localVarReturnType = new GenericType<CaptureTransactionResponse>(){};
        CompleteResponse<CaptureTransactionResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<CaptureTransactionResponse> captureTransactionWithHttpInfo(String locationId, String transactionId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling captureTransaction");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling captureTransaction");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions/{transaction_id}/capture".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{transaction_id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<CaptureTransactionResponse> localVarReturnType = new GenericType<CaptureTransactionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChargeResponse charge(String locationId, ChargeRequest body) throws ApiException {
        ChargeRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling charge");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling charge");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ChargeResponse> localVarReturnType = new GenericType<ChargeResponse>(){};
        CompleteResponse<ChargeResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<ChargeResponse> chargeWithHttpInfo(String locationId, ChargeRequest body) throws ApiException {
        ChargeRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling charge");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling charge");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ChargeResponse> localVarReturnType = new GenericType<ChargeResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateRefundResponse createRefund(String locationId, String transactionId, CreateRefundRequest body) throws ApiException {
        CreateRefundRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createRefund");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling createRefund");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRefund");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions/{transaction_id}/refund".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{transaction_id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<CreateRefundResponse> localVarReturnType = new GenericType<CreateRefundResponse>(){};
        CompleteResponse<CreateRefundResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<CreateRefundResponse> createRefundWithHttpInfo(String locationId, String transactionId, CreateRefundRequest body) throws ApiException {
        CreateRefundRequest localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling createRefund");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling createRefund");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createRefund");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions/{transaction_id}/refund".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{transaction_id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<CreateRefundResponse> localVarReturnType = new GenericType<CreateRefundResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ListRefundsResponse listRefunds(String locationId, String beginTime, String endTime, String sortOrder, String cursor) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listRefunds");
        }
        String localVarPath = "/v2/locations/{location_id}/refunds".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_order", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ListRefundsResponse> localVarReturnType = new GenericType<ListRefundsResponse>(){};
        CompleteResponse<ListRefundsResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<ListRefundsResponse> listRefundsWithHttpInfo(String locationId, String beginTime, String endTime, String sortOrder, String cursor) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listRefunds");
        }
        String localVarPath = "/v2/locations/{location_id}/refunds".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_order", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ListRefundsResponse> localVarReturnType = new GenericType<ListRefundsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ListTransactionsResponse listTransactions(String locationId, String beginTime, String endTime, String sortOrder, String cursor) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listTransactions");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_order", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ListTransactionsResponse> localVarReturnType = new GenericType<ListTransactionsResponse>(){};
        CompleteResponse<ListTransactionsResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<ListTransactionsResponse> listTransactionsWithHttpInfo(String locationId, String beginTime, String endTime, String sortOrder, String cursor) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling listTransactions");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "begin_time", beginTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_time", endTime));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_order", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cursor", cursor));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<ListTransactionsResponse> localVarReturnType = new GenericType<ListTransactionsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RetrieveTransactionResponse retrieveTransaction(String locationId, String transactionId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveTransaction");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling retrieveTransaction");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions/{transaction_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{transaction_id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveTransactionResponse> localVarReturnType = new GenericType<RetrieveTransactionResponse>(){};
        CompleteResponse<RetrieveTransactionResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<RetrieveTransactionResponse> retrieveTransactionWithHttpInfo(String locationId, String transactionId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling retrieveTransaction");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling retrieveTransaction");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions/{transaction_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{transaction_id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<RetrieveTransactionResponse> localVarReturnType = new GenericType<RetrieveTransactionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public VoidTransactionResponse voidTransaction(String locationId, String transactionId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling voidTransaction");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling voidTransaction");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions/{transaction_id}/void".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{transaction_id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<VoidTransactionResponse> localVarReturnType = new GenericType<VoidTransactionResponse>(){};
        CompleteResponse<VoidTransactionResponse> completeResponse = this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return completeResponse.getData();
    }

    public CompleteResponse<VoidTransactionResponse> voidTransactionWithHttpInfo(String locationId, String transactionId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling voidTransaction");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling voidTransaction");
        }
        String localVarPath = "/v2/locations/{location_id}/transactions/{transaction_id}/void".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString())).replaceAll("\\{transaction_id\\}", this.apiClient.escapeString(transactionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2"};
        GenericType<VoidTransactionResponse> localVarReturnType = new GenericType<VoidTransactionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

