/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A refund of an [AdditionalRecipientReceivable](#type-additionalrecipientreceivable). This includes the ID of the additional recipient receivable associated to this object, as well as a reference to the [Refund](#type-refund) that created this receivable refund.")
public class AdditionalRecipientReceivableRefund {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="receivable_id")
    private String receivableId = null;
    @JsonProperty(value="refund_id")
    private String refundId = null;
    @JsonProperty(value="transaction_location_id")
    private String transactionLocationId = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;

    public AdditionalRecipientReceivableRefund id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The receivable refund's unique ID, issued by Square payments servers.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AdditionalRecipientReceivableRefund receivableId(String receivableId) {
        this.receivableId = receivableId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the receivable that the refund was applied to.")
    public String getReceivableId() {
        return this.receivableId;
    }

    public void setReceivableId(String receivableId) {
        this.receivableId = receivableId;
    }

    public AdditionalRecipientReceivableRefund refundId(String refundId) {
        this.refundId = refundId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the refund that is associated to this receivable refund.")
    public String getRefundId() {
        return this.refundId;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    public AdditionalRecipientReceivableRefund transactionLocationId(String transactionLocationId) {
        this.transactionLocationId = transactionLocationId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the location that created the receivable. This is the location ID on the associated transaction.")
    public String getTransactionLocationId() {
        return this.transactionLocationId;
    }

    public void setTransactionLocationId(String transactionLocationId) {
        this.transactionLocationId = transactionLocationId;
    }

    public AdditionalRecipientReceivableRefund amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the refund. This will always be non-negative.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public AdditionalRecipientReceivableRefund createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the refund was created, in RFC 3339 format.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalRecipientReceivableRefund additionalRecipientReceivableRefund = (AdditionalRecipientReceivableRefund)o;
        return Objects.equals(this.id, additionalRecipientReceivableRefund.id) && Objects.equals(this.receivableId, additionalRecipientReceivableRefund.receivableId) && Objects.equals(this.refundId, additionalRecipientReceivableRefund.refundId) && Objects.equals(this.transactionLocationId, additionalRecipientReceivableRefund.transactionLocationId) && Objects.equals(this.amountMoney, additionalRecipientReceivableRefund.amountMoney) && Objects.equals(this.createdAt, additionalRecipientReceivableRefund.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.receivableId, this.refundId, this.transactionLocationId, this.amountMoney, this.createdAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalRecipientReceivableRefund {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    receivableId: ").append(this.toIndentedString(this.receivableId)).append("\n");
        sb.append("    refundId: ").append(this.toIndentedString(this.refundId)).append("\n");
        sb.append("    transactionLocationId: ").append(this.toIndentedString(this.transactionLocationId)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

