/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Address;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents the non-confidential details of a credit card.")
public class Card {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="card_brand")
    private CardBrandEnum cardBrand = null;
    @JsonProperty(value="last_4")
    private String last4 = null;
    @JsonProperty(value="exp_month")
    private Long expMonth = null;
    @JsonProperty(value="exp_year")
    private Long expYear = null;
    @JsonProperty(value="cardholder_name")
    private String cardholderName = null;
    @JsonProperty(value="billing_address")
    private Address billingAddress = null;
    @JsonProperty(value="fingerprint")
    private String fingerprint = null;

    public Card id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The card's unique ID, if any.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Card cardBrand(CardBrandEnum cardBrand) {
        this.cardBrand = cardBrand;
        return this;
    }

    @ApiModelProperty(value="The card's brand (such as `VISA`). See [CardBrand](#type-cardbrand) for all possible values.")
    public CardBrandEnum getCardBrand() {
        return this.cardBrand;
    }

    public void setCardBrand(CardBrandEnum cardBrand) {
        this.cardBrand = cardBrand;
    }

    public Card last4(String last4) {
        this.last4 = last4;
        return this;
    }

    @ApiModelProperty(value="The last 4 digits of the card's number.")
    public String getLast4() {
        return this.last4;
    }

    public void setLast4(String last4) {
        this.last4 = last4;
    }

    public Card expMonth(Long expMonth) {
        this.expMonth = expMonth;
        return this;
    }

    @ApiModelProperty(value="The month of the card's expiration date. This value is always between `1` and `12`, inclusive.")
    public Long getExpMonth() {
        return this.expMonth;
    }

    public void setExpMonth(Long expMonth) {
        this.expMonth = expMonth;
    }

    public Card expYear(Long expYear) {
        this.expYear = expYear;
        return this;
    }

    @ApiModelProperty(value="The four-digit year of the card's expiration date.")
    public Long getExpYear() {
        return this.expYear;
    }

    public void setExpYear(Long expYear) {
        this.expYear = expYear;
    }

    public Card cardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
        return this;
    }

    @ApiModelProperty(value="The cardholder name. This value is present only if this object represents a customer's card on file.")
    public String getCardholderName() {
        return this.cardholderName;
    }

    public void setCardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
    }

    public Card billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="The card's billing address. This value is present only if this object represents a customer's card on file.")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public Card fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @ApiModelProperty(value="The unique string fingerprint for the card.  The fingerprint is based on the credit card number and is unique to the merchant.  If a card is used at multiple locations for the same merchant, it will have the same fingerprint in each case. Note: Fingerprint may not exist on old transactions.")
    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        return Objects.equals(this.id, card.id) && Objects.equals((Object)this.cardBrand, (Object)card.cardBrand) && Objects.equals(this.last4, card.last4) && Objects.equals(this.expMonth, card.expMonth) && Objects.equals(this.expYear, card.expYear) && Objects.equals(this.cardholderName, card.cardholderName) && Objects.equals(this.billingAddress, card.billingAddress) && Objects.equals(this.fingerprint, card.fingerprint);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.cardBrand, this.last4, this.expMonth, this.expYear, this.cardholderName, this.billingAddress, this.fingerprint});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Card {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    cardBrand: ").append(this.toIndentedString((Object)this.cardBrand)).append("\n");
        sb.append("    last4: ").append(this.toIndentedString(this.last4)).append("\n");
        sb.append("    expMonth: ").append(this.toIndentedString(this.expMonth)).append("\n");
        sb.append("    expYear: ").append(this.toIndentedString(this.expYear)).append("\n");
        sb.append("    cardholderName: ").append(this.toIndentedString(this.cardholderName)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CardBrandEnum {
        OTHER_BRAND("OTHER_BRAND"),
        VISA("VISA"),
        MASTERCARD("MASTERCARD"),
        AMERICAN_EXPRESS("AMERICAN_EXPRESS"),
        DISCOVER("DISCOVER"),
        DISCOVER_DINERS("DISCOVER_DINERS"),
        JCB("JCB"),
        CHINA_UNIONPAY("CHINA_UNIONPAY"),
        SQUARE_GIFT_CARD("SQUARE_GIFT_CARD");

        private String value;

        private CardBrandEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CardBrandEnum fromValue(String text) {
            for (CardBrandEnum b : CardBrandEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

