/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A mapping between a client-supplied temporary ID and a permanent server ID.")
public class CatalogIdMapping {
    @JsonProperty(value="client_object_id")
    private String clientObjectId = null;
    @JsonProperty(value="object_id")
    private String objectId = null;

    public CatalogIdMapping clientObjectId(String clientObjectId) {
        this.clientObjectId = clientObjectId;
        return this;
    }

    @ApiModelProperty(value="The client-supplied, temporary `#`-prefixed ID for a new [CatalogObject](#type-catalogobject).")
    public String getClientObjectId() {
        return this.clientObjectId;
    }

    public void setClientObjectId(String clientObjectId) {
        this.clientObjectId = clientObjectId;
    }

    public CatalogIdMapping objectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    @ApiModelProperty(value="The permanent ID for the [CatalogObject](#type-catalogobject) created by the server.")
    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogIdMapping catalogIdMapping = (CatalogIdMapping)o;
        return Objects.equals(this.clientObjectId, catalogIdMapping.clientObjectId) && Objects.equals(this.objectId, catalogIdMapping.objectId);
    }

    public int hashCode() {
        return Objects.hash(this.clientObjectId, this.objectId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogIdMapping {\n");
        sb.append("    clientObjectId: ").append(this.toIndentedString(this.clientObjectId)).append("\n");
        sb.append("    objectId: ").append(this.toIndentedString(this.objectId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

