/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.CatalogQueryExact;
import com.squareup.connect.models.CatalogQueryItemsForModifierList;
import com.squareup.connect.models.CatalogQueryItemsForTax;
import com.squareup.connect.models.CatalogQueryPrefix;
import com.squareup.connect.models.CatalogQueryRange;
import com.squareup.connect.models.CatalogQuerySortedAttribute;
import com.squareup.connect.models.CatalogQueryText;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A query to be applied to a [SearchCatalogObjectsRequest](#type-searchcatalogobjectsrequest). Only one query field may be present.  Where an attribute name is required, it should be specified as the name of any field marked \"searchable\" from the structured data types for the desired result object type(s) ([CatalogItem](#type-catalogitem), [CatalogItemVariation](#type-catalogitemvariation), [CatalogCategory](#type-catalogcategory), [CatalogTax](#type-catalogtax), [CatalogDiscount](#type-catalogdiscount), [CatalogModifierList](#type-catalogmodifierlist), [CatalogModifier](#type-catalogmodifier)).  For example, a query that should return Items may specify attribute names from any of the searchable fields of the [CatalogItem](#type-catalogitem) data type, namely `\"name\"`, `\"description\"`, and `\"abbreviation\"`.")
public class CatalogQuery {
    @JsonProperty(value="sorted_attribute_query")
    private CatalogQuerySortedAttribute sortedAttributeQuery = null;
    @JsonProperty(value="exact_query")
    private CatalogQueryExact exactQuery = null;
    @JsonProperty(value="prefix_query")
    private CatalogQueryPrefix prefixQuery = null;
    @JsonProperty(value="range_query")
    private CatalogQueryRange rangeQuery = null;
    @JsonProperty(value="text_query")
    private CatalogQueryText textQuery = null;
    @JsonProperty(value="items_for_tax_query")
    private CatalogQueryItemsForTax itemsForTaxQuery = null;
    @JsonProperty(value="items_for_modifier_list_query")
    private CatalogQueryItemsForModifierList itemsForModifierListQuery = null;

    public CatalogQuery sortedAttributeQuery(CatalogQuerySortedAttribute sortedAttributeQuery) {
        this.sortedAttributeQuery = sortedAttributeQuery;
        return this;
    }

    @ApiModelProperty(value="A query that returns all objects, sorted by the given attribute.")
    public CatalogQuerySortedAttribute getSortedAttributeQuery() {
        return this.sortedAttributeQuery;
    }

    public void setSortedAttributeQuery(CatalogQuerySortedAttribute sortedAttributeQuery) {
        this.sortedAttributeQuery = sortedAttributeQuery;
    }

    public CatalogQuery exactQuery(CatalogQueryExact exactQuery) {
        this.exactQuery = exactQuery;
        return this;
    }

    @ApiModelProperty(value="A query that returns only objects for which the given (string-valued) attribute has the given case-insensitive value.")
    public CatalogQueryExact getExactQuery() {
        return this.exactQuery;
    }

    public void setExactQuery(CatalogQueryExact exactQuery) {
        this.exactQuery = exactQuery;
    }

    public CatalogQuery prefixQuery(CatalogQueryPrefix prefixQuery) {
        this.prefixQuery = prefixQuery;
        return this;
    }

    @ApiModelProperty(value="A query that returns only objects for which the given (string-valued) attribute has the given case-insensitive prefix.")
    public CatalogQueryPrefix getPrefixQuery() {
        return this.prefixQuery;
    }

    public void setPrefixQuery(CatalogQueryPrefix prefixQuery) {
        this.prefixQuery = prefixQuery;
    }

    public CatalogQuery rangeQuery(CatalogQueryRange rangeQuery) {
        this.rangeQuery = rangeQuery;
        return this;
    }

    @ApiModelProperty(value="A query that returns only objects for which the given (integer-valued) attribute lies in the given range.")
    public CatalogQueryRange getRangeQuery() {
        return this.rangeQuery;
    }

    public void setRangeQuery(CatalogQueryRange rangeQuery) {
        this.rangeQuery = rangeQuery;
    }

    public CatalogQuery textQuery(CatalogQueryText textQuery) {
        this.textQuery = textQuery;
        return this;
    }

    @ApiModelProperty(value="A query that returns only objects whose searchable attributes contain all of the given keywords as prefixes. For example, if a [CatalogItem](#type-catalogitem) contains attributes `{\"name\": \"t-shirt\"}` and `{\"description\": \"Small, Purple\"}`, it will be matched by the query `{\"keywords\": [\"shirt\", \"sma\", \"purp\"]}`.")
    public CatalogQueryText getTextQuery() {
        return this.textQuery;
    }

    public void setTextQuery(CatalogQueryText textQuery) {
        this.textQuery = textQuery;
    }

    public CatalogQuery itemsForTaxQuery(CatalogQueryItemsForTax itemsForTaxQuery) {
        this.itemsForTaxQuery = itemsForTaxQuery;
        return this;
    }

    @ApiModelProperty(value="A query that returns all [CatalogItem](#type-catalogitem)s that have any of the given [CatalogTax](#type-catalogtax)es enabled.")
    public CatalogQueryItemsForTax getItemsForTaxQuery() {
        return this.itemsForTaxQuery;
    }

    public void setItemsForTaxQuery(CatalogQueryItemsForTax itemsForTaxQuery) {
        this.itemsForTaxQuery = itemsForTaxQuery;
    }

    public CatalogQuery itemsForModifierListQuery(CatalogQueryItemsForModifierList itemsForModifierListQuery) {
        this.itemsForModifierListQuery = itemsForModifierListQuery;
        return this;
    }

    @ApiModelProperty(value="A query that returns all [CatalogItem](#type-catalogitem)s that have any of the given [CatalogModifierList](#type-catalogmodifierlist)s enabled.")
    public CatalogQueryItemsForModifierList getItemsForModifierListQuery() {
        return this.itemsForModifierListQuery;
    }

    public void setItemsForModifierListQuery(CatalogQueryItemsForModifierList itemsForModifierListQuery) {
        this.itemsForModifierListQuery = itemsForModifierListQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogQuery catalogQuery = (CatalogQuery)o;
        return Objects.equals(this.sortedAttributeQuery, catalogQuery.sortedAttributeQuery) && Objects.equals(this.exactQuery, catalogQuery.exactQuery) && Objects.equals(this.prefixQuery, catalogQuery.prefixQuery) && Objects.equals(this.rangeQuery, catalogQuery.rangeQuery) && Objects.equals(this.textQuery, catalogQuery.textQuery) && Objects.equals(this.itemsForTaxQuery, catalogQuery.itemsForTaxQuery) && Objects.equals(this.itemsForModifierListQuery, catalogQuery.itemsForModifierListQuery);
    }

    public int hashCode() {
        return Objects.hash(this.sortedAttributeQuery, this.exactQuery, this.prefixQuery, this.rangeQuery, this.textQuery, this.itemsForTaxQuery, this.itemsForModifierListQuery);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogQuery {\n");
        sb.append("    sortedAttributeQuery: ").append(this.toIndentedString(this.sortedAttributeQuery)).append("\n");
        sb.append("    exactQuery: ").append(this.toIndentedString(this.exactQuery)).append("\n");
        sb.append("    prefixQuery: ").append(this.toIndentedString(this.prefixQuery)).append("\n");
        sb.append("    rangeQuery: ").append(this.toIndentedString(this.rangeQuery)).append("\n");
        sb.append("    textQuery: ").append(this.toIndentedString(this.textQuery)).append("\n");
        sb.append("    itemsForTaxQuery: ").append(this.toIndentedString(this.itemsForTaxQuery)).append("\n");
        sb.append("    itemsForModifierListQuery: ").append(this.toIndentedString(this.itemsForModifierListQuery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

