/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a discount that can apply to either a single line item or an entire order.")
public class CreateOrderRequestDiscount {
    @JsonProperty(value="catalog_object_id")
    private String catalogObjectId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="percentage")
    private String percentage = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;

    public CreateOrderRequestDiscount catalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
        return this;
    }

    @ApiModelProperty(value="Only used for catalog taxes. The catalog object ID from exsiting [CatalogDiscount](#type-catalogdiscount).  Do not provide a value for this field if you provide values in other fields for an ad hoc discount.")
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    public void setCatalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
    }

    public CreateOrderRequestDiscount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Only used for ad hoc discounts. The discount's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateOrderRequestDiscount percentage(String percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(value="Only used for ad hoc discounts. The percentage of the discount, as a string representation of a decimal number.  A value of `7.25` corresponds to a percentage of 7.25%. This value range between 0.0 up to 100.0")
    public String getPercentage() {
        return this.percentage;
    }

    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    public CreateOrderRequestDiscount amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(value="Only used for ad hoc discounts. The monetary amount of the discount.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrderRequestDiscount createOrderRequestDiscount = (CreateOrderRequestDiscount)o;
        return Objects.equals(this.catalogObjectId, createOrderRequestDiscount.catalogObjectId) && Objects.equals(this.name, createOrderRequestDiscount.name) && Objects.equals(this.percentage, createOrderRequestDiscount.percentage) && Objects.equals(this.amountMoney, createOrderRequestDiscount.amountMoney);
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectId, this.name, this.percentage, this.amountMoney);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrderRequestDiscount {\n");
        sb.append("    catalogObjectId: ").append(this.toIndentedString(this.catalogObjectId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

