/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Error;
import com.squareup.connect.models.Order;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the response body of a request to the [CreateOrder](#endpoint-createorder) endpoint.  One of `errors` or `order` is present in a given response (never both).")
public class CreateOrderResponse {
    @JsonProperty(value="order")
    private Order order = null;
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();

    public CreateOrderResponse order(Order order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="The newly created order.")
    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public CreateOrderResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public CreateOrderResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrderResponse createOrderResponse = (CreateOrderResponse)o;
        return Objects.equals(this.order, createOrderResponse.order) && Objects.equals(this.errors, createOrderResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrderResponse {\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

