/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines the body parameters that can be included in a request to the [CreateRefund](#endpoint-createrefund) endpoint.")
public class CreateRefundRequest {
    @JsonProperty(value="idempotency_key")
    private String idempotencyKey = null;
    @JsonProperty(value="tender_id")
    private String tenderId = null;
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="amount_money")
    private Money amountMoney = null;

    public CreateRefundRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="A value you specify that uniquely identifies this refund among refunds you've created for the tender.  If you're unsure whether a particular refund succeeded, you can reattempt it with the same idempotency key without worrying about duplicating the refund.  See [Idempotency keys](#idempotencykeys) for more information.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public CreateRefundRequest tenderId(String tenderId) {
        this.tenderId = tenderId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the tender to refund.  A [`Transaction`](#type-transaction) has one or more `tenders` (i.e., methods of payment) associated with it, and you refund each tender separately with the Connect API.")
    public String getTenderId() {
        return this.tenderId;
    }

    public void setTenderId(String tenderId) {
        this.tenderId = tenderId;
    }

    public CreateRefundRequest reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="A description of the reason for the refund.  Default value: `Refund via API`")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public CreateRefundRequest amountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of money to refund.  Note that you specify the amount in the __smallest denomination of the applicable currency__. For example, US dollar amounts are specified in cents. See [Working with monetary amounts](#workingwithmonetaryamounts) for details.  This amount cannot exceed the amount that was originally charged to the tender that corresponds to `tender_id`.")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public void setAmountMoney(Money amountMoney) {
        this.amountMoney = amountMoney;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRefundRequest createRefundRequest = (CreateRefundRequest)o;
        return Objects.equals(this.idempotencyKey, createRefundRequest.idempotencyKey) && Objects.equals(this.tenderId, createRefundRequest.tenderId) && Objects.equals(this.reason, createRefundRequest.reason) && Objects.equals(this.amountMoney, createRefundRequest.amountMoney);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.tenderId, this.reason, this.amountMoney);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateRefundRequest {\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    tenderId: ").append(this.toIndentedString(this.tenderId)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    amountMoney: ").append(this.toIndentedString(this.amountMoney)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

