/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Customer;
import com.squareup.connect.models.Error;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the response body of a request to the [ListCustomers](#endpoint-listcustomers) endpoint.  One of `errors` or `customers` is present in a given response (never both).")
public class ListCustomersResponse {
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();
    @JsonProperty(value="customers")
    private List<Customer> customers = new ArrayList<Customer>();
    @JsonProperty(value="cursor")
    private String cursor = null;

    public ListCustomersResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public ListCustomersResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public ListCustomersResponse customers(List<Customer> customers) {
        this.customers = customers;
        return this;
    }

    public ListCustomersResponse addCustomersItem(Customer customersItem) {
        this.customers.add(customersItem);
        return this;
    }

    @ApiModelProperty(value="An array of `Customer` objects that match your query.")
    public List<Customer> getCustomers() {
        return this.customers;
    }

    public void setCustomers(List<Customer> customers) {
        this.customers = customers;
    }

    public ListCustomersResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="A pagination cursor to retrieve the next set of results for your original query to the endpoint. This value is present only if the request succeeded and additional results are available.  See [Paginating results](#paginatingresults) for more information.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListCustomersResponse listCustomersResponse = (ListCustomersResponse)o;
        return Objects.equals(this.errors, listCustomersResponse.errors) && Objects.equals(this.customers, listCustomersResponse.customers) && Objects.equals(this.cursor, listCustomersResponse.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.customers, this.cursor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListCustomersResponse {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    customers: ").append(this.toIndentedString(this.customers)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

