/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Error;
import com.squareup.connect.models.Transaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the fields that are included in the response body of a request to the [ListTransactions](#endpoint-listtransactions) endpoint.  One of `errors` or `transactions` is present in a given response (never both).")
public class ListTransactionsResponse {
    @JsonProperty(value="errors")
    private List<Error> errors = new ArrayList<Error>();
    @JsonProperty(value="transactions")
    private List<Transaction> transactions = new ArrayList<Transaction>();
    @JsonProperty(value="cursor")
    private String cursor = null;

    public ListTransactionsResponse errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public ListTransactionsResponse addErrorsItem(Error errorsItem) {
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="Any errors that occurred during the request.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public ListTransactionsResponse transactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public ListTransactionsResponse addTransactionsItem(Transaction transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(value="An array of transactions that match your query.")
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    public ListTransactionsResponse cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @ApiModelProperty(value="A pagination cursor for retrieving the next set of results, if any remain. Provide this value as the `cursor` parameter in a subsequent request to this endpoint.  See [Paginating results](#paginatingresults) for more information.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTransactionsResponse listTransactionsResponse = (ListTransactionsResponse)o;
        return Objects.equals(this.errors, listTransactionsResponse.errors) && Objects.equals(this.transactions, listTransactionsResponse.transactions) && Objects.equals(this.cursor, listTransactionsResponse.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.transactions, this.cursor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTransactionsResponse {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

