/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A [CatalogModifier](#type-catalogmodifier).")
public class OrderLineItemModifier {
    @JsonProperty(value="catalog_object_id")
    private String catalogObjectId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="base_price_money")
    private Money basePriceMoney = null;
    @JsonProperty(value="total_price_money")
    private Money totalPriceMoney = null;

    public OrderLineItemModifier catalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
        return this;
    }

    @ApiModelProperty(value="The catalog object id referencing [CatalogModifier](#type-catalogmodifier).")
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    public void setCatalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
    }

    public OrderLineItemModifier name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the item modifier.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrderLineItemModifier basePriceMoney(Money basePriceMoney) {
        this.basePriceMoney = basePriceMoney;
        return this;
    }

    @ApiModelProperty(value="The base price of the item modifier.")
    public Money getBasePriceMoney() {
        return this.basePriceMoney;
    }

    public void setBasePriceMoney(Money basePriceMoney) {
        this.basePriceMoney = basePriceMoney;
    }

    public OrderLineItemModifier totalPriceMoney(Money totalPriceMoney) {
        this.totalPriceMoney = totalPriceMoney;
        return this;
    }

    @ApiModelProperty(value="The total price of the item modifier for its line item. This is the modifier's base_price_money multiplied by the line item's quantity.")
    public Money getTotalPriceMoney() {
        return this.totalPriceMoney;
    }

    public void setTotalPriceMoney(Money totalPriceMoney) {
        this.totalPriceMoney = totalPriceMoney;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderLineItemModifier orderLineItemModifier = (OrderLineItemModifier)o;
        return Objects.equals(this.catalogObjectId, orderLineItemModifier.catalogObjectId) && Objects.equals(this.name, orderLineItemModifier.name) && Objects.equals(this.basePriceMoney, orderLineItemModifier.basePriceMoney) && Objects.equals(this.totalPriceMoney, orderLineItemModifier.totalPriceMoney);
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectId, this.name, this.basePriceMoney, this.totalPriceMoney);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderLineItemModifier {\n");
        sb.append("    catalogObjectId: ").append(this.toIndentedString(this.catalogObjectId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    basePriceMoney: ").append(this.toIndentedString(this.basePriceMoney)).append("\n");
        sb.append("    totalPriceMoney: ").append(this.toIndentedString(this.totalPriceMoney)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

