/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Money;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a tax that applies to one or more line items in an order.")
public class OrderLineItemTax {
    @JsonProperty(value="catalog_object_id")
    private String catalogObjectId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="percentage")
    private String percentage = null;
    @JsonProperty(value="applied_money")
    private Money appliedMoney = null;

    public OrderLineItemTax catalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
        return this;
    }

    @ApiModelProperty(value="The catalog object id referencing [CatalogTax](#type-catalogtax).")
    public String getCatalogObjectId() {
        return this.catalogObjectId;
    }

    public void setCatalogObjectId(String catalogObjectId) {
        this.catalogObjectId = catalogObjectId;
    }

    public OrderLineItemTax name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The tax's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrderLineItemTax type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Indicates the calculation method used to apply the tax.  See [OrderLineItemTaxType](#type-orderlineitemtaxtype) for possible values.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OrderLineItemTax percentage(String percentage) {
        this.percentage = percentage;
        return this;
    }

    @ApiModelProperty(value="The percentage of the tax, as a string representation of a decimal number.  A value of `7.25` corresponds to a percentage of 7.25%.")
    public String getPercentage() {
        return this.percentage;
    }

    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    public OrderLineItemTax appliedMoney(Money appliedMoney) {
        this.appliedMoney = appliedMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of the money applied by the tax in an order.")
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    public void setAppliedMoney(Money appliedMoney) {
        this.appliedMoney = appliedMoney;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderLineItemTax orderLineItemTax = (OrderLineItemTax)o;
        return Objects.equals(this.catalogObjectId, orderLineItemTax.catalogObjectId) && Objects.equals(this.name, orderLineItemTax.name) && Objects.equals((Object)this.type, (Object)orderLineItemTax.type) && Objects.equals(this.percentage, orderLineItemTax.percentage) && Objects.equals(this.appliedMoney, orderLineItemTax.appliedMoney);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.catalogObjectId, this.name, this.type, this.percentage, this.appliedMoney});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderLineItemTax {\n");
        sb.append("    catalogObjectId: ").append(this.toIndentedString(this.catalogObjectId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    percentage: ").append(this.toIndentedString(this.percentage)).append("\n");
        sb.append("    appliedMoney: ").append(this.toIndentedString(this.appliedMoney)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        UNKNOWN_TAX("UNKNOWN_TAX"),
        ADDITIVE("ADDITIVE"),
        INCLUSIVE("INCLUSIVE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

