/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.Card;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents additional details of a tender with `type` `CARD` or `SQUARE_GIFT_CARD`")
public class TenderCardDetails {
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="card")
    private Card card = null;
    @JsonProperty(value="entry_method")
    private EntryMethodEnum entryMethod = null;

    public TenderCardDetails status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The credit card payment's current state (such as `AUTHORIZED` or `CAPTURED`). See [TenderCardDetailsStatus](#type-tendercarddetailsstatus) for possible values.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TenderCardDetails card(Card card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(value="The credit card's non-confidential details.")
    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public TenderCardDetails entryMethod(EntryMethodEnum entryMethod) {
        this.entryMethod = entryMethod;
        return this;
    }

    @ApiModelProperty(value="The method used to enter the card's details for the transaction.")
    public EntryMethodEnum getEntryMethod() {
        return this.entryMethod;
    }

    public void setEntryMethod(EntryMethodEnum entryMethod) {
        this.entryMethod = entryMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenderCardDetails tenderCardDetails = (TenderCardDetails)o;
        return Objects.equals((Object)this.status, (Object)tenderCardDetails.status) && Objects.equals(this.card, tenderCardDetails.card) && Objects.equals((Object)this.entryMethod, (Object)tenderCardDetails.entryMethod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.card, this.entryMethod});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TenderCardDetails {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    entryMethod: ").append(this.toIndentedString((Object)this.entryMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EntryMethodEnum {
        SWIPED("SWIPED"),
        KEYED("KEYED"),
        EMV("EMV"),
        ON_FILE("ON_FILE"),
        CONTACTLESS("CONTACTLESS");

        private String value;

        private EntryMethodEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntryMethodEnum fromValue(String text) {
            for (EntryMethodEnum b : EntryMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum StatusEnum {
        AUTHORIZED("AUTHORIZED"),
        CAPTURED("CAPTURED"),
        VOIDED("VOIDED"),
        FAILED("FAILED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

