/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V1EmployeeRole {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="permissions")
    private List<PermissionsEnum> permissions = new ArrayList<PermissionsEnum>();
    @JsonProperty(value="is_owner")
    private Boolean isOwner = null;
    @JsonProperty(value="created_at")
    private String createdAt = null;
    @JsonProperty(value="updated_at")
    private String updatedAt = null;

    public V1EmployeeRole id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The role's unique ID, Can only be set by Square.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1EmployeeRole name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The role's merchant-defined name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1EmployeeRole permissions(List<PermissionsEnum> permissions) {
        this.permissions = permissions;
        return this;
    }

    public V1EmployeeRole addPermissionsItem(PermissionsEnum permissionsItem) {
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The role's permissions.")
    public List<PermissionsEnum> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<PermissionsEnum> permissions) {
        this.permissions = permissions;
    }

    public V1EmployeeRole isOwner(Boolean isOwner) {
        this.isOwner = isOwner;
        return this;
    }

    @ApiModelProperty(value="If true, employees with this role have all permissions, regardless of the values indicated in permissions.")
    public Boolean getIsOwner() {
        return this.isOwner;
    }

    public void setIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
    }

    public V1EmployeeRole createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="The time when the employee entity was created, in ISO 8601 format. Is set by Square when the Role is created.")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public V1EmployeeRole updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="The time when the employee entity was most recently updated, in ISO 8601 format. Is set by Square when the Role updated.")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EmployeeRole v1EmployeeRole = (V1EmployeeRole)o;
        return Objects.equals(this.id, v1EmployeeRole.id) && Objects.equals(this.name, v1EmployeeRole.name) && Objects.equals(this.permissions, v1EmployeeRole.permissions) && Objects.equals(this.isOwner, v1EmployeeRole.isOwner) && Objects.equals(this.createdAt, v1EmployeeRole.createdAt) && Objects.equals(this.updatedAt, v1EmployeeRole.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.permissions, this.isOwner, this.createdAt, this.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EmployeeRole {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    isOwner: ").append(this.toIndentedString(this.isOwner)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PermissionsEnum {
        ACCESS_SALES_HISTORY("REGISTER_ACCESS_SALES_HISTORY"),
        APPLY_RESTRICTED_DISCOUNTS("REGISTER_APPLY_RESTRICTED_DISCOUNTS"),
        CHANGE_SETTINGS("REGISTER_CHANGE_SETTINGS"),
        EDIT_ITEM("REGISTER_EDIT_ITEM"),
        ISSUE_REFUNDS("REGISTER_ISSUE_REFUNDS"),
        OPEN_CASH_DRAWER_OUTSIDE_SALE("REGISTER_OPEN_CASH_DRAWER_OUTSIDE_SALE"),
        VIEW_SUMMARY_REPORTS("REGISTER_VIEW_SUMMARY_REPORTS");

        private String value;

        private PermissionsEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionsEnum fromValue(String text) {
            for (PermissionsEnum b : PermissionsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

