/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class V1Fee {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="rate")
    private String rate = null;
    @JsonProperty(value="calculation_phase")
    private CalculationPhaseEnum calculationPhase = null;
    @JsonProperty(value="adjustment_type")
    private AdjustmentTypeEnum adjustmentType = null;
    @JsonProperty(value="applies_to_custom_amounts")
    private Boolean appliesToCustomAmounts = null;
    @JsonProperty(value="enabled")
    private Boolean enabled = null;
    @JsonProperty(value="inclusion_type")
    private InclusionTypeEnum inclusionType = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;

    public V1Fee id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The fee's unique ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Fee name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The fee's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Fee rate(String rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(value="The rate of the fee, as a string representation of a decimal number. A value of 0.07 corresponds to a rate of 7%.")
    public String getRate() {
        return this.rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public V1Fee calculationPhase(CalculationPhaseEnum calculationPhase) {
        this.calculationPhase = calculationPhase;
        return this;
    }

    @ApiModelProperty(value="Forthcoming")
    public CalculationPhaseEnum getCalculationPhase() {
        return this.calculationPhase;
    }

    public void setCalculationPhase(CalculationPhaseEnum calculationPhase) {
        this.calculationPhase = calculationPhase;
    }

    public V1Fee adjustmentType(AdjustmentTypeEnum adjustmentType) {
        this.adjustmentType = adjustmentType;
        return this;
    }

    @ApiModelProperty(value="The type of adjustment the fee applies to a payment. Currently, this value is TAX for all fees.")
    public AdjustmentTypeEnum getAdjustmentType() {
        return this.adjustmentType;
    }

    public void setAdjustmentType(AdjustmentTypeEnum adjustmentType) {
        this.adjustmentType = adjustmentType;
    }

    public V1Fee appliesToCustomAmounts(Boolean appliesToCustomAmounts) {
        this.appliesToCustomAmounts = appliesToCustomAmounts;
        return this;
    }

    @ApiModelProperty(value="If true, the fee applies to custom amounts entered into Square Register that are not associated with a particular item.")
    public Boolean getAppliesToCustomAmounts() {
        return this.appliesToCustomAmounts;
    }

    public void setAppliesToCustomAmounts(Boolean appliesToCustomAmounts) {
        this.appliesToCustomAmounts = appliesToCustomAmounts;
    }

    public V1Fee enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="If true, the fee is applied to all appropriate items. If false, the fee is not applied at all.")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public V1Fee inclusionType(InclusionTypeEnum inclusionType) {
        this.inclusionType = inclusionType;
        return this;
    }

    @ApiModelProperty(value="Whether the fee is ADDITIVE or INCLUSIVE.")
    public InclusionTypeEnum getInclusionType() {
        return this.inclusionType;
    }

    public void setInclusionType(InclusionTypeEnum inclusionType) {
        this.inclusionType = inclusionType;
    }

    public V1Fee type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="In countries with multiple classifications for sales taxes, indicates which classification the fee falls under. Currently relevant only to Canadian merchants.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Fee v1Fee = (V1Fee)o;
        return Objects.equals(this.id, v1Fee.id) && Objects.equals(this.name, v1Fee.name) && Objects.equals(this.rate, v1Fee.rate) && Objects.equals((Object)this.calculationPhase, (Object)v1Fee.calculationPhase) && Objects.equals((Object)this.adjustmentType, (Object)v1Fee.adjustmentType) && Objects.equals(this.appliesToCustomAmounts, v1Fee.appliesToCustomAmounts) && Objects.equals(this.enabled, v1Fee.enabled) && Objects.equals((Object)this.inclusionType, (Object)v1Fee.inclusionType) && Objects.equals((Object)this.type, (Object)v1Fee.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.rate, this.calculationPhase, this.adjustmentType, this.appliesToCustomAmounts, this.enabled, this.inclusionType, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Fee {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    calculationPhase: ").append(this.toIndentedString((Object)this.calculationPhase)).append("\n");
        sb.append("    adjustmentType: ").append(this.toIndentedString((Object)this.adjustmentType)).append("\n");
        sb.append("    appliesToCustomAmounts: ").append(this.toIndentedString(this.appliesToCustomAmounts)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    inclusionType: ").append(this.toIndentedString((Object)this.inclusionType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        CA_GST("CA_GST"),
        CA_HST("CA_HST"),
        CA_PST("CA_PST"),
        CA_QST("CA_QST"),
        JP_CONSUMPTION_TAX("JP_CONSUMPTION_TAX"),
        CA_PEI_PST("CA_PEI_PST"),
        US_SALES_TAX("US_SALES_TAX"),
        OTHER("OTHER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum InclusionTypeEnum {
        ADDITIVE("ADDITIVE"),
        INCLUSIVE("INCLUSIVE");

        private String value;

        private InclusionTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InclusionTypeEnum fromValue(String text) {
            for (InclusionTypeEnum b : InclusionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AdjustmentTypeEnum {
        TAX("TAX");

        private String value;

        private AdjustmentTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdjustmentTypeEnum fromValue(String text) {
            for (AdjustmentTypeEnum b : AdjustmentTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum CalculationPhaseEnum {
        FEE_SUBTOTAL_PHASE("FEE_SUBTOTAL_PHASE"),
        OTHER("OTHER"),
        FEE_TOTAL_PHASE("FEE_TOTAL_PHASE");

        private String value;

        private CalculationPhaseEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CalculationPhaseEnum fromValue(String text) {
            for (CalculationPhaseEnum b : CalculationPhaseEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

