/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Category;
import com.squareup.connect.models.V1Fee;
import com.squareup.connect.models.V1ItemImage;
import com.squareup.connect.models.V1Variation;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V1Item {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="color")
    private ColorEnum color = null;
    @JsonProperty(value="abbreviation")
    private String abbreviation = null;
    @JsonProperty(value="visibility")
    private VisibilityEnum visibility = null;
    @JsonProperty(value="available_online")
    private Boolean availableOnline = null;
    @JsonProperty(value="master_image")
    private V1ItemImage masterImage = null;
    @JsonProperty(value="category")
    private V1Category category = null;
    @JsonProperty(value="variations")
    private List<V1Variation> variations = new ArrayList<V1Variation>();
    @JsonProperty(value="modifier_lists")
    private List<V1Variation> modifierLists = new ArrayList<V1Variation>();
    @JsonProperty(value="fees")
    private List<V1Fee> fees = new ArrayList<V1Fee>();
    @JsonProperty(value="taxable")
    private Boolean taxable = null;

    public V1Item id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The item's ID. Must be unique among all entity IDs ever provided on behalf of the merchant. You can never reuse an ID. This value can include alphanumeric characters, dashes (-), and underscores (_).")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Item name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The item's name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Item description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The item's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public V1Item type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The item's type. This value is NORMAL for almost all items.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public V1Item color(ColorEnum color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="The color of the discount's display label in Square Register, if not the default color. The default color is 9da2a6.")
    public ColorEnum getColor() {
        return this.color;
    }

    public void setColor(ColorEnum color) {
        this.color = color;
    }

    public V1Item abbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
        return this;
    }

    @ApiModelProperty(value="The text of the item's display label in Square Register. Only up to the first five characters of the string are used.")
    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public V1Item visibility(VisibilityEnum visibility) {
        this.visibility = visibility;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the item is viewable from the merchant's online store (PUBLIC) or PRIVATE.")
    public VisibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityEnum visibility) {
        this.visibility = visibility;
    }

    public V1Item availableOnline(Boolean availableOnline) {
        this.availableOnline = availableOnline;
        return this;
    }

    @ApiModelProperty(value="If true, the item can be added to shipping orders from the merchant's online store.")
    public Boolean getAvailableOnline() {
        return this.availableOnline;
    }

    public void setAvailableOnline(Boolean availableOnline) {
        this.availableOnline = availableOnline;
    }

    public V1Item masterImage(V1ItemImage masterImage) {
        this.masterImage = masterImage;
        return this;
    }

    @ApiModelProperty(value="The item's master image, if any.")
    public V1ItemImage getMasterImage() {
        return this.masterImage;
    }

    public void setMasterImage(V1ItemImage masterImage) {
        this.masterImage = masterImage;
    }

    public V1Item category(V1Category category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="The category the item belongs to, if any.")
    public V1Category getCategory() {
        return this.category;
    }

    public void setCategory(V1Category category) {
        this.category = category;
    }

    public V1Item variations(List<V1Variation> variations) {
        this.variations = variations;
        return this;
    }

    public V1Item addVariationsItem(V1Variation variationsItem) {
        this.variations.add(variationsItem);
        return this;
    }

    @ApiModelProperty(value="The item's variations. You must specify at least one variation.")
    public List<V1Variation> getVariations() {
        return this.variations;
    }

    public void setVariations(List<V1Variation> variations) {
        this.variations = variations;
    }

    public V1Item modifierLists(List<V1Variation> modifierLists) {
        this.modifierLists = modifierLists;
        return this;
    }

    public V1Item addModifierListsItem(V1Variation modifierListsItem) {
        this.modifierLists.add(modifierListsItem);
        return this;
    }

    @ApiModelProperty(value="The modifier lists that apply to the item, if any.")
    public List<V1Variation> getModifierLists() {
        return this.modifierLists;
    }

    public void setModifierLists(List<V1Variation> modifierLists) {
        this.modifierLists = modifierLists;
    }

    public V1Item fees(List<V1Fee> fees) {
        this.fees = fees;
        return this;
    }

    public V1Item addFeesItem(V1Fee feesItem) {
        this.fees.add(feesItem);
        return this;
    }

    @ApiModelProperty(value="The fees that apply to the item, if any.")
    public List<V1Fee> getFees() {
        return this.fees;
    }

    public void setFees(List<V1Fee> fees) {
        this.fees = fees;
    }

    public V1Item taxable(Boolean taxable) {
        this.taxable = taxable;
        return this;
    }

    @ApiModelProperty(value="Deprecated. This field is not used.")
    public Boolean getTaxable() {
        return this.taxable;
    }

    public void setTaxable(Boolean taxable) {
        this.taxable = taxable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Item v1Item = (V1Item)o;
        return Objects.equals(this.id, v1Item.id) && Objects.equals(this.name, v1Item.name) && Objects.equals(this.description, v1Item.description) && Objects.equals((Object)this.type, (Object)v1Item.type) && Objects.equals((Object)this.color, (Object)v1Item.color) && Objects.equals(this.abbreviation, v1Item.abbreviation) && Objects.equals((Object)this.visibility, (Object)v1Item.visibility) && Objects.equals(this.availableOnline, v1Item.availableOnline) && Objects.equals(this.masterImage, v1Item.masterImage) && Objects.equals(this.category, v1Item.category) && Objects.equals(this.variations, v1Item.variations) && Objects.equals(this.modifierLists, v1Item.modifierLists) && Objects.equals(this.fees, v1Item.fees) && Objects.equals(this.taxable, v1Item.taxable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.type, this.color, this.abbreviation, this.visibility, this.availableOnline, this.masterImage, this.category, this.variations, this.modifierLists, this.fees, this.taxable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Item {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    color: ").append(this.toIndentedString((Object)this.color)).append("\n");
        sb.append("    abbreviation: ").append(this.toIndentedString(this.abbreviation)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString((Object)this.visibility)).append("\n");
        sb.append("    availableOnline: ").append(this.toIndentedString(this.availableOnline)).append("\n");
        sb.append("    masterImage: ").append(this.toIndentedString(this.masterImage)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    modifierLists: ").append(this.toIndentedString(this.modifierLists)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    taxable: ").append(this.toIndentedString(this.taxable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum VisibilityEnum {
        PUBLIC("PUBLIC"),
        PRIVATE("PRIVATE");

        private String value;

        private VisibilityEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VisibilityEnum fromValue(String text) {
            for (VisibilityEnum b : VisibilityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ColorEnum {
        _9DA2A6("9da2a6"),
        _4AB200("4ab200"),
        _0B8000("0b8000"),
        _2952CC("2952cc"),
        A82EE5("a82ee5"),
        E5457A("e5457a"),
        B21212("b21212"),
        _593C00("593c00"),
        E5BF00("e5BF00");

        private String value;

        private ColorEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ColorEnum fromValue(String text) {
            for (ColorEnum b : ColorEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TypeEnum {
        NORMAL("NORMAL"),
        GIFT_CARD("GIFT_CARD"),
        OTHER("OTHER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

