/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.connect.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.connect.models.V1Money;
import com.squareup.connect.models.V1SettlementEntry;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V1Settlement {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="total_money")
    private V1Money totalMoney = null;
    @JsonProperty(value="initiated_at")
    private String initiatedAt = null;
    @JsonProperty(value="bank_account_id")
    private String bankAccountId = null;
    @JsonProperty(value="entries")
    private List<V1SettlementEntry> entries = new ArrayList<V1SettlementEntry>();

    public V1Settlement id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The settlement's unique identifier.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public V1Settlement status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The settlement's current status.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public V1Settlement totalMoney(V1Money totalMoney) {
        this.totalMoney = totalMoney;
        return this;
    }

    @ApiModelProperty(value="The amount of money involved in the settlement. A positive amount indicates a deposit, and a negative amount indicates a withdrawal. This amount is never zero.")
    public V1Money getTotalMoney() {
        return this.totalMoney;
    }

    public void setTotalMoney(V1Money totalMoney) {
        this.totalMoney = totalMoney;
    }

    public V1Settlement initiatedAt(String initiatedAt) {
        this.initiatedAt = initiatedAt;
        return this;
    }

    @ApiModelProperty(value="The time when the settlement was submitted for deposit or withdrawal, in ISO 8601 format.")
    public String getInitiatedAt() {
        return this.initiatedAt;
    }

    public void setInitiatedAt(String initiatedAt) {
        this.initiatedAt = initiatedAt;
    }

    public V1Settlement bankAccountId(String bankAccountId) {
        this.bankAccountId = bankAccountId;
        return this;
    }

    @ApiModelProperty(value="The Square-issued unique identifier for the bank account associated with the settlement.")
    public String getBankAccountId() {
        return this.bankAccountId;
    }

    public void setBankAccountId(String bankAccountId) {
        this.bankAccountId = bankAccountId;
    }

    public V1Settlement entries(List<V1SettlementEntry> entries) {
        this.entries = entries;
        return this;
    }

    public V1Settlement addEntriesItem(V1SettlementEntry entriesItem) {
        this.entries.add(entriesItem);
        return this;
    }

    @ApiModelProperty(value="The entries included in this settlement.")
    public List<V1SettlementEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<V1SettlementEntry> entries) {
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Settlement v1Settlement = (V1Settlement)o;
        return Objects.equals(this.id, v1Settlement.id) && Objects.equals((Object)this.status, (Object)v1Settlement.status) && Objects.equals(this.totalMoney, v1Settlement.totalMoney) && Objects.equals(this.initiatedAt, v1Settlement.initiatedAt) && Objects.equals(this.bankAccountId, v1Settlement.bankAccountId) && Objects.equals(this.entries, v1Settlement.entries);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.totalMoney, this.initiatedAt, this.bankAccountId, this.entries});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Settlement {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    totalMoney: ").append(this.toIndentedString(this.totalMoney)).append("\n");
        sb.append("    initiatedAt: ").append(this.toIndentedString(this.initiatedAt)).append("\n");
        sb.append("    bankAccountId: ").append(this.toIndentedString(this.bankAccountId)).append("\n");
        sb.append("    entries: ").append(this.toIndentedString(this.entries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        FAILED("FAILED"),
        SENT("SENT");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

