/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.ApplicationFeeCollection;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.Charge;
import com.stripe.model.ExpandableField;
import com.stripe.model.FeeRefundCollection;
import com.stripe.model.HasId;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;
import lombok.Generated;

public class ApplicationFee
extends APIResource
implements HasId {
    String id;
    String object;
    ExpandableField<Account> account;
    Long amount;
    Long amountRefunded;
    ExpandableField<Application> application;
    ExpandableField<BalanceTransaction> balanceTransaction;
    ExpandableField<Charge> charge;
    Long created;
    String currency;
    Boolean livemode;
    ExpandableField<Charge> originatingTransaction;
    Boolean refunded;
    FeeRefundCollection refunds;
    @Deprecated
    String user;

    public String getAccount() {
        return this.account != null ? this.account.getId() : null;
    }

    public void setAccount(String accountID) {
        this.account = ApplicationFee.setExpandableFieldID(accountID, this.account);
    }

    public Account getAccountObject() {
        return this.account != null ? this.account.getExpanded() : null;
    }

    public void setAccountObject(Account c) {
        this.account = new ExpandableField<Account>(c.getId(), c);
    }

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String applicationID) {
        this.application = ApplicationFee.setExpandableFieldID(applicationID, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application c) {
        this.application = new ExpandableField<Application>(c.getId(), c);
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String balanceTransactionID) {
        this.balanceTransaction = ApplicationFee.setExpandableFieldID(balanceTransactionID, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction c) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(c.getId(), c);
    }

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String chargeID) {
        this.charge = ApplicationFee.setExpandableFieldID(chargeID, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge c) {
        this.charge = new ExpandableField<Charge>(c.getId(), c);
    }

    public String getOriginatingTransaction() {
        return this.originatingTransaction != null ? this.originatingTransaction.getId() : null;
    }

    public void setOriginatingTransaction(String originatingTransactionID) {
        this.originatingTransaction = ApplicationFee.setExpandableFieldID(originatingTransactionID, this.originatingTransaction);
    }

    public Charge getOriginatingTransactionObject() {
        return this.originatingTransaction != null ? this.originatingTransaction.getExpanded() : null;
    }

    public void setOriginatingTransactionObject(Charge c) {
        this.originatingTransaction = new ExpandableField<Charge>(c.getId(), c);
    }

    public FeeRefundCollection getRefunds() {
        if (this.refunds.getURL() == null) {
            this.refunds.setURL(String.format("/v1/application_fees/%s/refunds", this.getId()));
        }
        return this.refunds;
    }

    @Deprecated
    public static ApplicationFeeCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.list(params, null);
    }

    @Deprecated
    public static ApplicationFeeCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.list(params, options);
    }

    @Deprecated
    public static ApplicationFeeCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static ApplicationFeeCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.list(params, null);
    }

    public static ApplicationFeeCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.requestCollection(ApplicationFee.classURL(ApplicationFee.class), params, ApplicationFeeCollection.class, options);
    }

    @Deprecated
    public ApplicationFee refund() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, (RequestOptions)null);
    }

    @Deprecated
    public ApplicationFee refund(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, options);
    }

    @Deprecated
    public ApplicationFee refund(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public ApplicationFee refund(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(params, (RequestOptions)null);
    }

    @Deprecated
    public ApplicationFee refund(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.request(APIResource.RequestMethod.POST, String.format("%s/refund", ApplicationFee.instanceURL(ApplicationFee.class, this.getId())), params, ApplicationFee.class, options);
    }

    @Deprecated
    public ApplicationFee refund(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static ApplicationFee retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.retrieve(id, (RequestOptions)null);
    }

    public static ApplicationFee retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.request(APIResource.RequestMethod.GET, ApplicationFee.instanceURL(ApplicationFee.class, id), null, ApplicationFee.class, options);
    }

    @Deprecated
    public static ApplicationFee retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountRefunded() {
        return this.amountRefunded;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Boolean getRefunded() {
        return this.refunded;
    }

    @Deprecated
    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountRefunded(Long amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    @Generated
    public void setRefunds(FeeRefundCollection refunds) {
        this.refunds = refunds;
    }

    @Deprecated
    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationFee)) {
            return false;
        }
        ApplicationFee other = (ApplicationFee)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountRefunded = this.getAmountRefunded();
        Long other$amountRefunded = other.getAmountRefunded();
        if (this$amountRefunded == null ? other$amountRefunded != null : !((Object)this$amountRefunded).equals(other$amountRefunded)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$originatingTransaction = this.getOriginatingTransaction();
        String other$originatingTransaction = other.getOriginatingTransaction();
        if (this$originatingTransaction == null ? other$originatingTransaction != null : !this$originatingTransaction.equals(other$originatingTransaction)) {
            return false;
        }
        Boolean this$refunded = this.getRefunded();
        Boolean other$refunded = other.getRefunded();
        if (this$refunded == null ? other$refunded != null : !((Object)this$refunded).equals(other$refunded)) {
            return false;
        }
        FeeRefundCollection this$refunds = this.getRefunds();
        FeeRefundCollection other$refunds = other.getRefunds();
        if (this$refunds == null ? other$refunds != null : !this$refunds.equals(other$refunds)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApplicationFee;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountRefunded = this.getAmountRefunded();
        result = result * 59 + ($amountRefunded == null ? 43 : ((Object)$amountRefunded).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $originatingTransaction = this.getOriginatingTransaction();
        result = result * 59 + ($originatingTransaction == null ? 43 : $originatingTransaction.hashCode());
        Boolean $refunded = this.getRefunded();
        result = result * 59 + ($refunded == null ? 43 : ((Object)$refunded).hashCode());
        FeeRefundCollection $refunds = this.getRefunds();
        result = result * 59 + ($refunds == null ? 43 : $refunds.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

