/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Account;
import com.stripe.model.Customer;
import com.stripe.model.DeletedExternalAccount;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;
import lombok.Generated;

public class ExternalAccount
extends APIResource
implements HasId,
MetadataStore<ExternalAccount> {
    String id;
    String object;
    String account;
    String customer;
    Map<String, String> metadata;

    public DeletedExternalAccount delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    public DeletedExternalAccount delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ExternalAccount.request(APIResource.RequestMethod.DELETE, this.getInstanceURL(), null, DeletedExternalAccount.class, options);
    }

    public ExternalAccount update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public ExternalAccount update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ExternalAccount.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, ExternalAccount.class, options);
    }

    public ExternalAccount verify(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.verify(params, null);
    }

    public ExternalAccount verify(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (this.getCustomer() != null) {
            return ExternalAccount.request(APIResource.RequestMethod.POST, String.format("%s/verify", this.getInstanceURL()), params, ExternalAccount.class, options);
        }
        throw new InvalidRequestException("Only customer bank accounts can be verified in this manner.", null, null, null, 0, null);
    }

    protected String getInstanceURL() {
        if (this.getCustomer() != null) {
            return String.format("%s/%s/sources/%s", ExternalAccount.classURL(Customer.class), this.getCustomer(), this.getId());
        }
        if (this.getAccount() != null) {
            return String.format("%s/%s/external_accounts/%s", ExternalAccount.classURL(Account.class), this.getAccount(), this.getId());
        }
        return null;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAccount(String account) {
        this.account = account;
    }

    @Generated
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalAccount)) {
            return false;
        }
        ExternalAccount other = (ExternalAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExternalAccount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

