/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Charge;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.OrderCollection;
import com.stripe.model.OrderItem;
import com.stripe.model.OrderReturn;
import com.stripe.model.OrderReturnCollection;
import com.stripe.model.ShippingDetails;
import com.stripe.model.ShippingMethod;
import com.stripe.model.StatusTransitions;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Order
extends APIResource
implements HasId,
MetadataStore<Order> {
    String id;
    String object;
    Long amount;
    Long amountReturned;
    String application;
    Long applicationFee;
    ExpandableField<Charge> charge;
    Long created;
    String currency;
    ExpandableField<Customer> customer;
    String email;
    String externalCouponCode;
    List<OrderItem> items;
    Boolean livemode;
    Map<String, String> metadata;
    OrderReturnCollection returns;
    String selectedShippingMethod;
    ShippingDetails shipping;
    List<ShippingMethod> shippingMethods;
    String status;
    StatusTransitions statusTransitions;
    Long updated;
    String upstreamId;

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String chargeID) {
        this.charge = Order.setExpandableFieldID(chargeID, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge charge) {
        this.charge = new ExpandableField<Charge>(charge.getId(), charge);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String customerID) {
        this.customer = Order.setExpandableFieldID(customerID, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer customer) {
        this.customer = new ExpandableField<Customer>(customer.getId(), customer);
    }

    @Deprecated
    public static OrderCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.list(params, null);
    }

    @Deprecated
    public static OrderCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.list(params, options);
    }

    public static Order create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.create(params, null);
    }

    public static Order create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.POST, Order.classURL(Order.class), params, Order.class, options);
    }

    public static OrderCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.list(params, null);
    }

    public static OrderCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.requestCollection(Order.classURL(Order.class), params, OrderCollection.class, options);
    }

    public Order pay(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.pay(params, null);
    }

    public Order pay(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.POST, String.format("%s/pay", Order.instanceURL(Order.class, this.getId())), params, Order.class, options);
    }

    public static Order retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.retrieve(id, null);
    }

    public static Order retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.GET, Order.instanceURL(Order.class, id), null, Order.class, options);
    }

    public static Order retrieve(String id, Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.GET, Order.instanceURL(Order.class, id), params, Order.class, options);
    }

    public OrderReturn returnOrder(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.returnOrder(params, null);
    }

    public OrderReturn returnOrder(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.POST, String.format("%s/returns", Order.instanceURL(Order.class, this.getId())), params, OrderReturn.class, options);
    }

    public Order update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Order update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Order.request(APIResource.RequestMethod.POST, Order.instanceURL(Order.class, this.id), params, Order.class, options);
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getAmountReturned() {
        return this.amountReturned;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public Long getApplicationFee() {
        return this.applicationFee;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getExternalCouponCode() {
        return this.externalCouponCode;
    }

    @Generated
    public List<OrderItem> getItems() {
        return this.items;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public OrderReturnCollection getReturns() {
        return this.returns;
    }

    @Generated
    public String getSelectedShippingMethod() {
        return this.selectedShippingMethod;
    }

    @Generated
    public ShippingDetails getShipping() {
        return this.shipping;
    }

    @Generated
    public List<ShippingMethod> getShippingMethods() {
        return this.shippingMethods;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public StatusTransitions getStatusTransitions() {
        return this.statusTransitions;
    }

    @Generated
    public Long getUpdated() {
        return this.updated;
    }

    @Generated
    public String getUpstreamId() {
        return this.upstreamId;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setAmountReturned(Long amountReturned) {
        this.amountReturned = amountReturned;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setApplicationFee(Long applicationFee) {
        this.applicationFee = applicationFee;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setExternalCouponCode(String externalCouponCode) {
        this.externalCouponCode = externalCouponCode;
    }

    @Generated
    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setReturns(OrderReturnCollection returns) {
        this.returns = returns;
    }

    @Generated
    public void setSelectedShippingMethod(String selectedShippingMethod) {
        this.selectedShippingMethod = selectedShippingMethod;
    }

    @Generated
    public void setShipping(ShippingDetails shipping) {
        this.shipping = shipping;
    }

    @Generated
    public void setShippingMethods(List<ShippingMethod> shippingMethods) {
        this.shippingMethods = shippingMethods;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusTransitions(StatusTransitions statusTransitions) {
        this.statusTransitions = statusTransitions;
    }

    @Generated
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Generated
    public void setUpstreamId(String upstreamId) {
        this.upstreamId = upstreamId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order other = (Order)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$amountReturned = this.getAmountReturned();
        Long other$amountReturned = other.getAmountReturned();
        if (this$amountReturned == null ? other$amountReturned != null : !((Object)this$amountReturned).equals(other$amountReturned)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        Long this$applicationFee = this.getApplicationFee();
        Long other$applicationFee = other.getApplicationFee();
        if (this$applicationFee == null ? other$applicationFee != null : !((Object)this$applicationFee).equals(other$applicationFee)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$externalCouponCode = this.getExternalCouponCode();
        String other$externalCouponCode = other.getExternalCouponCode();
        if (this$externalCouponCode == null ? other$externalCouponCode != null : !this$externalCouponCode.equals(other$externalCouponCode)) {
            return false;
        }
        List<OrderItem> this$items = this.getItems();
        List<OrderItem> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        OrderReturnCollection this$returns = this.getReturns();
        OrderReturnCollection other$returns = other.getReturns();
        if (this$returns == null ? other$returns != null : !this$returns.equals(other$returns)) {
            return false;
        }
        String this$selectedShippingMethod = this.getSelectedShippingMethod();
        String other$selectedShippingMethod = other.getSelectedShippingMethod();
        if (this$selectedShippingMethod == null ? other$selectedShippingMethod != null : !this$selectedShippingMethod.equals(other$selectedShippingMethod)) {
            return false;
        }
        ShippingDetails this$shipping = this.getShipping();
        ShippingDetails other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        List<ShippingMethod> this$shippingMethods = this.getShippingMethods();
        List<ShippingMethod> other$shippingMethods = other.getShippingMethods();
        if (this$shippingMethods == null ? other$shippingMethods != null : !((Object)this$shippingMethods).equals(other$shippingMethods)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        StatusTransitions this$statusTransitions = this.getStatusTransitions();
        StatusTransitions other$statusTransitions = other.getStatusTransitions();
        if (this$statusTransitions == null ? other$statusTransitions != null : !((Object)this$statusTransitions).equals(other$statusTransitions)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        String this$upstreamId = this.getUpstreamId();
        String other$upstreamId = other.getUpstreamId();
        return !(this$upstreamId == null ? other$upstreamId != null : !this$upstreamId.equals(other$upstreamId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Order;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $amountReturned = this.getAmountReturned();
        result = result * 59 + ($amountReturned == null ? 43 : ((Object)$amountReturned).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        Long $applicationFee = this.getApplicationFee();
        result = result * 59 + ($applicationFee == null ? 43 : ((Object)$applicationFee).hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $externalCouponCode = this.getExternalCouponCode();
        result = result * 59 + ($externalCouponCode == null ? 43 : $externalCouponCode.hashCode());
        List<OrderItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        OrderReturnCollection $returns = this.getReturns();
        result = result * 59 + ($returns == null ? 43 : $returns.hashCode());
        String $selectedShippingMethod = this.getSelectedShippingMethod();
        result = result * 59 + ($selectedShippingMethod == null ? 43 : $selectedShippingMethod.hashCode());
        ShippingDetails $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        List<ShippingMethod> $shippingMethods = this.getShippingMethods();
        result = result * 59 + ($shippingMethods == null ? 43 : ((Object)$shippingMethods).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        StatusTransitions $statusTransitions = this.getStatusTransitions();
        result = result * 59 + ($statusTransitions == null ? 43 : ((Object)$statusTransitions).hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        String $upstreamId = this.getUpstreamId();
        result = result * 59 + ($upstreamId == null ? 43 : $upstreamId.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

