/*
 * Decompiled with CFR 0.152.
 */
package com.tguzik.objects;

import com.tguzik.annotations.ExpectedPerformanceProfile;
import com.tguzik.objects.MultilineNoAddressStyle;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ParametersAreNonnullByDefault
@ExpectedPerformanceProfile(value={ExpectedPerformanceProfile.Kind.REFLECTION_HEAVY})
public abstract class BaseObject {
    public static final MultilineNoAddressStyle MULTILINE_NO_ADDRESS_STYLE = new MultilineNoAddressStyle();

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public boolean equals(Object other) {
        if (other != null && this.sameClass(other)) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (boolean)false);
        }
        return false;
    }

    private boolean sameClass(Object other) {
        return Objects.equals(this.getClass(), other.getClass());
    }

    @Nonnull
    public String toString() {
        return this.toString(ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Nonnull
    public String toString(ToStringStyle style) {
        return BaseObject.toString(this, style);
    }

    @Nonnull
    public static String toString(@Nullable Object object, @Nonnull ToStringStyle style) {
        if (style == null) {
            throw new NullPointerException("To string style parameter cannot be null!");
        }
        if (object == null) {
            return "";
        }
        return ReflectionToStringBuilder.toString((Object)object, (ToStringStyle)style, (boolean)false, (boolean)false);
    }
}

