/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.littemplate;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.littemplate.InjectableLitElementInitializer;
import com.vaadin.flow.component.littemplate.LitTemplate;
import com.vaadin.flow.component.littemplate.LitTemplateDataAnalyzer;
import com.vaadin.flow.component.littemplate.LitTemplateParser;
import com.vaadin.flow.component.polymertemplate.IdMapper;
import com.vaadin.flow.component.polymertemplate.TemplateDataAnalyzer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.ReflectionCache;
import com.vaadin.flow.server.VaadinService;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

public class LitTemplateInitializer {
    private static final ConcurrentHashMap<LitTemplateParser, ReflectionCache<LitTemplate, TemplateDataAnalyzer.ParserData>> CACHE = new ConcurrentHashMap();
    private final LitTemplate template;
    private final TemplateDataAnalyzer.ParserData parserData;
    private final Class<? extends LitTemplate> templateClass;

    public LitTemplateInitializer(LitTemplate template, VaadinService service) {
        this(template, LitTemplate.getParser(service), service);
    }

    LitTemplateInitializer(LitTemplate template, LitTemplateParser parser, VaadinService service) {
        this.template = template;
        boolean productionMode = service.getDeploymentConfiguration().isProductionMode();
        this.templateClass = ((Object)((Object)template)).getClass();
        TemplateDataAnalyzer.ParserData data = null;
        if (productionMode) {
            ReflectionCache cache = CACHE.computeIfAbsent(parser, analyzer -> new ReflectionCache((SerializableFunction & Serializable)clazz -> new LitTemplateDataAnalyzer((Class<? extends LitTemplate>)clazz, (LitTemplateParser)analyzer, service).parseTemplate()));
            data = (TemplateDataAnalyzer.ParserData)cache.get(this.templateClass);
        }
        if (data == null) {
            data = new LitTemplateDataAnalyzer(this.templateClass, parser, service).parseTemplate();
        }
        this.parserData = data;
    }

    public void initChildElements() {
        IdMapper idMapper = new IdMapper((Component)this.template);
        this.parserData.forEachInjectedField((field, id, tag) -> idMapper.mapComponentOrElement(field, id, tag, element -> new InjectableLitElementInitializer((Element)element, (Class<? extends Component>)this.templateClass).accept(this.parserData.getAttributes(id))));
    }
}

