/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.di;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.server.BootstrapListener;
import com.vaadin.flow.server.DependencyFilter;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.util.stream.Stream;

public interface Instantiator
extends Serializable {
    public boolean init(VaadinService var1);

    public Stream<VaadinServiceInitListener> getServiceInitListeners();

    default public Stream<BootstrapListener> getBootstrapListeners(Stream<BootstrapListener> serviceInitListeners) {
        return serviceInitListeners;
    }

    default public Stream<DependencyFilter> getDependencyFilters(Stream<DependencyFilter> serviceInitFilters) {
        return serviceInitFilters;
    }

    public <T> T getOrCreate(Class<T> var1);

    default public <T extends HasElement> T createRouteTarget(Class<T> routeTargetType, NavigationEvent event) {
        return (T)((HasElement)this.getOrCreate(routeTargetType));
    }

    default public <T extends Component> T createComponent(Class<T> componentClass) {
        return (T)((Component)this.getOrCreate(componentClass));
    }

    public static Instantiator get(UI ui) {
        if (!1.$assertionsDisabled && ui == null) {
            throw new AssertionError();
        }
        VaadinSession session = ui.getSession();
        if (!1.$assertionsDisabled && session == null) {
            throw new AssertionError();
        }
        return session.getService().getInstantiator();
    }

    default public I18NProvider getI18NProvider() {
        return this.getOrCreate(I18NProvider.class);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

