/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.shared.ui;

import com.vaadin.flow.shared.ui.LoadMode;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Stream;

public class Dependency
implements Serializable {
    public static final String KEY_URL = "url";
    public static final String KEY_TYPE = "type";
    public static final String KEY_LOAD_MODE = "mode";
    public static final String KEY_CONTENTS = "contents";
    private final Type type;
    private final String url;
    private final LoadMode loadMode;

    public Dependency(Type type, String url, LoadMode loadMode) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        assert (type != null);
        this.type = type;
        this.url = SharedUtil.prefixIfRelative(url, "frontend://");
        this.loadMode = loadMode;
    }

    public String getUrl() {
        return this.url;
    }

    public Type getType() {
        return this.type;
    }

    public LoadMode getLoadMode() {
        return this.loadMode;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = Json.createObject();
        jsonObject.put(KEY_URL, this.url);
        jsonObject.put(KEY_TYPE, this.type.name());
        jsonObject.put(KEY_LOAD_MODE, this.loadMode.name());
        return jsonObject;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.url, this.loadMode});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return this.type == that.type && this.loadMode == that.loadMode && Objects.equals(this.url, that.url);
    }

    public String toString() {
        return "Dependency [type=" + (Object)((Object)this.type) + ", url=" + this.url + ", loadMode=" + (Object)((Object)this.loadMode) + "]";
    }

    public static enum Type {
        STYLESHEET,
        JAVASCRIPT,
        HTML_IMPORT;


        public static boolean contains(String value) {
            return Stream.of(Type.values()).anyMatch(enumValue -> enumValue.toString().equals(value));
        }
    }
}

