/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.internal.DependencyTreeCache;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.DevModeInitializer;
import com.vaadin.flow.shared.ui.LoadMode;
import com.vaadin.flow.shared.util.SharedUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentMetaData {
    private final Collection<SynchronizedPropertyInfo> synchronizedProperties;
    private final ConcurrentHashMap<VaadinService, DependencyInfo> dependencyInfo = new ConcurrentHashMap();
    private final Class<? extends Component> componentClass;

    public ComponentMetaData(Class<? extends Component> componentClass) {
        this.componentClass = componentClass;
        this.synchronizedProperties = ComponentMetaData.findSynchronizedProperties(componentClass);
    }

    private static DependencyInfo findDependencies(VaadinService service, Class<? extends Component> componentClass) {
        DevModeInitializer.VisitedClasses visitedClasses = service.getContext().getAttribute(DevModeInitializer.VisitedClasses.class);
        if (visitedClasses != null && !visitedClasses.allDependenciesVisited(componentClass)) {
            ComponentMetaData.getLogger().warn("Frontend dependencies have not been analyzed for {}. To make the component's frontend dependencies work, you must ensure the component class is directly referenced through an application entry point such as a class annotated with @Route.", (Object)componentClass.getName());
        }
        DependencyInfo dependencyInfo = new DependencyInfo();
        ComponentMetaData.findDependencies(service, componentClass, dependencyInfo, new HashSet<Class<? extends Component>>());
        return dependencyInfo;
    }

    private static DependencyInfo findDependencies(VaadinService service, Class<? extends Component> componentClass, DependencyInfo dependencyInfo, Set<Class<? extends Component>> scannedClasses) {
        assert (!scannedClasses.contains(componentClass));
        scannedClasses.add(componentClass);
        if (service.getDeploymentConfiguration().isCompatibilityMode()) {
            dependencyInfo.htmlImports.addAll(ComponentMetaData.getHtmlImportDependencies(service, componentClass));
        } else {
            List<JsModule> jsModules = AnnotationReader.getJsModuleAnnotations(componentClass);
            if (!jsModules.isEmpty()) {
                dependencyInfo.jsModules.addAll(jsModules);
            } else {
                dependencyInfo.jsModules.addAll(ComponentMetaData.getHtmlImportAsJsModuleAnnotations(componentClass));
            }
        }
        dependencyInfo.javaScripts.addAll(AnnotationReader.getJavaScriptAnnotations(componentClass));
        dependencyInfo.styleSheets.addAll(AnnotationReader.getStyleSheetAnnotations(componentClass));
        List<Uses> usesList = AnnotationReader.getAnnotationsFor(componentClass, Uses.class);
        for (Uses uses : usesList) {
            Class<? extends Component> otherClass = uses.value();
            if (scannedClasses.contains(otherClass)) continue;
            ComponentMetaData.findDependencies(service, otherClass, dependencyInfo, scannedClasses);
        }
        return dependencyInfo;
    }

    public Collection<SynchronizedPropertyInfo> getSynchronizedProperties() {
        return Collections.unmodifiableCollection(this.synchronizedProperties);
    }

    public DependencyInfo getDependencyInfo(VaadinService service) {
        return this.dependencyInfo.computeIfAbsent(service, ignore -> {
            service.addServiceDestroyListener(event -> this.dependencyInfo.remove(service));
            return ComponentMetaData.findDependencies(service, this.componentClass);
        });
    }

    private static Collection<HtmlImportDependency> getHtmlImportDependencies(VaadinService service, Class<? extends Component> componentClass) {
        return AnnotationReader.getHtmlImportAnnotations(componentClass).stream().map(htmlImport -> ComponentMetaData.getHtmlImportDependencies(service, htmlImport)).collect(Collectors.toList());
    }

    private static HtmlImportDependency getHtmlImportDependencies(VaadinService service, HtmlImport htmlImport) {
        String importPath = SharedUtil.prefixIfRelative(htmlImport.value(), "frontend://");
        DependencyTreeCache<String> cache = service.getHtmlImportDependencyCache();
        Set<String> dependencies = cache.getDependencies(importPath);
        return new HtmlImportDependency(dependencies, htmlImport.loadMode());
    }

    private static Collection<SynchronizedPropertyInfo> findSynchronizedProperties(Class<? extends Component> componentClass) {
        HashMap<String, SynchronizedPropertyInfo> infos = new HashMap<String, SynchronizedPropertyInfo>();
        ComponentMetaData.collectSynchronizedProperties(componentClass, infos);
        return infos.values();
    }

    private static void collectSynchronizedProperties(Class<?> clazz, Map<String, SynchronizedPropertyInfo> infos) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        ComponentMetaData.doCollectSynchronizedProperties(clazz, infos);
        Class<?> superclass = clazz.getSuperclass();
        ComponentMetaData.collectSynchronizedProperties(superclass, infos);
        Stream.of(clazz.getInterfaces()).forEach(iface -> ComponentMetaData.collectSynchronizedProperties(iface, infos));
    }

    private static void doCollectSynchronizedProperties(Class<?> clazz, Map<String, SynchronizedPropertyInfo> infos) {
        for (Method method : clazz.getDeclaredMethods()) {
            Synchronize annotation = method.getAnnotation(Synchronize.class);
            if (annotation == null) continue;
            if (!ReflectTools.isGetter(method)) {
                throw new IllegalStateException(method + " is annotated with @" + Synchronize.class.getSimpleName() + " even though it's not a getter.");
            }
            if (infos.containsKey(method.getName())) continue;
            String propertyName = annotation.property().isEmpty() ? ReflectTools.getPropertyName(method) : annotation.property();
            String[] eventNames = annotation.value();
            infos.put(method.getName(), new SynchronizedPropertyInfo(propertyName, eventNames, annotation.allowUpdates()));
        }
    }

    private static Collection<JsModule> getHtmlImportAsJsModuleAnnotations(Class<? extends Component> componentClass) {
        return AnnotationReader.getHtmlImportAnnotations(componentClass).stream().map(ComponentMetaData::getHtmlImportAsJsModuleAnnotation).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static JsModule getHtmlImportAsJsModuleAnnotation(HtmlImport htmlImport) {
        String value = SharedUtil.prefixIfRelative(htmlImport.value(), "frontend://");
        String module = value.replaceFirst("^.*bower_components/(vaadin-.*)\\.html", "@vaadin/$1.js").replaceFirst("^.*bower_components/((iron|paper)-.*)\\.html", "@polymer/$1.js");
        return ComponentMetaData.jsModule(module, htmlImport.loadMode());
    }

    private static JsModule jsModule(final String value, final LoadMode loadMode) {
        return new JsModule(){

            @Override
            public String value() {
                return value;
            }

            @Override
            public LoadMode loadMode() {
                return loadMode;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return JsModule.class;
            }
        };
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ComponentMetaData.class);
    }

    public static class SynchronizedPropertyInfo {
        private final String property;
        private final DisabledUpdateMode mode;
        private final String[] eventNames;

        SynchronizedPropertyInfo(String property, String[] eventNames, DisabledUpdateMode mode) {
            this.property = property;
            this.eventNames = eventNames;
            this.mode = mode;
        }

        public String getProperty() {
            return this.property;
        }

        public Stream<String> getEventNames() {
            return Stream.of(this.eventNames);
        }

        public DisabledUpdateMode getUpdateMode() {
            return this.mode;
        }
    }

    public static class HtmlImportDependency {
        private final Collection<String> uris;
        private final LoadMode loadMode;

        private HtmlImportDependency(Collection<String> uris, LoadMode loadMode) {
            this.uris = Collections.unmodifiableCollection(uris);
            this.loadMode = loadMode;
        }

        public Collection<String> getUris() {
            return this.uris;
        }

        public LoadMode getLoadMode() {
            return this.loadMode;
        }
    }

    public static class DependencyInfo {
        private final List<HtmlImportDependency> htmlImports = new ArrayList<HtmlImportDependency>();
        private final List<JavaScript> javaScripts = new ArrayList<JavaScript>();
        private final List<JsModule> jsModules = new ArrayList<JsModule>();
        private final List<StyleSheet> styleSheets = new ArrayList<StyleSheet>();

        List<HtmlImportDependency> getHtmlImports() {
            return Collections.unmodifiableList(this.htmlImports);
        }

        List<JavaScript> getJavaScripts() {
            return Collections.unmodifiableList(this.javaScripts);
        }

        List<JsModule> getJsModules() {
            return Collections.unmodifiableList(this.jsModules);
        }

        List<StyleSheet> getStyleSheets() {
            return Collections.unmodifiableList(this.styleSheets);
        }
    }
}

