/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;

class FrontendClassVisitor
extends ClassVisitor {
    private static final String VARIANT = "variant";
    private static final String LAYOUT = "layout";
    static final String VALUE = "value";
    static final String VERSION = "version";
    static final Set<String> invalidClasses = new HashSet<String>();
    private final String className;
    private final EndPointData endPoint;
    private final MethodVisitor methodVisitor;
    private final AnnotationVisitor annotationVisitor;
    private final AnnotationVisitor routeVisitor;
    private final AnnotationVisitor themeRouteVisitor;
    private final AnnotationVisitor themeLayoutVisitor;
    private final AnnotationVisitor jsModuleVisitor;
    private final AnnotationVisitor jScriptVisitor;
    private final Set<String> children = new HashSet<String>();

    FrontendClassVisitor(String className, final EndPointData endPoint) {
        super(458752);
        this.className = className;
        this.endPoint = endPoint;
        this.methodVisitor = new MethodVisitor(458752){

            public void visitTypeInsn(int opcode, String type) {
                FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, type);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, owner);
                FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, descriptor);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, owner);
                FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, descriptor);
            }
        };
        this.routeVisitor = new RepeatedAnnotationVisitor(){

            public void visit(String name, Object value) {
                if (FrontendClassVisitor.LAYOUT.equals(name)) {
                    endPoint.layout = ((Type)value).getClassName();
                    FrontendClassVisitor.this.children.add(endPoint.layout);
                }
                if (FrontendClassVisitor.VALUE.equals(name)) {
                    endPoint.route = value.toString();
                }
            }
        };
        this.themeRouteVisitor = new RepeatedAnnotationVisitor(){

            public void visit(String name, Object value) {
                if (FrontendClassVisitor.VALUE.equals(name)) {
                    endPoint.theme.name = ((Type)value).getClassName();
                    FrontendClassVisitor.this.children.add(endPoint.theme.name);
                } else if (FrontendClassVisitor.VARIANT.equals(name)) {
                    endPoint.theme.variant = value.toString();
                }
            }
        };
        this.themeLayoutVisitor = new RepeatedAnnotationVisitor(){

            public void visit(String name, Object value) {
                if (FrontendClassVisitor.VALUE.equals(name) && endPoint.theme.name == null) {
                    FrontendClassVisitor.this.themeRouteVisitor.visit(name, value);
                } else if (FrontendClassVisitor.VARIANT.equals(name) && endPoint.theme.variant == null) {
                    FrontendClassVisitor.this.themeRouteVisitor.visit(name, value);
                }
            }
        };
        this.jsModuleVisitor = new RepeatedAnnotationVisitor(){

            public void visit(String name, Object value) {
                endPoint.modules.add(value.toString());
            }
        };
        this.jScriptVisitor = new RepeatedAnnotationVisitor(){

            public void visit(String name, Object value) {
                endPoint.scripts.add(value.toString());
            }
        };
        this.annotationVisitor = new RepeatedAnnotationVisitor(){

            public void visit(String name, Object value) {
                if (value != null && !value.getClass().isPrimitive() && !value.getClass().equals(String.class)) {
                    FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, value.toString());
                }
            }
        };
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.addSignatureToClasses(this.children, superName);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.addSignatureToClasses(this.children, descriptor);
        return this.methodVisitor;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.addSignatureToClasses(this.children, descriptor);
        String cname = descriptor.replace("/", ".");
        if (this.className.equals(this.endPoint.name) && cname.contains(Route.class.getName())) {
            return this.routeVisitor;
        }
        if (cname.contains(JsModule.class.getName())) {
            return this.jsModuleVisitor;
        }
        if (cname.contains(JavaScript.class.getName())) {
            return this.jScriptVisitor;
        }
        if (cname.contains(NoTheme.class.getName())) {
            if (this.className.equals(this.endPoint.name)) {
                this.endPoint.theme.notheme = true;
            }
            return null;
        }
        if (cname.contains(Theme.class.getName())) {
            if (this.className.equals(this.endPoint.name)) {
                return this.themeRouteVisitor;
            }
            if (this.className.equals(this.endPoint.layout)) {
                return this.themeLayoutVisitor;
            }
        }
        return this.annotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.addSignatureToClasses(this.children, descriptor);
        return null;
    }

    public Set<String> getChildren() {
        return this.children;
    }

    void addSignatureToClasses(Set<String> classes, String signature) {
        if (signature == null || signature.isEmpty()) {
            return;
        }
        String[] tmp = signature.replace("/", ".").split("(^\\([\\[ZBFDJICL]*|^[\\[ZBFDJICL]+|;?\\)[\\[ZBFDJICLV]*|;[\\[ZBFDJICL]*)");
        classes.addAll(Arrays.asList(tmp));
    }

    static class ThemeData
    implements Serializable {
        private String name;
        private String variant = "";
        private boolean notheme;

        ThemeData() {
        }

        String getName() {
            return this.name;
        }

        String getVariant() {
            return this.variant;
        }

        boolean isNotheme() {
            return this.notheme;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ThemeData)) {
                return false;
            }
            ThemeData that = (ThemeData)other;
            return this.notheme == that.notheme && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.notheme);
        }

        public String toString() {
            return " notheme: " + this.notheme + "\n name:" + this.name + "\n variant: " + this.variant;
        }
    }

    static class EndPointData
    implements Serializable {
        private final String name;
        private String route = "";
        private String layout;
        private ThemeData theme = new ThemeData();
        private final HashSet<String> modules = new HashSet();
        private final HashSet<String> scripts = new HashSet();
        private final HashSet<String> classes = new HashSet();

        EndPointData(Class<?> clazz) {
            this.name = clazz.getName();
        }

        public String toString() {
            return String.format("%n view: %s%n route: %s%n%s%n layout: %s%n modules: %s%n scripts: %s%n", this.name, this.route, this.theme, this.layout, this.col2Str(this.modules), this.col2Str(this.scripts));
        }

        Set<String> getModules() {
            return this.modules;
        }

        Set<String> getScripts() {
            return this.scripts;
        }

        Set<String> getClasses() {
            return this.classes;
        }

        boolean hasData() {
            boolean hasTheme = this.theme.name != null || this.theme.notheme;
            boolean hasScriptsOrModules = this.modules.size() > 0 || this.scripts.size() > 0;
            return hasTheme || this.layout != null || hasScriptsOrModules;
        }

        ThemeData getTheme() {
            return this.theme;
        }

        String getRoute() {
            return this.route;
        }

        String getName() {
            return this.name;
        }

        private String col2Str(Collection<String> s) {
            return String.join((CharSequence)"\n          ", s);
        }
    }

    static class RepeatedAnnotationVisitor
    extends AnnotationVisitor {
        public RepeatedAnnotationVisitor() {
            super(458752);
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            return this;
        }
    }
}

