/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.frontend.FrontendToolsLocator;
import com.vaadin.flow.server.frontend.WebpackDevServerPort;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendUtils {
    public static final String PROJECT_BASEDIR = "project.basedir";
    public static final String DEFAULT_NODE_DIR = "./";
    public static final String NODE_MODULES = "node_modules/";
    public static final String FRONTEND = "frontend/";
    public static final String DEFAULT_FRONTEND_DIR = "./frontend/";
    public static final String WEBPACK_CONFIG = "webpack.config.js";
    public static final String WEBPACK_GENERATED = "webpack.generated.js";
    public static final String FLOW_NPM_PACKAGE_NAME = "@vaadin/flow-frontend/";
    public static final String TARGET = "target/";
    public static final String DEFAULT_GENERATED_DIR = "target/frontend/";
    public static final String IMPORTS_NAME = "generated-flow-imports.js";
    public static final String PARAM_GENERATED_DIR = "vaadin.frontend.generated.folder";
    public static final String PARAM_FRONTEND_DIR = "vaadin.frontend.frontend.folder";
    public static final String PARAM_IGNORE_VERSION_CHECKS = "vaadin.ignoreVersionChecks";
    public static final String WEBPACK_PREFIX_ALIAS = "Frontend/";
    public static final String TOKEN_FILE = "config/flow-build-info.json";
    public static final String PARAM_TOKEN_FILE = "vaadin.frontend.token.file";
    private static final String NOT_FOUND = "%n%n======================================================================================================%nFailed to determine '%s' tool.%nPlease install it either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v10.16.0\" %n======================================================================================================%n";
    private static final String SHOULD_WORK = "%n%n======================================================================================================%nYour installed '%s' version (%s) is not supported but should still work. Supported versions are %d.%d+%nYou can install a new one:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v10.16.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static final String TOO_OLD = "%n%n======================================================================================================%nYour installed '%s' version (%s) is too old. Supported versions are %d.%d+%nPlease install a new one either:%n  - by following the https://nodejs.org/en/download/ guide to install it globally%n  - or by running the frontend-maven-plugin goal to install it in this project:%n  $ mvn com.github.eirslett:frontend-maven-plugin:1.7.6:install-node-and-npm -DnodeVersion=\"v11.6.0\" %n%nYou can disable the version check using -D%s=true%n======================================================================================================%n";
    private static FrontendToolsLocator frontendToolsLocator = new FrontendToolsLocator();
    private static String operatingSystem = null;

    private FrontendUtils() {
    }

    public static String getOsName() {
        if (operatingSystem == null) {
            operatingSystem = System.getProperty("os.name");
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return FrontendUtils.getOsName().startsWith("Windows");
    }

    public static String getNodeExecutable(String baseDir) {
        String command = FrontendUtils.isWindows() ? "node.exe" : "node";
        String defaultNode = FrontendUtils.isWindows() ? "node/node.exe" : "node/node";
        return FrontendUtils.getExecutable(baseDir, command, defaultNode).getAbsolutePath();
    }

    public static List<String> getNpmExecutable(String baseDir) {
        File file = new File(baseDir, "node/node_modules/npm/bin/npm-cli.js");
        if (file.canRead()) {
            return Arrays.asList(FrontendUtils.getNodeExecutable(baseDir), file.getAbsolutePath());
        }
        String command = FrontendUtils.isWindows() ? "npm.cmd" : "npm";
        return Arrays.asList(FrontendUtils.getExecutable(baseDir, command, null).getAbsolutePath());
    }

    private static File getExecutable(String baseDir, String cmd, String defaultLocation) {
        File file = null;
        try {
            file = defaultLocation == null ? (File)frontendToolsLocator.tryLocateTool(cmd).orElse(null) : Optional.of(new File(baseDir, defaultLocation)).filter(frontendToolsLocator::verifyTool).orElseGet(() -> frontendToolsLocator.tryLocateTool(cmd).orElse(null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null) {
            throw new IllegalStateException(String.format(NOT_FOUND, cmd));
        }
        return file;
    }

    public static String streamToString(InputStream inputStream) {
        String ret = "";
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8.name()));){
            ret = br.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException exception) {
            LoggerFactory.getLogger(FrontendUtils.class).warn("Couldn't close template input stream", (Throwable)exception);
        }
        return ret;
    }

    public static ProcessBuilder createProcessBuilder(List<String> command) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        File commandFile = new File(command.get(0));
        if (commandFile.isAbsolute()) {
            String commandPath = commandFile.getParent();
            Map<String, String> environment = processBuilder.environment();
            String path = environment.get("PATH");
            if (path == null || path.isEmpty()) {
                path = commandPath;
            } else if (!path.contains(commandPath)) {
                path = path + File.pathSeparatorChar + commandPath;
            }
            environment.put("PATH", path);
        }
        return processBuilder;
    }

    public static String getStatsContent(VaadinService service) throws IOException {
        DeploymentConfiguration config = service.getDeploymentConfiguration();
        String stats = config.getStringProperty("statistics.file.path", "META-INF/VAADIN/config/stats.json").replaceFirst("^/", "");
        InputStream content = service.getClassLoader().getResourceAsStream(stats);
        if (content != null) {
            FrontendUtils.getLogger().debug("Found stats file as a resource file '{}'.", (Object)stats);
        } else {
            URL statsUrl = null;
            statsUrl = config.isProductionMode() ? service.getStaticResource("/" + stats) : FrontendUtils.getStatsFromWebpack(service, stats, statsUrl);
            if (statsUrl != null) {
                FrontendUtils.getLogger().debug("Found stats file at url '{}'", (Object)statsUrl);
                content = statsUrl.openStream();
            }
        }
        return content != null ? FrontendUtils.streamToString(content) : null;
    }

    private static URL getStatsFromWebpack(VaadinService service, String stats, URL statsUrl) throws MalformedURLException {
        WebpackDevServerPort port = service.getContext().getAttribute(WebpackDevServerPort.class);
        if (port != null) {
            statsUrl = new URL("http://localhost:" + port + "/" + stats);
        }
        if (statsUrl == null) {
            statsUrl = service.getStaticResource("/" + stats);
            if (statsUrl == null) {
                FrontendUtils.getLogger().warn("Cannot get the stats file through webpack-dev-server. The webpack port is unavailable via VaadinContext.");
            } else {
                FrontendUtils.getLogger().debug("Cannot get the stats file through webpack-dev-server, however it was found in the web context, which means that the application was build previously. To disable this message run the application in PRODUCTION mode.");
            }
        }
        return statsUrl;
    }

    public static void validateNodeAndNpmVersion(String baseDir) {
        try {
            ArrayList<String> nodeVersionCommand = new ArrayList<String>();
            nodeVersionCommand.add(FrontendUtils.getNodeExecutable(baseDir));
            nodeVersionCommand.add("--version");
            String[] nodeVersion = FrontendUtils.getVersion("node", nodeVersionCommand);
            FrontendUtils.validateToolVersion("node", nodeVersion, 10, 0, 8, 9);
        }
        catch (UnknownVersionException e) {
            FrontendUtils.getLogger().warn("Error checking if node is new enough", (Throwable)e);
        }
        try {
            ArrayList<String> npmVersionCommand = new ArrayList<String>();
            npmVersionCommand.addAll(FrontendUtils.getNpmExecutable(baseDir));
            npmVersionCommand.add("--version");
            String[] npmVersion = FrontendUtils.getVersion("npm", npmVersionCommand);
            FrontendUtils.validateToolVersion("npm", npmVersion, 5, 6, 5, 5);
        }
        catch (UnknownVersionException e) {
            FrontendUtils.getLogger().warn("Error checking if npm is new enough", (Throwable)e);
        }
    }

    static void validateToolVersion(String tool, String[] toolVersion, int supportedMajor, int supportedMinor, int shouldWorkMajor, int shouldWorkMinor) throws UnknownVersionException {
        if ("true".equalsIgnoreCase(System.getProperty(PARAM_IGNORE_VERSION_CHECKS))) {
            return;
        }
        if (FrontendUtils.isVersionAtLeast(tool, toolVersion, supportedMajor, supportedMinor)) {
            return;
        }
        if (FrontendUtils.isVersionAtLeast(tool, toolVersion, shouldWorkMajor, shouldWorkMinor)) {
            FrontendUtils.getLogger().warn(String.format(SHOULD_WORK, tool, FrontendUtils.join(toolVersion, "."), supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS));
            return;
        }
        throw new IllegalStateException(String.format(TOO_OLD, tool, FrontendUtils.join(toolVersion, "."), supportedMajor, supportedMinor, PARAM_IGNORE_VERSION_CHECKS));
    }

    static boolean isVersionAtLeast(String tool, String[] toolVersion, int requiredMajor, int requiredMinor) throws UnknownVersionException {
        try {
            int major = Integer.parseInt(toolVersion[0]);
            int minor = Integer.parseInt(toolVersion[1]);
            return major > requiredMajor || major == requiredMajor && minor >= requiredMinor;
        }
        catch (NumberFormatException e) {
            throw new UnknownVersionException(tool, "Reported version " + FrontendUtils.join(toolVersion, ".") + " could not be parsed", e);
        }
    }

    private static String join(String[] toolVersion, String separate) {
        return Stream.of(toolVersion).collect(Collectors.joining(separate));
    }

    private static String[] getVersion(String tool, List<String> versionCommand) throws UnknownVersionException {
        String[] command = versionCommand.toArray(new String[versionCommand.size()]);
        try {
            Process process = new ProcessBuilder(command).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new UnknownVersionException(tool, "Using command " + FrontendUtils.join(command, " "));
            }
            String output = FrontendUtils.streamToString(process.getInputStream());
            return output.replaceFirst("^v", "").replaceAll("\n", "").split("\\.", 3);
        }
        catch (IOException | InterruptedException e) {
            throw new UnknownVersionException(tool, "Using command " + FrontendUtils.join(command, " "), e);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(FrontendUtils.class);
    }

    public static class UnknownVersionException
    extends Exception {
        public UnknownVersionException(String tool, String extraInfo) {
            super("Unable to detect version of " + tool + "." + extraInfo);
        }

        public UnknownVersionException(String tool, String extraInfo, Exception cause) {
            super("Unable to detect version of " + tool + "." + extraInfo, cause);
        }
    }
}

