/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.frontend.NodeUpdater;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class TaskUpdateWebpack
implements Command {
    private final String webpackTemplate;
    private final String webpackGeneratedTemplate;
    private final transient Path webpackOutputPath;
    private final transient Path flowImportsFilePath;
    private final transient Path webpackConfigPath;

    TaskUpdateWebpack(File webpackConfigFolder, File webpackOutputDirectory, String webpackTemplate, String webpackGeneratedTemplate, File generatedFlowImports) {
        this.webpackTemplate = webpackTemplate;
        this.webpackGeneratedTemplate = webpackGeneratedTemplate;
        this.webpackOutputPath = webpackOutputDirectory.toPath();
        this.flowImportsFilePath = generatedFlowImports.toPath();
        this.webpackConfigPath = webpackConfigFolder.toPath();
    }

    @Override
    public void execute() {
        try {
            this.createWebpackConfig();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void createWebpackConfig() throws IOException {
        if (this.webpackTemplate == null || this.webpackTemplate.trim().isEmpty()) {
            return;
        }
        File configFile = new File(this.webpackConfigPath.toFile(), "webpack.config.js");
        if (configFile.exists() && !FileUtils.readFileToString((File)configFile, (String)"UTF-8").contains("./webpack.generated.js")) {
            NodeUpdater.log().warn("Flow generated webpack configuration was not mentioned in the configuration file: {}.Please verify that './webpack.generated.js' is used in the merge or remove the file to generate a new one.", (Object)configFile);
        }
        if (!configFile.exists()) {
            URL resource = this.getClass().getClassLoader().getResource(this.webpackTemplate);
            FileUtils.copyURLToFile((URL)resource, (File)configFile);
            NodeUpdater.log().info("Created webpack configuration file: " + configFile);
        }
        File generatedFile = new File(this.webpackConfigPath.toFile(), "webpack.generated.js");
        URL resource = this.getClass().getClassLoader().getResource(this.webpackGeneratedTemplate);
        FileUtils.copyURLToFile((URL)resource, (File)generatedFile);
        List lines = FileUtils.readLines((File)generatedFile, (String)"UTF-8");
        String outputLine = "mavenOutputFolderForFlowBundledFiles = require('path').resolve(__dirname, '" + this.getEscapedRelativeWebpackPath(this.webpackOutputPath) + "');";
        String mainLine = "fileNameOfTheFlowGeneratedMainEntryPoint = require('path').resolve(__dirname, '" + this.getEscapedRelativeWebpackPath(this.flowImportsFilePath) + "');";
        for (int i = 0; i < lines.size(); ++i) {
            String line = ((String)lines.get(i)).trim();
            if (((String)lines.get(i)).startsWith("fileNameOfTheFlowGeneratedMainEntryPoint") && !line.equals(mainLine)) {
                lines.set(i, mainLine);
            }
            if (!((String)lines.get(i)).startsWith("mavenOutputFolderForFlowBundledFiles") || line.equals(outputLine)) continue;
            lines.set(i, outputLine);
        }
        FileUtils.writeLines((File)generatedFile, (Collection)lines);
    }

    private String getEscapedRelativeWebpackPath(Path path) {
        Path relativePath = path.isAbsolute() ? this.webpackConfigPath.relativize(path) : path;
        return relativePath.toString().replaceAll("\\\\", "/");
    }
}

