/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.server.webcomponent.WebComponentExporterTagExtractor;
import com.vaadin.flow.server.webcomponent.WebComponentGenerator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public final class WebComponentModulesWriter
implements Serializable {
    private WebComponentModulesWriter() {
    }

    private static Set<File> writeWebComponentsToDirectory(Set<Class<? extends WebComponentExporter<? extends Component>>> exporterClasses, File outputDirectory, boolean compatibilityMode) {
        Objects.requireNonNull(exporterClasses, "Parameter 'exporterClasses' must not be null");
        Objects.requireNonNull(outputDirectory, "Parameter 'outputDirectory' must not be null");
        if (!outputDirectory.isDirectory()) {
            throw new IllegalArgumentException(String.format("Path provided by parameter 'outputDirectory' (%s) is not a directory", outputDirectory.getPath()));
        }
        return WebComponentModulesWriter.filterConcreteExporters(exporterClasses).map(clazz -> WebComponentModulesWriter.writeWebComponentToDirectory(clazz, outputDirectory, compatibilityMode)).collect(Collectors.toSet());
    }

    private static Stream<Class<? extends WebComponentExporter<? extends Component>>> filterConcreteExporters(Set<Class<? extends WebComponentExporter<? extends Component>>> exporterClasses) {
        return exporterClasses.stream().filter(clazz -> WebComponentExporter.class.isAssignableFrom((Class<?>)clazz) && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers()));
    }

    private static File writeWebComponentToDirectory(Class<? extends WebComponentExporter<? extends Component>> clazz, File outputDirectory, boolean compatibilityMode) {
        String tag = WebComponentModulesWriter.getTag(clazz);
        String fileName = compatibilityMode ? tag + ".html" : tag + ".js";
        Path generatedFile = outputDirectory.toPath().resolve(fileName);
        try {
            FileUtils.forceMkdir((File)generatedFile.getParent().toFile());
            Files.write(generatedFile, Collections.singletonList(WebComponentModulesWriter.generateModule(clazz, compatibilityMode)), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create web component module file '%s'", generatedFile), e);
        }
        return generatedFile.toFile();
    }

    private static String generateModule(Class<? extends WebComponentExporter<? extends Component>> exporterClass, boolean compatibilityMode) {
        return WebComponentGenerator.generateModule(exporterClass, "../", compatibilityMode);
    }

    private static String getTag(Class<? extends WebComponentExporter<? extends Component>> exporterClass) {
        WebComponentExporterTagExtractor exporterTagExtractor = new WebComponentExporterTagExtractor();
        return exporterTagExtractor.apply(exporterClass);
    }

    public static final class DirectoryWriter
    implements Serializable {
        private static final String WRITE_MODULES_METHOD = "writeWebComponentsToDirectory";

        public static Set<File> generateWebComponentsToDirectory(Class<?> writerClass, Set<Class<?>> exporterClasses, File outputDirectory, boolean compatibilityMode) {
            Objects.requireNonNull(writerClass, "Parameter 'writerClassSupplier' must not null");
            Objects.requireNonNull(exporterClasses, "Parameter 'exporterClassSupplier' must not be null");
            Objects.requireNonNull(outputDirectory, "Parameter 'outputDirectory' must not be null");
            for (Class<?> exporterClass : exporterClasses) {
                if (writerClass.getClassLoader().equals(exporterClass.getClassLoader())) continue;
                throw new IllegalArgumentException(String.format("Supplied writer '%s' and supplied exporter '%s' have different class loaders, '%s' and '%s', respectively. Writer and exporters must share a class loader.", writerClass.getName(), exporterClass.getName(), writerClass.getClassLoader().getClass().getName(), exporterClass.getClassLoader().getClass().getName()));
            }
            if (!WebComponentModulesWriter.class.getName().equals(writerClass.getName())) {
                throw new IllegalArgumentException("Argument 'writer' should be a class of '" + WebComponentModulesWriter.class.getName() + "' but it is '" + writerClass.getName() + "'");
            }
            Method writeMethod = DirectoryWriter.getMethod(writerClass, WRITE_MODULES_METHOD).orElseThrow(() -> new IllegalStateException(String.format("Could not locate locate method '%s' on the received writer '%s'.", WRITE_MODULES_METHOD, writerClass.getName())));
            try {
                boolean accessible = writeMethod.isAccessible();
                writeMethod.setAccessible(true);
                Set files = (Set)writeMethod.invoke(null, exporterClasses, outputDirectory, compatibilityMode);
                writeMethod.setAccessible(accessible);
                return files;
            }
            catch (IllegalAccessException | NullPointerException | InvocationTargetException e) {
                throw new RuntimeException("Could not write exported web component module!", e);
            }
        }

        private static Optional<Method> getMethod(Class<?> writerClass, String methodName) {
            return Stream.of(writerClass.getDeclaredMethods()).filter(method -> method.getName().equals(methodName)).findFirst();
        }
    }
}

