/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.webcomponent;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import com.vaadin.flow.component.webcomponent.WebComponentWrapper;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.webcomponent.WebComponentBinding;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.ThemeDefinition;
import com.vaadin.flow.theme.ThemeUtil;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class WebComponentUI
extends UI {
    public static final String NO_NAVIGATION = "Navigation is not available for WebComponents";

    @Override
    public void doInit(VaadinRequest request, int uiId) {
        super.doInit(request, uiId);
        this.assignTheme();
        VaadinSession session = this.getSession();
        DeploymentConfiguration deploymentConfiguration = session.getService().getDeploymentConfiguration();
        if (deploymentConfiguration.isCompatibilityMode() && deploymentConfiguration.useCompiledFrontendResources()) {
            this.getConfigurationRegistry().getConfigurations().forEach(config -> this.getPage().addHtmlImport(this.getWebComponentHtmlPath((WebComponentConfiguration<? extends Component>)config)));
        }
    }

    @ClientCallable
    public void connectWebComponent(String tag, String webComponentElementId, JsonObject attributeJson) {
        Optional<WebComponentConfiguration<? extends Component>> webComponentConfiguration = this.getConfigurationRegistry().getConfiguration(tag);
        if (!webComponentConfiguration.isPresent()) {
            LoggerFactory.getLogger(WebComponentUI.class).warn("Received connect request for non existing WebComponent '{}'", (Object)tag);
            return;
        }
        Element rootElement = new Element(tag);
        WebComponentBinding<? extends Component> binding = webComponentConfiguration.get().createWebComponentBinding(Instantiator.get(this), rootElement, attributeJson);
        WebComponentWrapper wrapper = new WebComponentWrapper(rootElement, binding);
        this.getElement().getStateProvider().appendVirtualChild(this.getElement().getNode(), wrapper.getElement(), "@id", webComponentElementId);
        wrapper.getElement().executeJs("$0.serverConnected()", new Serializable[0]);
    }

    @Override
    public Router getRouter() {
        return null;
    }

    @Override
    public Optional<ThemeDefinition> getThemeFor(Class<?> navigationTarget, String path) {
        return Optional.empty();
    }

    @Override
    public void navigate(String location) {
        throw new UnsupportedOperationException(NO_NAVIGATION);
    }

    @Override
    public void navigate(Class<? extends Component> navigationTarget) {
        throw new UnsupportedOperationException(NO_NAVIGATION);
    }

    @Override
    public <T, C extends Component> void navigate(Class<? extends C> navigationTarget, T parameter) {
        throw new UnsupportedOperationException(NO_NAVIGATION);
    }

    @Override
    public void navigate(String location, QueryParameters queryParameters) {
        throw new UnsupportedOperationException(NO_NAVIGATION);
    }

    private void assignTheme() {
        WebComponentConfigurationRegistry registry = this.getConfigurationRegistry();
        Optional<Theme> theme = registry.getEmbeddedApplicationAnnotation(Theme.class);
        if (theme.isPresent()) {
            this.getInternals().setTheme(theme.get().value());
            this.assignVariant(registry, theme.get());
        } else {
            ThemeUtil.getLumoThemeDefinition().map(ThemeDefinition::getTheme).ifPresent(this.getInternals()::setTheme);
        }
    }

    private void assignVariant(WebComponentConfigurationRegistry registry, Theme theme) {
        AbstractTheme themeInstance = Instantiator.get(this).getOrCreate(theme.value());
        ThemeDefinition definition = new ThemeDefinition(theme);
        Map<String, String> attributes = themeInstance.getHtmlAttributes(definition.getVariant());
        registry.getConfigurations().forEach(config -> this.addAttributes(config.getTag(), attributes));
    }

    private void addAttributes(String tag, Map<String, String> attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append("var elements = document.querySelectorAll('").append(tag).append("');").append("for (let i = 0; i < elements.length; i++) {");
        attributes.forEach((attribute, value) -> builder.append("elements[i].setAttribute('").append((String)attribute).append("', '").append((String)value).append("');"));
        builder.append("}");
        this.getPage().executeJs(builder.toString(), new Serializable[0]);
    }

    private String getWebComponentHtmlPath(WebComponentConfiguration<? extends Component> config) {
        DeploymentConfiguration deploymentConfiguration = this.getSession().getService().getDeploymentConfiguration();
        String path = deploymentConfiguration.getCompiledWebComponentsPath();
        return path + '/' + config.getTag() + ".html";
    }

    private WebComponentConfigurationRegistry getConfigurationRegistry() {
        return WebComponentConfigurationRegistry.getInstance(this.getSession().getService().getContext());
    }
}

