/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendToolsLocator
implements Serializable {
    public Optional<File> tryLocateTool(String toolName) {
        List candidateLocations = this.executeCommand(this.isWindows() ? "where" : "which", toolName).map(this::omitErrorResult).map(rec$ -> ((CommandResult)rec$).getStdout()).orElseGet(() -> Arrays.asList("/usr/local/bin/" + toolName, "/opt/local/bin/" + toolName, "/opt/bin/" + toolName));
        for (String candidateLocation : candidateLocations) {
            File candidate = new File(candidateLocation);
            if (!this.verifyTool(candidate)) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    public boolean verifyTool(File toolPath) {
        return Optional.ofNullable(toolPath).filter(File::isFile).map(File::getAbsolutePath).flatMap(path -> this.executeCommand((String)path, "-v")).map(this::omitErrorResult).isPresent();
    }

    boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().startsWith("windows");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<CommandResult> executeCommand(String ... commandParts) {
        List stderr;
        List stdout;
        Process process;
        String commandString = Arrays.toString(commandParts);
        try {
            process = FrontendUtils.createProcessBuilder(Arrays.asList(commandParts)).start();
        }
        catch (IOException e) {
            this.log().error("Failed to execute the command '{}'", (Object)commandString, (Object)e);
            return Optional.empty();
        }
        int exitCode = -1;
        long timeStamp = System.currentTimeMillis();
        try {
            exitCode = process.waitFor();
        }
        catch (InterruptedException e) {
            this.log().error("Unexpected interruption happened during '{}' command execution", (Object)commandString, (Object)e);
            Optional<CommandResult> optional = Optional.empty();
            return optional;
        }
        finally {
            if (exitCode == -1) {
                process.destroyForcibly();
            }
        }
        long executionTime = System.currentTimeMillis() - timeStamp;
        if (this.log().isDebugEnabled() && executionTime > 3000L) {
            this.log().debug("Command '{}' execution took over 3 seconds", (Object)commandString);
        }
        if (exitCode > 0) {
            this.log().error("Command '{}' failed with exit code '{}'", (Object)commandString, (Object)exitCode);
            return Optional.empty();
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            stdout = br.lines().collect(Collectors.toList());
        }
        catch (IOException e) {
            this.log().error("Failed to read the command '{}' stdout", (Object)commandString, (Object)e);
            return Optional.empty();
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
            stderr = br.lines().collect(Collectors.toList());
        }
        catch (IOException e) {
            this.log().error("Failed to read the command '{}' stderr", (Object)commandString, (Object)e);
            return Optional.empty();
        }
        return Optional.of(new CommandResult(commandString, process.exitValue(), stdout, stderr));
    }

    private CommandResult omitErrorResult(CommandResult commandResult) {
        if (!commandResult.isSuccessful()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("Command '{}' exited with non-zero exit code: {}. stdout:\n'{}'\nstderr:\n'{}'", new Object[]{commandResult.command, commandResult.exitCode, commandResult.exitCode, String.join((CharSequence)"\n", commandResult.stderr)});
            }
            return null;
        }
        if (commandResult.stdout.isEmpty()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("Command '{}' has no output, stderr:\n'{}'", (Object)commandResult.command, (Object)String.join((CharSequence)"\n", commandResult.stderr));
            }
            return null;
        }
        if (!commandResult.stderr.isEmpty()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("Command '{}' has non-empty stderr:\n'{}'", (Object)commandResult.command, (Object)String.join((CharSequence)"\n", commandResult.stderr));
            }
            return null;
        }
        return commandResult;
    }

    private Logger log() {
        return LoggerFactory.getLogger(FrontendToolsLocator.class);
    }

    private static class CommandResult
    implements Serializable {
        private final String command;
        private final int exitCode;
        private final List<String> stdout;
        private final List<String> stderr;

        private CommandResult(String command, int exitCode, List<String> stdout, List<String> stderr) {
            this.command = command;
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        private List<String> getStdout() {
            return this.stdout;
        }

        private boolean isSuccessful() {
            return this.exitCode == 0;
        }
    }
}

