/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class QueryParameters
implements Serializable {
    private static final String PARAMETER_VALUES_SEPARATOR = "=";
    private static final String PARAMETERS_SEPARATOR = "&";
    private final Map<String, List<String>> parameters;

    public QueryParameters(Map<String, List<String>> parameters) {
        this.parameters = Collections.unmodifiableMap(parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableList(new ArrayList((Collection)entry.getValue())))));
    }

    public static QueryParameters empty() {
        return new QueryParameters(Collections.emptyMap());
    }

    public static QueryParameters full(Map<String, String[]> parameters) {
        return new QueryParameters(QueryParameters.convertArraysToLists(parameters));
    }

    private static Map<String, List<String>> convertArraysToLists(Map<String, String[]> fullParameters) {
        return fullParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Arrays.asList((Object[])entry.getValue())));
    }

    public static QueryParameters simple(Map<String, String> parameters) {
        return new QueryParameters(QueryParameters.toFullParameters(parameters));
    }

    private static Map<String, List<String>> toFullParameters(Map<String, String> simpleParameters) {
        return simpleParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList(entry.getValue())));
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public String getQueryString() {
        return this.parameters.entrySet().stream().flatMap(this::getParameterAndValues).collect(Collectors.joining(PARAMETERS_SEPARATOR));
    }

    private Stream<String> getParameterAndValues(Map.Entry<String, List<String>> entry) {
        if (entry.getValue().isEmpty()) {
            return Stream.of(entry.getKey());
        }
        String param = entry.getKey();
        return entry.getValue().stream().map(value -> value == null ? param : param + PARAMETER_VALUES_SEPARATOR + value);
    }
}

