/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.Serializable;

class FrontendVersion
implements Serializable {
    private final String version;
    private final int majorVersion;
    private final int minorVersion;
    private final int revision;
    private final String buildIdentifier;

    public FrontendVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public FrontendVersion(int major, int minor, int revision) {
        this(major, minor, revision, "");
    }

    public FrontendVersion(int major, int minor, int revision, String build) {
        this.version = major + "." + minor + "." + revision;
        this.majorVersion = major;
        this.minorVersion = minor;
        this.revision = revision;
        this.buildIdentifier = build;
    }

    public FrontendVersion(String version) {
        int revisionNumber;
        String build;
        block3: {
            this.version = version;
            String[] digits = version.split("[-.]", 4);
            this.majorVersion = Integer.parseInt(digits[0]);
            this.minorVersion = Integer.parseInt(digits[1]);
            build = "";
            try {
                int n = revisionNumber = digits.length >= 3 ? Integer.parseInt(digits[2]) : 0;
                if (digits.length == 4) {
                    build = digits[3];
                }
            }
            catch (NumberFormatException e) {
                revisionNumber = 0;
                if (digits.length < 3) break block3;
                build = digits[2];
            }
        }
        this.revision = revisionNumber;
        this.buildIdentifier = build;
    }

    public String getFullVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FrontendVersion) {
            FrontendVersion other = (FrontendVersion)obj;
            return this.majorVersion == other.getMajorVersion() && this.minorVersion == other.getMinorVersion() && this.revision == other.getRevision() && this.buildIdentifier.equals(other.getBuildIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.version.hashCode();
    }
}

