/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.server.VaadinService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;

@Tag(value="div")
public class InternalServerError
extends Component
implements HasErrorParameter<Exception> {
    @Override
    public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<Exception> parameter) {
        String exceptionText = parameter.hasCustomMessage() ? String.format("There was an exception while trying to navigate to '%s' with the exception message '%s'", event.getLocation().getPath(), parameter.getCustomMessage()) : String.format("There was an exception while trying to navigate to '%s'", event.getLocation().getPath());
        Exception exception = parameter.getException();
        if (exception != null) {
            this.reportException(exception, event.getLocation().getPath(), exceptionText);
        } else {
            this.getElement().setText(exceptionText);
        }
        return 500;
    }

    protected boolean hasLogBinding() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        return loggerFactory != null && !NOPLoggerFactory.class.equals(loggerFactory.getClass());
    }

    private void reportException(Exception exception, String path, String exceptionText) {
        boolean productionMode;
        this.getElement().appendChild(Element.createText(exceptionText));
        VaadinService vaadinService = VaadinService.getCurrent();
        boolean bl = productionMode = vaadinService != null && vaadinService.getDeploymentConfiguration().isProductionMode();
        if (!productionMode) {
            this.checkLogBinding();
            this.printStacktrace(exception);
        }
        InternalServerError.getLogger().error("There was an exception while trying to navigate to '{}'", (Object)path, (Object)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStacktrace(Exception exception) {
        StringWriter writer = new StringWriter();
        try {
            exception.printStackTrace(new PrintWriter(writer));
            this.getElement().appendChild(ElementFactory.createPreformatted(writer.toString()));
        }
        finally {
            block8: {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
        }
    }

    private void checkLogBinding() {
        if (!this.hasLogBinding()) {
            Element logInfo = ElementFactory.createDiv("Your application doesn't have SLF4J binding. As a result the logger doesn't do any real logging. Add some binding as a dependency to your project. See details ");
            logInfo.getStyle().set("marginTop", "10px");
            logInfo.getStyle().set("marginBottom", "10px");
            logInfo.getStyle().set("fontWeight", "bold");
            logInfo.getStyle().set("color", "#6495ED");
            logInfo.appendChild(ElementFactory.createAnchor("https://www.slf4j.org/manual.html#swapping", "here"));
            this.getElement().appendChild(logInfo);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)InternalServerError.class.getName());
    }
}

