/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.DeploymentConfigurationFactory;
import com.vaadin.flow.server.DevModeHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.ServiceException;
import com.vaadin.flow.server.StaticFileHandler;
import com.vaadin.flow.server.StaticFileServer;
import com.vaadin.flow.server.SystemMessages;
import com.vaadin.flow.server.VaadinConfigurationException;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletConfig;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletResponse;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.webjar.WebJarServer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VaadinServlet
extends HttpServlet {
    private VaadinServletService servletService;
    private StaticFileHandler staticFileHandler;
    private WebJarServer webJarServer;

    public void init(ServletConfig servletConfig) throws ServletException {
        CurrentInstance.clearAll();
        super.init(servletConfig);
        try {
            this.servletService = this.createServletService();
        }
        catch (ServiceException e) {
            throw new ServletException("Could not initialize VaadinServlet", (Throwable)e);
        }
        DeploymentConfiguration deploymentConfiguration = this.servletService.getDeploymentConfiguration();
        this.staticFileHandler = this.createStaticFileHandler(this.servletService);
        if (deploymentConfiguration.areWebJarsEnabled()) {
            this.webJarServer = new WebJarServer(deploymentConfiguration);
        }
        this.servletService.setCurrentInstances(null, null);
        this.servletInitialized();
        CurrentInstance.clearAll();
    }

    protected StaticFileHandler createStaticFileHandler(VaadinServletService servletService) {
        return new StaticFileServer(servletService);
    }

    protected void servletInitialized() throws ServletException {
    }

    public static VaadinServlet getCurrent() {
        VaadinService vaadinService = CurrentInstance.get(VaadinService.class);
        if (vaadinService instanceof VaadinServletService) {
            VaadinServletService vss = (VaadinServletService)vaadinService;
            return vss.getServlet();
        }
        return null;
    }

    protected DeploymentConfiguration createDeploymentConfiguration() throws ServletException {
        try {
            return this.createDeploymentConfiguration(DeploymentConfigurationFactory.createInitParameters(((Object)((Object)this)).getClass(), new VaadinServletConfig(this.getServletConfig())));
        }
        catch (VaadinConfigurationException e) {
            throw new ServletException("Failed to construct DeploymentConfiguration.", (Throwable)e);
        }
    }

    protected DeploymentConfiguration createDeploymentConfiguration(Properties initParameters) {
        return new DefaultDeploymentConfiguration(((Object)((Object)this)).getClass(), initParameters);
    }

    protected VaadinServletService createServletService() throws ServletException, ServiceException {
        return this.createServletService(this.createDeploymentConfiguration());
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        VaadinServletService service = new VaadinServletService(this, deploymentConfiguration);
        service.init();
        return service;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.handleContextOrServletRootWithoutSlash(request, response)) {
            return;
        }
        if (this.serveStaticOrWebJarRequest(request, response)) {
            return;
        }
        CurrentInstance.clearAll();
        VaadinServletRequest vaadinRequest = this.createVaadinRequest(request);
        VaadinServletResponse vaadinResponse = this.createVaadinResponse(response);
        if (!this.ensureCookiesEnabled(vaadinRequest, vaadinResponse)) {
            return;
        }
        try {
            this.getService().handleRequest(vaadinRequest, vaadinResponse);
        }
        catch (ServiceException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean serveStaticOrWebJarRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        DevModeHandler handler = DevModeHandler.getDevModeHandler();
        if (handler != null && handler.isDevModeRequest(request) && handler.serveDevModeRequest(request, response)) {
            return true;
        }
        if (this.staticFileHandler.isStaticResourceRequest(request)) {
            this.staticFileHandler.serveStaticResource(request, response);
            return true;
        }
        return this.webJarServer != null && this.webJarServer.tryServeWebJarResource(request, response);
    }

    protected boolean handleContextOrServletRootWithoutSlash(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String location = request.getRequestURI();
        String lastPathParameter = VaadinServlet.getLastPathParameter(location);
        location = location.substring(0, location.length() - lastPathParameter.length());
        if ((request.getPathInfo() == null || "/".equals(request.getPathInfo())) && !location.endsWith("/")) {
            location = location + "/" + lastPathParameter;
            String queryString = request.getQueryString();
            if (queryString != null) {
                queryString = queryString.replaceAll("[\\r\\n]", "");
                location = location + '?' + queryString;
            }
            response.sendRedirect(location);
            return true;
        }
        return false;
    }

    protected static String getLastPathParameter(String uri) {
        int lastPathStart = uri.lastIndexOf(47);
        if (lastPathStart == -1) {
            return "";
        }
        int semicolonPos = uri.indexOf(59, lastPathStart);
        if (semicolonPos < 0) {
            return "";
        }
        String semicolonString = uri.substring(semicolonPos);
        return semicolonString;
    }

    private VaadinServletResponse createVaadinResponse(HttpServletResponse response) {
        return new VaadinServletResponse(response, this.getService());
    }

    protected VaadinServletRequest createVaadinRequest(HttpServletRequest request) {
        return new VaadinServletRequest(request, this.getService());
    }

    public VaadinServletService getService() {
        return this.servletService;
    }

    private boolean ensureCookiesEnabled(VaadinServletRequest request, VaadinServletResponse response) throws IOException {
        if (HandlerHelper.isRequestType(request, HandlerHelper.RequestType.UIDL) && request.getRequestedSessionId() == null) {
            SystemMessages systemMessages = this.getService().getSystemMessages(HandlerHelper.findLocale(null, request), request);
            this.getService().writeUncachedStringResponse(response, "application/json; charset=UTF-8", VaadinService.createCriticalNotificationJSON(systemMessages.getCookiesDisabledCaption(), systemMessages.getCookiesDisabledMessage(), null, systemMessages.getCookiesDisabledURL()));
            return false;
        }
        return true;
    }

    @Deprecated
    protected URL getApplicationUrl(HttpServletRequest request) throws MalformedURLException {
        URL reqURL = new URL((request.isSecure() ? "https://" : "http://") + request.getServerName() + (request.isSecure() && request.getServerPort() == 443 || !request.isSecure() && request.getServerPort() == 80 ? "" : ":" + request.getServerPort()) + request.getRequestURI());
        String servletPath = request.getAttribute("javax.servlet.include.servlet_path") != null ? request.getAttribute("javax.servlet.include.context_path").toString() + request.getAttribute("javax.servlet.include.servlet_path") : request.getContextPath() + request.getServletPath();
        if (servletPath.length() == 0 || servletPath.charAt(servletPath.length() - 1) != '/') {
            servletPath = servletPath + "/";
        }
        URL u = new URL(reqURL, servletPath);
        return u;
    }

    public void destroy() {
        super.destroy();
        this.getService().destroy();
    }

    @Deprecated
    public static String safeEscapeForHtml(String unsafe) {
        char[] charArray;
        if (null == unsafe) {
            return null;
        }
        StringBuilder safe = new StringBuilder();
        for (char c : charArray = unsafe.toCharArray()) {
            if (VaadinServlet.isSafe(c)) {
                safe.append(c);
                continue;
            }
            safe.append("&#");
            safe.append((int)c);
            safe.append(";");
        }
        return safe.toString();
    }

    private static boolean isSafe(char c) {
        return c > '/' && c < ':' || c > '@' && c < '[' || c > '`' && c < '{';
    }

    protected Optional<WebJarServer> getWebJarServer() {
        return Optional.ofNullable(this.webJarServer);
    }
}

