/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.ReconnectDialogConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.LoadingIndicatorConfiguration;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.server.BootstrapUtils;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.WebBrowser;
import com.vaadin.flow.shared.ui.LoadMode;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

public class InitialPageSettings
implements Serializable {
    private final VaadinRequest request;
    private final UI ui;
    private final AfterNavigationEvent afterNavigationEvent;
    private final WebBrowser browser;
    private String viewport;
    private final Map<Position, List<JsonObject>> inline = new EnumMap<Position, List<JsonObject>>(Position.class);
    private final Map<Position, List<Element>> elements = new EnumMap<Position, List<Element>>(Position.class);

    public InitialPageSettings(VaadinRequest request, UI ui, AfterNavigationEvent afterNavigationEvent, WebBrowser browser) {
        this.request = request;
        this.ui = ui;
        this.afterNavigationEvent = afterNavigationEvent;
        this.browser = browser;
    }

    public VaadinRequest getRequest() {
        return this.request;
    }

    public UI getUi() {
        return this.ui;
    }

    public AfterNavigationEvent getAfterNavigationEvent() {
        return this.afterNavigationEvent;
    }

    public WebBrowser getBrowser() {
        return this.browser;
    }

    public void setViewport(String viewport) {
        this.viewport = viewport;
    }

    protected String getViewport() {
        return this.viewport;
    }

    public void addInlineFromFile(String file, WrapMode type) {
        this.addInlineFromFile(Position.APPEND, file, type);
    }

    public void addInlineFromFile(Position position, String file, WrapMode type) {
        JsonObject prepend = this.createInlineObject(type);
        prepend.put("contents", BootstrapUtils.getDependencyContents(this.request, file));
        this.getInline(position).add(prepend);
    }

    public void addInlineWithContents(String contents, WrapMode type) {
        this.addInlineWithContents(Position.APPEND, contents, type);
    }

    public void addInlineWithContents(Position position, String contents, WrapMode type) {
        JsonObject prepend = this.createInlineObject(type);
        prepend.put("contents", contents);
        this.getInline(position).add(prepend);
    }

    protected List<JsonObject> getInline(Position position) {
        return this.inline.computeIfAbsent(position, key -> new ArrayList());
    }

    protected List<Element> getElement(Position position) {
        return this.elements.computeIfAbsent(position, key -> new ArrayList());
    }

    public void addLink(String href) {
        this.addLink(Position.APPEND, href);
    }

    public void addLink(Position position, String href) {
        this.addLink(position, href, new HashMap<String, String>());
    }

    public void addLink(String href, Map<String, String> attributes) {
        this.addLink(Position.APPEND, href, attributes);
    }

    public void addLink(Position position, String href, Map<String, String> attributes) {
        Element link = new Element(Tag.valueOf((String)"link"), "").attr("href", href);
        attributes.forEach((key, value) -> link.attr(key, value));
        this.getElement(position).add(link);
    }

    public void addLink(String rel, String href) {
        this.addLink(Position.APPEND, rel, href);
    }

    public void addLink(Position position, String rel, String href) {
        Element link = new Element(Tag.valueOf((String)"link"), "").attr("href", href);
        link.attr("rel", rel);
        this.getElement(position).add(link);
    }

    public void addFavIcon(String rel, String href, String sizes) {
        this.addFavIcon(Position.APPEND, rel, href, sizes);
    }

    public void addFavIcon(Position position, String rel, String href, String sizes) {
        Element link = new Element(Tag.valueOf((String)"link"), "").attr("href", href);
        link.attr("rel", rel);
        link.attr("sizes", sizes);
        this.getElement(position).add(link);
    }

    public void addMetaTag(String name, String content) {
        this.addMetaTag(Position.APPEND, name, content);
    }

    public void addMetaTag(Position position, String name, String content) {
        Element meta = new Element(Tag.valueOf((String)"meta"), "").attr("name", name).attr("content", content);
        this.getElement(position).add(meta);
    }

    public LoadingIndicatorConfiguration getLoadingIndicatorConfiguration() {
        return this.getUi().getLoadingIndicatorConfiguration();
    }

    public ReconnectDialogConfiguration getReconnectDialogConfiguration() {
        return this.getUi().getReconnectDialogConfiguration();
    }

    public PushConfiguration getPushConfiguration() {
        return this.getUi().getPushConfiguration();
    }

    private JsonObject createInlineObject(WrapMode type) {
        JsonObject prepend = Json.createObject();
        prepend.put("type", type.toString());
        prepend.put("LoadMode", LoadMode.INLINE.toString());
        return prepend;
    }

    public static enum WrapMode {
        NONE,
        JAVASCRIPT,
        STYLESHEET;

    }

    public static enum Position {
        PREPEND,
        APPEND;

    }
}

