/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.server.VaadinSession;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DeadlockDetectingCompletableFuture<T>
extends CompletableFuture<T> {
    private final VaadinSession session;

    public DeadlockDetectingCompletableFuture(VaadinSession session) {
        this.session = session;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.throwIfDeadlock();
        return super.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.throwIfDeadlock();
        return super.get(timeout, unit);
    }

    @Override
    public T join() {
        this.throwIfDeadlock();
        return super.join();
    }

    private void throwIfDeadlock() {
        if (this.isDone()) {
            return;
        }
        if (this.session != null && this.session.hasLock()) {
            throw new IllegalStateException("Cannot do a blocking operation from the thread that has locked  the session is locked since the result cannot be made available while the session is locked.");
        }
    }
}

