/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationHandler;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.PreserveOnRefresh;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AfterNavigationHandler;
import com.vaadin.flow.router.internal.BeforeEnterHandler;
import com.vaadin.flow.router.internal.BeforeLeaveHandler;
import com.vaadin.flow.router.internal.Postpone;
import com.vaadin.flow.router.internal.RouteTarget;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public abstract class AbstractNavigationStateRenderer
implements NavigationHandler {
    private final NavigationState navigationState;
    private List<Class<? extends RouterLayout>> routeLayoutTypes;
    private Postpone postponed = null;
    private LocationChangeEvent locationChangeEvent = null;

    public AbstractNavigationStateRenderer(NavigationState navigationState) {
        this.navigationState = navigationState;
    }

    public NavigationState getNavigationState() {
        return this.navigationState;
    }

    static <T extends HasElement> T getRouteTarget(Class<T> routeTargetType, NavigationEvent event) {
        UI ui = event.getUI();
        Optional<HasElement> currentInstance = ui.getInternals().getActiveRouterTargetsChain().stream().filter(component -> component.getClass().equals(routeTargetType)).findAny();
        return (T)currentInstance.orElseGet(() -> Instantiator.get(ui).createRouteTarget(routeTargetType, event));
    }

    @Override
    public int handle(NavigationEvent event) {
        ArrayList<HasElement> chain;
        UI ui = event.getUI();
        Class<? extends Component> routeTargetType = this.navigationState.getNavigationTarget();
        RouteParameters parameters = this.navigationState.getRouteParameters();
        RouteTarget routeTarget = this.navigationState.getRouteTarget();
        List<Class<? extends RouterLayout>> list = this.routeLayoutTypes = routeTarget != null ? routeTarget.getParentLayouts() : this.getRouterLayoutTypes(routeTargetType, ui.getInternals().getRouter());
        assert (routeTargetType != null);
        assert (this.routeLayoutTypes != null);
        this.clearContinueNavigationAction(ui);
        AbstractNavigationStateRenderer.checkForDuplicates(routeTargetType, this.routeLayoutTypes);
        BeforeLeaveEvent beforeNavigationDeactivating = new BeforeLeaveEvent(event, routeTargetType, parameters, this.routeLayoutTypes);
        Optional<Integer> result = this.executeBeforeLeaveNavigation(event, beforeNavigationDeactivating);
        if (result.isPresent()) {
            return result.get();
        }
        boolean preserveOnRefreshTarget = AbstractNavigationStateRenderer.isPreserveOnRefreshTarget(routeTargetType, this.routeLayoutTypes);
        if (preserveOnRefreshTarget) {
            Optional<ArrayList<HasElement>> maybeChain = this.getPreservedChain(event);
            if (!maybeChain.isPresent()) {
                return HttpStatusCode.OK.getCode();
            }
            chain = maybeChain.get();
        } else {
            chain = new ArrayList();
            AbstractNavigationStateRenderer.clearAllPreservedChains(ui);
        }
        this.pushHistoryStateIfNeeded(event, ui);
        BeforeEnterEvent beforeNavigationActivating = new BeforeEnterEvent(event, routeTargetType, parameters, this.routeLayoutTypes);
        result = this.createChainIfEmptyAndExecuteBeforeEnterNavigation(beforeNavigationActivating, event, chain);
        if (result.isPresent()) {
            return result.get();
        }
        Component componentInstance = (Component)chain.get(0);
        if (preserveOnRefreshTarget) {
            this.setPreservedChain(chain, event);
            AbstractNavigationStateRenderer.warnAboutPreserveOnRefreshAndLiveReloadCombo(ui);
        }
        List<HasElement> routerLayouts = chain.subList(1, chain.size());
        ui.getInternals().showRouteTarget(event.getLocation(), componentInstance, routerLayouts);
        int statusCode = this.locationChangeEvent.getStatusCode();
        AbstractNavigationStateRenderer.validateStatusCode(statusCode, routeTargetType);
        ArrayList<AfterNavigationHandler> afterNavigationHandlers = new ArrayList<AfterNavigationHandler>(ui.getNavigationListeners(AfterNavigationHandler.class));
        afterNavigationHandlers.addAll(EventUtil.collectAfterNavigationObservers(ui));
        this.fireAfterNavigationListeners(new AfterNavigationEvent(this.locationChangeEvent), afterNavigationHandlers);
        AbstractNavigationStateRenderer.updatePageTitle(event, componentInstance);
        return statusCode;
    }

    private void pushHistoryStateIfNeeded(NavigationEvent event, UI ui) {
        if (event instanceof ErrorNavigationEvent) {
            ErrorNavigationEvent errorEvent = (ErrorNavigationEvent)event;
            if (this.isRouterLinkNotFoundNavigationError(errorEvent)) {
                event.getState().ifPresent(s -> ui.getPage().executeJs("this.scrollPositionHandlerAfterServerNavigation($0);", new Serializable[]{s}));
            }
        } else if (NavigationTrigger.ROUTER_LINK.equals((Object)event.getTrigger())) {
            JsonValue state = event.getState().orElseThrow(() -> new IllegalStateException("When the navigation trigger is ROUTER_LINK, event state should not be null."));
            ui.getPage().executeJs("this.scrollPositionHandlerAfterServerNavigation($0);", new Serializable[]{state});
        } else if (!(event.isForwardTo() || ui.getInternals().hasLastHandledLocation() && event.getLocation().getPathWithQueryParameters().equals(ui.getInternals().getLastHandledLocation().getPathWithQueryParameters()))) {
            if (this.shouldPushHistoryState(event)) {
                this.pushHistoryState(event);
            }
            ui.getInternals().setLastHandledNavigation(event.getLocation());
        }
    }

    protected void pushHistoryState(NavigationEvent event) {
        event.getUI().getPage().getHistory().pushState(null, event.getLocation());
    }

    protected boolean shouldPushHistoryState(NavigationEvent event) {
        return NavigationTrigger.UI_NAVIGATE.equals((Object)event.getTrigger());
    }

    private boolean isRouterLinkNotFoundNavigationError(ErrorNavigationEvent event) {
        return NavigationTrigger.ROUTER_LINK.equals((Object)event.getTrigger()) && event.getErrorParameter() != null && event.getErrorParameter().getCaughtException() instanceof NotFoundException;
    }

    protected abstract void notifyNavigationTarget(Component var1, NavigationEvent var2, BeforeEnterEvent var3, LocationChangeEvent var4);

    protected abstract List<Class<? extends RouterLayout>> getRouterLayoutTypes(Class<? extends Component> var1, Router var2);

    private List<Class<? extends HasElement>> getTypesChain() {
        Class<? extends Component> routeTargetType = this.navigationState.getNavigationTarget();
        ArrayList<Class<? extends RouterLayout>> layoutTypes = new ArrayList<Class<? extends RouterLayout>>(this.routeLayoutTypes);
        Collections.reverse(layoutTypes);
        ArrayList<Class<? extends HasElement>> chain = new ArrayList<Class<? extends HasElement>>();
        for (Class clazz : layoutTypes) {
            chain.add(clazz);
        }
        chain.add(routeTargetType);
        return chain;
    }

    private void clearContinueNavigationAction(UI ui) {
        this.storeContinueNavigationAction(ui, null);
    }

    private void storeContinueNavigationAction(UI ui, BeforeLeaveEvent.ContinueNavigationAction currentAction) {
        BeforeLeaveEvent.ContinueNavigationAction previousAction = ui.getInternals().getContinueNavigationAction();
        if (previousAction != null && previousAction != currentAction) {
            previousAction.setReferences(null, null);
        }
        ui.getInternals().setContinueNavigationAction(currentAction);
    }

    private void fireAfterNavigationListeners(AfterNavigationEvent event, List<AfterNavigationHandler> afterNavigationHandlers) {
        afterNavigationHandlers.forEach(listener -> listener.afterNavigation(event));
    }

    private Optional<Integer> executeBeforeLeaveNavigation(NavigationEvent event, BeforeLeaveEvent beforeNavigation) {
        Deque<BeforeLeaveHandler> leaveHandlers = this.getBeforeLeaveHandlers(beforeNavigation.getUI());
        while (!leaveHandlers.isEmpty()) {
            BeforeLeaveHandler listener = leaveHandlers.remove();
            listener.beforeLeave(beforeNavigation);
            AbstractNavigationStateRenderer.validateBeforeEvent(beforeNavigation);
            Optional<Integer> result = this.handleTriggeredBeforeEvent(event, beforeNavigation);
            if (result.isPresent()) {
                return result;
            }
            if (!beforeNavigation.isPostponed()) continue;
            this.postponed = Postpone.withLeaveObservers(leaveHandlers);
            BeforeLeaveEvent.ContinueNavigationAction currentAction = beforeNavigation.getContinueNavigationAction();
            currentAction.setReferences(this, event);
            this.storeContinueNavigationAction(event.getUI(), currentAction);
            return Optional.of(HttpStatusCode.OK.getCode());
        }
        return Optional.empty();
    }

    private Deque<BeforeLeaveHandler> getBeforeLeaveHandlers(UI ui) {
        Deque<BeforeLeaveHandler> leaveHandlers;
        if (this.postponed != null) {
            leaveHandlers = this.postponed.getLeaveObservers();
            if (!leaveHandlers.isEmpty()) {
                this.postponed = null;
            }
        } else {
            ArrayList<BeforeLeaveHandler> beforeLeaveHandlers = new ArrayList<BeforeLeaveHandler>(ui.getNavigationListeners(BeforeLeaveHandler.class));
            beforeLeaveHandlers.addAll(EventUtil.collectBeforeLeaveObservers(ui));
            leaveHandlers = new ArrayDeque<BeforeLeaveHandler>(beforeLeaveHandlers);
        }
        return leaveHandlers;
    }

    private Optional<Integer> createChainIfEmptyAndExecuteBeforeEnterNavigation(BeforeEnterEvent beforeNavigation, NavigationEvent event, List<HasElement> chain) {
        ArrayList<BeforeEnterHandler> registeredEnterHandlers = new ArrayList<BeforeEnterHandler>(beforeNavigation.getUI().getNavigationListeners(BeforeEnterHandler.class));
        Optional<Integer> result = this.sendBeforeEnterEvent(registeredEnterHandlers, event, beforeNavigation, null);
        if (result.isPresent()) {
            return result;
        }
        if (chain.isEmpty()) {
            return this.sendBeforeEnterEventAndPopulateChain(beforeNavigation, event, chain);
        }
        return this.sendBeforeEnterEventToExistingChain(beforeNavigation, event, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Integer> sendBeforeEnterEventAndPopulateChain(BeforeEnterEvent beforeNavigation, NavigationEvent event, List<HasElement> chain) {
        List<HasElement> oldChain = event.getUI().getInternals().getActiveRouterTargetsChain();
        List<Class<? extends HasElement>> typesChain = this.getTypesChain();
        try {
            for (Class<? extends HasElement> elementType : typesChain) {
                HasElement element = AbstractNavigationStateRenderer.getRouteTarget(elementType, event);
                chain.add(element);
                ArrayList<BeforeEnterHandler> chainEnterHandlers = new ArrayList<BeforeEnterHandler>(EventUtil.collectBeforeEnterObserversFromChainElement(element, oldChain));
                boolean lastElement = chain.size() == typesChain.size();
                Optional<Integer> result = this.sendBeforeEnterEvent(chainEnterHandlers, event, beforeNavigation, lastElement ? chain : null);
                if (!result.isPresent()) continue;
                Optional<Integer> optional = result;
                return optional;
            }
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            Collections.reverse(chain);
        }
    }

    private Optional<Integer> sendBeforeEnterEventToExistingChain(BeforeEnterEvent beforeNavigation, NavigationEvent event, List<HasElement> chain) {
        chain = new ArrayList<HasElement>(chain);
        Collections.reverse(chain);
        ArrayList<BeforeEnterHandler> chainEnterHandlers = new ArrayList<BeforeEnterHandler>(EventUtil.collectBeforeEnterObserversFromChain(chain, event.getUI().getInternals().getActiveRouterTargetsChain()));
        Optional<Integer> result = this.sendBeforeEnterEvent(chainEnterHandlers, event, beforeNavigation, chain);
        if (result.isPresent()) {
            return result;
        }
        return Optional.empty();
    }

    private Optional<Integer> sendBeforeEnterEvent(List<BeforeEnterHandler> eventHandlers, NavigationEvent event, BeforeEnterEvent beforeNavigation, List<HasElement> chain) {
        Optional<Integer> result;
        Component componentInstance = null;
        boolean notifyNavigationTarget = false;
        if (chain != null) {
            chain = new ArrayList<HasElement>(chain);
            Collections.reverse(chain);
            componentInstance = (Component)chain.get(0);
            this.locationChangeEvent = new LocationChangeEvent(event.getSource(), event.getUI(), event.getTrigger(), event.getLocation(), chain);
            notifyNavigationTarget = true;
        }
        for (BeforeEnterHandler eventHandler : eventHandlers) {
            Optional<Integer> result2;
            if (notifyNavigationTarget && AbstractNavigationStateRenderer.isComponentElementEqualsOrChild(eventHandler, componentInstance)) {
                result2 = this.notifyNavigationTarget(event, beforeNavigation, this.locationChangeEvent, componentInstance);
                if (result2.isPresent()) {
                    return result2;
                }
                notifyNavigationTarget = false;
            }
            if (!(result2 = this.sendBeforeEnterEvent(event, beforeNavigation, eventHandler)).isPresent()) continue;
            return result2;
        }
        if (notifyNavigationTarget && (result = this.notifyNavigationTarget(event, beforeNavigation, this.locationChangeEvent, componentInstance)).isPresent()) {
            return result;
        }
        return Optional.empty();
    }

    private Optional<Integer> sendBeforeEnterEvent(NavigationEvent event, BeforeEnterEvent beforeNavigation, BeforeEnterHandler eventHandler) {
        eventHandler.beforeEnter(beforeNavigation);
        AbstractNavigationStateRenderer.validateBeforeEvent(beforeNavigation);
        return this.handleTriggeredBeforeEvent(event, beforeNavigation);
    }

    private Optional<Integer> notifyNavigationTarget(NavigationEvent event, BeforeEnterEvent beforeNavigation, LocationChangeEvent locationChangeEvent, Component componentInstance) {
        this.notifyNavigationTarget(componentInstance, event, beforeNavigation, locationChangeEvent);
        return this.handleTriggeredBeforeEvent(event, beforeNavigation);
    }

    private static boolean isComponentElementEqualsOrChild(BeforeEnterHandler eventHandler, Component component) {
        if (eventHandler instanceof HasElement) {
            HasElement hasElement = (HasElement)((Object)eventHandler);
            Element componentElement = component.getElement();
            for (Element element = hasElement.getElement(); element != null; element = element.getParent()) {
                if (!element.equals(componentElement)) continue;
                return true;
            }
        }
        return false;
    }

    protected Optional<Integer> handleTriggeredBeforeEvent(NavigationEvent event, BeforeEvent beforeEvent) {
        if (beforeEvent.hasExternalForwardUrl()) {
            return Optional.of(this.forwardToExternalUrl(event, beforeEvent));
        }
        if (beforeEvent.hasForwardTarget() && !this.isSameNavigationState(beforeEvent.getForwardTargetType(), beforeEvent.getForwardTargetRouteParameters())) {
            return Optional.of(this.forward(event, beforeEvent));
        }
        if (beforeEvent.hasRerouteTarget() && !this.isSameNavigationState(beforeEvent.getRerouteTargetType(), beforeEvent.getRerouteTargetRouteParameters())) {
            return Optional.of(this.reroute(event, beforeEvent));
        }
        return Optional.empty();
    }

    private boolean isSameNavigationState(Class<? extends Component> targetType, RouteParameters targetParameters) {
        boolean sameTarget = this.navigationState.getNavigationTarget().equals(targetType);
        boolean sameParameters = targetParameters.equals(this.navigationState.getRouteParameters());
        return sameTarget && sameParameters;
    }

    private int forwardToExternalUrl(NavigationEvent event, BeforeEvent beforeNavigation) {
        event.getUI().getPage().setLocation(beforeNavigation.getExternalForwardUrl());
        return HttpStatusCode.OK.getCode();
    }

    private int forward(NavigationEvent event, BeforeEvent beforeNavigation) {
        NavigationHandler handler = beforeNavigation.getForwardTarget();
        NavigationEvent newNavigationEvent = this.getNavigationEvent(event, beforeNavigation);
        newNavigationEvent.getUI().getPage().getHistory().replaceState(null, newNavigationEvent.getLocation());
        return handler.handle(newNavigationEvent);
    }

    private int reroute(NavigationEvent event, BeforeEvent beforeNavigation) {
        NavigationHandler handler = beforeNavigation.getRerouteTarget();
        NavigationEvent newNavigationEvent = this.getNavigationEvent(event, beforeNavigation);
        return handler.handle(newNavigationEvent);
    }

    private NavigationEvent getNavigationEvent(NavigationEvent event, BeforeEvent beforeNavigation) {
        if (beforeNavigation.hasErrorParameter()) {
            ErrorParameter<?> errorParameter = beforeNavigation.getErrorParameter();
            return new ErrorNavigationEvent(event.getSource(), event.getLocation(), event.getUI(), NavigationTrigger.PROGRAMMATIC, errorParameter);
        }
        boolean isForward = beforeNavigation.hasForwardTarget();
        String url = isForward ? beforeNavigation.getForwardUrl() : beforeNavigation.getRerouteUrl();
        if (url == null) {
            RouteParameters redirectParameters;
            Class<? extends Component> redirectTarget;
            String redirectType;
            if (isForward) {
                redirectType = "forward";
                redirectTarget = beforeNavigation.getForwardTargetType();
                redirectParameters = beforeNavigation.getForwardTargetRouteParameters();
            } else {
                redirectType = "reroute";
                redirectTarget = beforeNavigation.getRerouteTargetType();
                redirectParameters = beforeNavigation.getRerouteTargetRouteParameters();
            }
            throw new IllegalStateException(String.format("Attempting to %s to unresolved location target %s with route parameters %s", redirectType, redirectTarget, redirectParameters));
        }
        Location location = new Location(url, event.getLocation().getQueryParameters());
        return new NavigationEvent(event.getSource(), location, event.getUI(), NavigationTrigger.PROGRAMMATIC, null, true);
    }

    private Optional<ArrayList<HasElement>> getPreservedChain(NavigationEvent event) {
        Location location = event.getLocation();
        UI ui = event.getUI();
        VaadinSession session = ui.getSession();
        if (ui.getInternals().getExtendedClientDetails() == null) {
            if (AbstractNavigationStateRenderer.hasPreservedChainOfLocation(session, location)) {
                ui.getPage().retrieveExtendedClientDetails(details -> this.handle(event));
                return Optional.empty();
            }
        } else {
            String windowName = ui.getInternals().getExtendedClientDetails().getWindowName();
            Optional<ArrayList<HasElement>> maybePreserved = AbstractNavigationStateRenderer.getPreservedChain(session, windowName, event.getLocation());
            if (maybePreserved.isPresent()) {
                ArrayList<HasElement> chain = maybePreserved.get();
                HasElement root = chain.get(chain.size() - 1);
                Component component = (Component)chain.get(0);
                Optional<UI> maybePrevUI = component.getUI();
                if (maybePrevUI.isPresent() && maybePrevUI.get().equals(ui)) {
                    return Optional.of(chain);
                }
                root.getElement().removeFromTree();
                maybePrevUI.ifPresent(prevUi -> {
                    ui.getInternals().moveElementsFrom((UI)prevUi);
                    prevUi.close();
                });
                return Optional.of(chain);
            }
        }
        return Optional.of(new ArrayList(0));
    }

    private void setPreservedChain(ArrayList<HasElement> chain, NavigationEvent event) {
        Location location = event.getLocation();
        UI ui = event.getUI();
        VaadinSession session = ui.getSession();
        ExtendedClientDetails extendedClientDetails = ui.getInternals().getExtendedClientDetails();
        if (extendedClientDetails == null) {
            ui.getPage().retrieveExtendedClientDetails(details -> AbstractNavigationStateRenderer.setPreservedChain(session, details.getWindowName(), location, chain));
        } else {
            String windowName = extendedClientDetails.getWindowName();
            AbstractNavigationStateRenderer.setPreservedChain(session, windowName, location, chain);
        }
    }

    private static void validateStatusCode(int statusCode, Class<? extends Component> targetClass) {
        if (!HttpStatusCode.isValidStatusCode(statusCode)) {
            String msg = String.format("Error state code must be a valid HttpStatusCode value. Received invalid value of '%s' for '%s'", statusCode, targetClass.getName());
            throw new IllegalStateException(msg);
        }
    }

    private static void validateBeforeEvent(BeforeEvent event) {
        if (event.hasForwardTarget() && event.hasRerouteTarget()) {
            throw new IllegalStateException("Error forward & reroute can not be set at the same time");
        }
    }

    private static void checkForDuplicates(Class<? extends Component> routeTargetType, Collection<Class<? extends RouterLayout>> routeLayoutTypes) {
        HashSet<Class<HasElement>> duplicateCheck = new HashSet<Class<HasElement>>();
        duplicateCheck.add(routeTargetType);
        for (Class<? extends RouterLayout> parentType : routeLayoutTypes) {
            if (duplicateCheck.add(parentType)) continue;
            throw new IllegalArgumentException(parentType + " is used in multiple locations");
        }
    }

    private static void updatePageTitle(NavigationEvent navigationEvent, Component routeTarget) {
        String title = routeTarget instanceof HasDynamicTitle ? ((HasDynamicTitle)((Object)routeTarget)).getPageTitle() : AbstractNavigationStateRenderer.lookForTitleInTarget(routeTarget).map(PageTitle::value).orElse("");
        navigationEvent.getUI().getPage().setTitle(title);
    }

    private static Optional<PageTitle> lookForTitleInTarget(Component routeTarget) {
        return Optional.ofNullable(routeTarget.getClass().getAnnotation(PageTitle.class));
    }

    private static boolean isPreserveOnRefreshTarget(Class<? extends Component> routeTargetType, List<Class<? extends RouterLayout>> routeLayoutTypes) {
        return routeTargetType.isAnnotationPresent(PreserveOnRefresh.class) || routeLayoutTypes.stream().anyMatch(layoutType -> layoutType.isAnnotationPresent(PreserveOnRefresh.class));
    }

    static boolean hasPreservedChain(VaadinSession session) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        return cache != null && !cache.isEmpty();
    }

    static boolean hasPreservedChainOfLocation(VaadinSession session, Location location) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        return cache != null && cache.values().stream().anyMatch(entry -> ((String)entry.getFirst()).equals(location.getPath()));
    }

    static Optional<ArrayList<HasElement>> getPreservedChain(VaadinSession session, String windowName, Location location) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        if (cache != null && cache.containsKey(windowName) && ((String)((Pair)cache.get(windowName)).getFirst()).equals(location.getPath())) {
            return Optional.of((ArrayList)((Pair)cache.get(windowName)).getSecond());
        }
        return Optional.empty();
    }

    static void setPreservedChain(VaadinSession session, String windowName, Location location, ArrayList<HasElement> chain) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        if (cache == null) {
            cache = new PreservedComponentCache();
        }
        cache.put(windowName, new Pair<String, ArrayList<HasElement>>(location.getPath(), chain));
        session.setAttribute(PreservedComponentCache.class, cache);
    }

    private static void clearAllPreservedChains(UI ui) {
        VaadinSession session = ui.getSession();
        if (AbstractNavigationStateRenderer.hasPreservedChain(session)) {
            ui.getPage().retrieveExtendedClientDetails(details -> {
                String windowName = ui.getInternals().getExtendedClientDetails().getWindowName();
                PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
                if (cache != null) {
                    cache.remove(windowName);
                }
            });
        }
    }

    private static void warnAboutPreserveOnRefreshAndLiveReloadCombo(UI ui) {
        DeploymentConfiguration configuration = ui.getSession().getConfiguration();
        if (!configuration.isProductionMode() && configuration.isDevModeLiveReloadEnabled()) {
            ui.getPage().executeJs("Vaadin.devTools.showNotification('warning', '@PreserveOnRefresh enabled', 'When refreshing the page in the browser, the server-side Java view instance is reused rather than being recreated.', null, 'preserveOnRefreshWarning')", new Serializable[0]);
        }
    }

    private static class PreservedComponentCache
    extends HashMap<String, Pair<String, ArrayList<HasElement>>> {
        private PreservedComponentCache() {
        }
    }
}

