/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.connect.generator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ClassLoaderTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.github.javaparser.utils.SourceRoot;
import com.vaadin.flow.server.connect.Endpoint;
import com.vaadin.flow.server.connect.EndpointNameChecker;
import com.vaadin.flow.server.connect.auth.AnonymousAllowed;
import com.vaadin.flow.server.connect.generator.GeneratorUtils;
import com.vaadin.flow.server.connect.generator.OpenApiConfiguration;
import com.vaadin.flow.server.connect.generator.SchemaResolver;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiObjectGenerator {
    public static final String EXTENSION_VAADIN_CONNECT_PARAMETERS_DESCRIPTION = "x-vaadin-parameters-description";
    public static final String EXTENSION_VAADIN_FILE_PATH = "x-vaadin-file-path";
    private static final String VAADIN_CONNECT_OAUTH2_SECURITY_SCHEME = "vaadin-connect-oauth2";
    private static final String VAADIN_CONNECT_OAUTH2_TOKEN_URL = "/oauth/token";
    private List<Path> javaSourcePaths = new ArrayList<Path>();
    private OpenApiConfiguration configuration;
    private Map<String, ResolvedReferenceType> usedTypes;
    private Map<ClassOrInterfaceDeclaration, String> endpointsJavadoc;
    private Map<String, ClassOrInterfaceDeclaration> nonEndpointMap;
    private Map<String, String> qualifiedNameToPath;
    private Map<String, PathItem> pathItems;
    private Set<String> generatedSchema;
    private OpenAPI openApiModel;
    private final EndpointNameChecker endpointNameChecker = new EndpointNameChecker();
    private ClassLoader typeResolverClassLoader;
    private SchemaResolver schemaResolver;

    public void addSourcePath(Path sourcePath) {
        if (sourcePath == null) {
            throw new IllegalArgumentException("Java source path must be a valid directory");
        }
        if (!sourcePath.toFile().exists()) {
            throw new IllegalArgumentException(String.format("Java source path '%s' doesn't exist", sourcePath));
        }
        this.javaSourcePaths.add(sourcePath);
    }

    void setTypeResolverClassLoader(ClassLoader typeResolverClassLoader) {
        this.typeResolverClassLoader = typeResolverClassLoader;
    }

    public void setOpenApiConfiguration(OpenApiConfiguration configuration) {
        this.configuration = configuration;
    }

    public OpenAPI getOpenApi() {
        if (this.openApiModel == null) {
            this.init();
        }
        return this.openApiModel;
    }

    OpenAPI generateOpenApi() {
        this.init();
        return this.openApiModel;
    }

    private void init() {
        if (this.javaSourcePaths == null || this.configuration == null) {
            throw new IllegalStateException("Java source path and configuration should not be null");
        }
        this.openApiModel = this.createBasicModel();
        this.nonEndpointMap = new HashMap<String, ClassOrInterfaceDeclaration>();
        this.qualifiedNameToPath = new HashMap<String, String>();
        this.pathItems = new TreeMap<String, PathItem>();
        this.usedTypes = new HashMap<String, ResolvedReferenceType>();
        this.generatedSchema = new HashSet<String>();
        this.endpointsJavadoc = new HashMap<ClassOrInterfaceDeclaration, String>();
        this.schemaResolver = new SchemaResolver();
        ParserConfiguration parserConfiguration = this.createParserConfiguration();
        this.javaSourcePaths.stream().map(path -> new SourceRoot(path, parserConfiguration)).forEach(this::parseSourceRoot);
        for (Map.Entry<String, ResolvedReferenceType> entry : this.usedTypes.entrySet()) {
            List<Schema> schemas = this.createSchemasFromQualifiedNameAndType(entry.getKey(), entry.getValue());
            schemas.forEach(schema -> {
                if (this.qualifiedNameToPath.get(schema.getName()) != null) {
                    schema.addExtension(EXTENSION_VAADIN_FILE_PATH, (Object)this.qualifiedNameToPath.get(schema.getName()));
                }
                this.openApiModel.getComponents().addSchemas(schema.getName(), schema);
            });
        }
        this.addTagsInformation();
    }

    private ParserConfiguration createParserConfiguration() {
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[]{new ReflectionTypeSolver(false)});
        if (this.typeResolverClassLoader != null) {
            combinedTypeSolver.add((TypeSolver)new ClassLoaderTypeSolver(this.typeResolverClassLoader));
        }
        return new ParserConfiguration().setSymbolResolver((SymbolResolver)new JavaSymbolSolver((TypeSolver)combinedTypeSolver));
    }

    private void parseSourceRoot(SourceRoot sourceRoot) {
        try {
            sourceRoot.parse("", this::process);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't parse the java files in the source root '%s'", sourceRoot), e);
        }
    }

    private void addTagsInformation() {
        for (Map.Entry<ClassOrInterfaceDeclaration, String> endpointJavadoc : this.endpointsJavadoc.entrySet()) {
            Tag tag = new Tag();
            ClassOrInterfaceDeclaration endpointDeclaration = endpointJavadoc.getKey();
            String simpleClassName = endpointDeclaration.getNameAsString();
            tag.name(simpleClassName);
            tag.description(endpointJavadoc.getValue());
            tag.addExtension(EXTENSION_VAADIN_FILE_PATH, (Object)this.qualifiedNameToPath.get(endpointDeclaration.getFullyQualifiedName().orElse(simpleClassName)));
            this.openApiModel.addTagsItem(tag);
        }
    }

    private OpenAPI createBasicModel() {
        OpenAPI openAPI = new OpenAPI();
        Info info = new Info();
        info.setTitle(this.configuration.getApplicationTitle());
        info.setVersion(this.configuration.getApplicationApiVersion());
        openAPI.setInfo(info);
        Paths paths = new Paths();
        openAPI.setPaths(paths);
        Server server = new Server();
        server.setUrl(this.configuration.getServerUrl());
        server.setDescription(this.configuration.getServerDescription());
        openAPI.setServers(Collections.singletonList(server));
        Components components = new Components();
        SecurityScheme vaadinConnectOAuth2Scheme = new SecurityScheme().type(SecurityScheme.Type.OAUTH2).flows(new OAuthFlows().password(new OAuthFlow().tokenUrl(VAADIN_CONNECT_OAUTH2_TOKEN_URL).scopes(new Scopes())));
        components.addSecuritySchemes(VAADIN_CONNECT_OAUTH2_SECURITY_SCHEME, vaadinConnectOAuth2Scheme);
        openAPI.components(components);
        return openAPI;
    }

    private SourceRoot.Callback.Result process(Path localPath, Path absolutePath, ParseResult<CompilationUnit> result) {
        result.ifSuccessful(compilationUnit -> ((Collection)compilationUnit.getPrimaryType().filter(BodyDeclaration::isClassOrInterfaceDeclaration).map(BodyDeclaration::asClassOrInterfaceDeclaration).filter(classOrInterfaceDeclaration -> !classOrInterfaceDeclaration.isInterface()).map(this::appendNestedClasses).orElse(Collections.emptyList())).forEach(classOrInterfaceDeclaration -> this.parseClass((ClassOrInterfaceDeclaration)classOrInterfaceDeclaration, (CompilationUnit)compilationUnit)));
        this.pathItems.forEach((pathName, pathItem) -> this.openApiModel.getPaths().addPathItem(pathName, pathItem));
        return SourceRoot.Callback.Result.DONT_SAVE;
    }

    private Collection<ClassOrInterfaceDeclaration> appendNestedClasses(ClassOrInterfaceDeclaration topLevelClass) {
        Set nestedClasses = topLevelClass.getMembers().stream().filter(BodyDeclaration::isClassOrInterfaceDeclaration).map(BodyDeclaration::asClassOrInterfaceDeclaration).collect(Collectors.toCollection(() -> new TreeSet<ClassOrInterfaceDeclaration>(Comparator.comparing(NodeWithSimpleName::getNameAsString))));
        nestedClasses.add(topLevelClass);
        return nestedClasses;
    }

    private void parseClass(ClassOrInterfaceDeclaration classDeclaration, CompilationUnit compilationUnit) {
        Optional endpointAnnotation = classDeclaration.getAnnotationByClass(Endpoint.class);
        compilationUnit.getStorage().ifPresent(storage -> {
            String className = classDeclaration.getFullyQualifiedName().orElse(classDeclaration.getNameAsString());
            this.qualifiedNameToPath.put(className, storage.getPath().toString());
        });
        if (!endpointAnnotation.isPresent()) {
            this.nonEndpointMap.put(classDeclaration.resolve().getQualifiedName(), classDeclaration);
        } else {
            Optional javadoc = classDeclaration.getJavadoc();
            if (javadoc.isPresent()) {
                this.endpointsJavadoc.put(classDeclaration, ((Javadoc)javadoc.get()).getDescription().toText());
            } else {
                this.endpointsJavadoc.put(classDeclaration, "");
            }
            this.pathItems.putAll(this.createPathItems(this.getEndpointName(classDeclaration, (AnnotationExpr)endpointAnnotation.get()), classDeclaration));
        }
    }

    private String getEndpointName(ClassOrInterfaceDeclaration classDeclaration, AnnotationExpr endpointAnnotation) {
        String endpointName = Optional.ofNullable(endpointAnnotation).filter(Expression::isSingleMemberAnnotationExpr).map(Expression::asSingleMemberAnnotationExpr).map(SingleMemberAnnotationExpr::getMemberValue).map(Expression::asStringLiteralExpr).map(LiteralStringValueExpr::getValue).filter(GeneratorUtils::isNotBlank).orElse(classDeclaration.getNameAsString());
        String validationError = this.endpointNameChecker.check(endpointName);
        if (validationError != null) {
            throw new IllegalStateException(String.format("Endpoint name '%s' is invalid, reason: '%s'", endpointName, validationError));
        }
        return endpointName;
    }

    private List<Schema> parseNonEndpointClassAsSchema(String fullQualifiedName) {
        ClassOrInterfaceDeclaration typeDeclaration = this.nonEndpointMap.get(fullQualifiedName);
        if (typeDeclaration == null) {
            return Collections.emptyList();
        }
        ArrayList<Schema> result = new ArrayList<Schema>();
        Schema schema = this.createSingleSchema(fullQualifiedName, typeDeclaration);
        this.generatedSchema.add(fullQualifiedName);
        NodeList extendedTypes = typeDeclaration.getExtendedTypes();
        if (extendedTypes.isEmpty()) {
            result.add(schema);
            result.addAll(this.generatedRelatedSchemas(schema));
        } else {
            ComposedSchema parentSchema = new ComposedSchema();
            parentSchema.setName(fullQualifiedName);
            result.add((Schema)parentSchema);
            extendedTypes.forEach(parentType -> {
                ResolvedReferenceType resolvedParentType = parentType.resolve();
                String parentQualifiedName = resolvedParentType.getQualifiedName();
                String parentRef = this.schemaResolver.getFullQualifiedNameRef(parentQualifiedName);
                parentSchema.addAllOfItem(new ObjectSchema().$ref(parentRef));
                this.schemaResolver.addFoundTypes(parentQualifiedName, resolvedParentType);
            });
            parentSchema.addAllOfItem(schema);
            result.addAll(this.generatedRelatedSchemas((Schema)parentSchema));
        }
        return result;
    }

    private Schema createSingleSchema(String fullQualifiedName, ClassOrInterfaceDeclaration typeDeclaration) {
        Optional<String> description = typeDeclaration.getJavadoc().map(javadoc -> javadoc.getDescription().toText());
        ObjectSchema schema = new ObjectSchema();
        schema.setName(fullQualifiedName);
        description.ifPresent(arg_0 -> ((Schema)schema).setDescription(arg_0));
        Map<String, Schema> properties = this.getPropertiesFromClassDeclaration((TypeDeclaration<ClassOrInterfaceDeclaration>)typeDeclaration);
        schema.properties(properties);
        List requiredList = properties.entrySet().stream().filter(stringSchemaEntry -> GeneratorUtils.isNotTrue(((Schema)stringSchemaEntry.getValue()).getNullable())).map(Map.Entry::getKey).collect(Collectors.toList());
        properties.values().forEach(propertySchema -> propertySchema.nullable(null));
        schema.setRequired(requiredList);
        return schema;
    }

    private List<Schema> createSchemasFromQualifiedNameAndType(String qualifiedName, ResolvedReferenceType resolvedReferenceType) {
        List<Schema> list = this.parseNonEndpointClassAsSchema(qualifiedName);
        if (list.isEmpty()) {
            return this.parseReferencedTypeAsSchema(resolvedReferenceType);
        }
        return list;
    }

    private Map<String, Schema> getPropertiesFromClassDeclaration(TypeDeclaration<ClassOrInterfaceDeclaration> typeDeclaration) {
        TreeMap<String, Schema> properties = new TreeMap<String, Schema>();
        for (FieldDeclaration field : typeDeclaration.getFields()) {
            if (field.isTransient() || field.isStatic() || field.isAnnotationPresent(JsonIgnore.class)) continue;
            Optional<String> fieldDescription = field.getJavadoc().map(javadoc -> javadoc.getDescription().toText());
            field.getVariables().forEach(variableDeclarator -> {
                Schema propertySchema = this.parseTypeToSchema(variableDeclarator.getType(), fieldDescription.orElse(""));
                if (field.isAnnotationPresent(Nullable.class) || GeneratorUtils.isTrue(propertySchema.getNullable())) {
                    propertySchema.setNullable(Boolean.valueOf(true));
                }
                properties.put(variableDeclarator.getNameAsString(), propertySchema);
            });
        }
        return properties;
    }

    private Map<String, ResolvedReferenceType> collectUsedTypesFromSchema(Schema schema) {
        HashMap<String, ResolvedReferenceType> map = new HashMap<String, ResolvedReferenceType>();
        if (GeneratorUtils.isNotBlank(schema.getName()) || GeneratorUtils.isNotBlank(schema.get$ref())) {
            String name = GeneratorUtils.firstNonBlank(schema.getName(), this.schemaResolver.getSimpleRef(schema.get$ref()));
            ResolvedReferenceType resolvedReferenceType = this.schemaResolver.getFoundTypeByQualifiedName(name);
            if (resolvedReferenceType != null) {
                map.put(name, resolvedReferenceType);
            } else {
                OpenApiObjectGenerator.getLogger().info("Can't find the type information of class '{}'. This might result in a missing schema in the generated OpenAPI spec.", (Object)name);
            }
        }
        if (schema instanceof ArraySchema) {
            map.putAll(this.collectUsedTypesFromSchema(((ArraySchema)schema).getItems()));
        } else if (schema instanceof MapSchema && schema.getAdditionalProperties() != null) {
            map.putAll(this.collectUsedTypesFromSchema((Schema)schema.getAdditionalProperties()));
        } else if (schema instanceof ComposedSchema && ((ComposedSchema)schema).getAllOf() != null) {
            for (Schema child : ((ComposedSchema)schema).getAllOf()) {
                map.putAll(this.collectUsedTypesFromSchema(child));
            }
        }
        if (schema.getProperties() != null) {
            schema.getProperties().values().forEach(o -> map.putAll(this.collectUsedTypesFromSchema((Schema)o)));
        }
        return map;
    }

    private boolean isReservedWord(String word) {
        return word != null && EndpointNameChecker.ECMA_SCRIPT_RESERVED_WORDS.contains(word.toLowerCase());
    }

    private Map<String, PathItem> createPathItems(String endpointName, ClassOrInterfaceDeclaration typeDeclaration) {
        HashMap<String, PathItem> newPathItems = new HashMap<String, PathItem>();
        for (MethodDeclaration methodDeclaration : typeDeclaration.getMethods()) {
            if (this.isAccessForbidden(typeDeclaration, methodDeclaration)) continue;
            String methodName = methodDeclaration.getNameAsString();
            Operation post = this.createPostOperation(methodDeclaration);
            if (methodDeclaration.getParameters().isNonEmpty()) {
                post.setRequestBody(this.createRequestBody(methodDeclaration));
            }
            ApiResponses responses = this.createApiResponses(methodDeclaration);
            post.setResponses(responses);
            post.tags(Collections.singletonList(typeDeclaration.getNameAsString()));
            PathItem pathItem = new PathItem().post(post);
            String pathName = "/" + endpointName + "/" + methodName;
            pathItem.readOperationsMap().forEach((httpMethod, operation) -> operation.setOperationId(String.join((CharSequence)"_", endpointName, methodName, httpMethod.name())));
            newPathItems.put(pathName, pathItem);
        }
        return newPathItems;
    }

    private boolean isAccessForbidden(ClassOrInterfaceDeclaration typeDeclaration, MethodDeclaration methodDeclaration) {
        return !methodDeclaration.isPublic() || (this.hasSecurityAnnotation(methodDeclaration) ? methodDeclaration.isAnnotationPresent(DenyAll.class) : typeDeclaration.isAnnotationPresent(DenyAll.class));
    }

    private boolean hasSecurityAnnotation(MethodDeclaration method) {
        return method.isAnnotationPresent(AnonymousAllowed.class) || method.isAnnotationPresent(PermitAll.class) || method.isAnnotationPresent(DenyAll.class) || method.isAnnotationPresent(RolesAllowed.class);
    }

    private Operation createPostOperation(MethodDeclaration methodDeclaration) {
        Operation post = new Operation();
        SecurityRequirement securityItem = new SecurityRequirement();
        securityItem.addList(VAADIN_CONNECT_OAUTH2_SECURITY_SCHEME);
        post.addSecurityItem(securityItem);
        methodDeclaration.getJavadoc().ifPresent(javadoc -> post.setDescription(javadoc.getDescription().toText()));
        return post;
    }

    private ApiResponses createApiResponses(MethodDeclaration methodDeclaration) {
        ApiResponse successfulResponse = this.createApiSuccessfulResponse(methodDeclaration);
        ApiResponses responses = new ApiResponses();
        responses.addApiResponse("200", successfulResponse);
        return responses;
    }

    private ApiResponse createApiSuccessfulResponse(MethodDeclaration methodDeclaration) {
        Content successfulContent = new Content();
        ApiResponse successfulResponse = new ApiResponse().description("");
        methodDeclaration.getJavadoc().ifPresent(javadoc -> {
            for (JavadocBlockTag blockTag : javadoc.getBlockTags()) {
                if (blockTag.getType() != JavadocBlockTag.Type.RETURN) continue;
                successfulResponse.setDescription("Return " + blockTag.getContent().toText());
            }
        });
        if (!methodDeclaration.getType().isVoidType()) {
            MediaType mediaItem = this.createReturnMediaType(methodDeclaration);
            successfulContent.addMediaType("application/json", mediaItem);
            successfulResponse.content(successfulContent);
        }
        return successfulResponse;
    }

    private MediaType createReturnMediaType(MethodDeclaration methodDeclaration) {
        MediaType mediaItem = new MediaType();
        Type methodReturnType = methodDeclaration.getType();
        Schema schema = this.parseTypeToSchema(methodReturnType, "");
        if (methodDeclaration.isAnnotationPresent(Nullable.class)) {
            schema = this.schemaResolver.createNullableWrapper(schema);
        }
        this.usedTypes.putAll(this.collectUsedTypesFromSchema(schema));
        mediaItem.schema(schema);
        return mediaItem;
    }

    private RequestBody createRequestBody(MethodDeclaration methodDeclaration) {
        HashMap paramsDescription = new HashMap();
        methodDeclaration.getJavadoc().ifPresent(javadoc -> {
            for (JavadocBlockTag blockTag : javadoc.getBlockTags()) {
                if (blockTag.getType() != JavadocBlockTag.Type.PARAM) continue;
                paramsDescription.put(blockTag.getName().orElse(""), blockTag.getContent().toText());
            }
        });
        RequestBody requestBody = new RequestBody();
        Content requestBodyContent = new Content();
        requestBody.content(requestBodyContent);
        MediaType requestBodyObject = new MediaType();
        requestBodyContent.addMediaType("application/json", requestBodyObject);
        ObjectSchema requestSchema = new ObjectSchema();
        requestSchema.setRequired(new ArrayList());
        requestBodyObject.schema((Schema)requestSchema);
        methodDeclaration.getParameters().forEach(arg_0 -> this.lambda$createRequestBody$19(paramsDescription, (Schema)requestSchema, arg_0));
        if (!paramsDescription.isEmpty()) {
            requestSchema.addExtension(EXTENSION_VAADIN_CONNECT_PARAMETERS_DESCRIPTION, new LinkedHashMap(paramsDescription));
        }
        return requestBody;
    }

    private Schema parseTypeToSchema(Type javaType, String description) {
        try {
            Schema schema = this.parseResolvedTypeToSchema(javaType.resolve());
            if (GeneratorUtils.isNotBlank(description)) {
                schema.setDescription(description);
            }
            return schema;
        }
        catch (Exception e) {
            OpenApiObjectGenerator.getLogger().info(String.format("Can't resolve type '%s' for creating custom OpenAPI Schema. Using the default ObjectSchema instead.", javaType.asString()), (Throwable)e);
            return new ObjectSchema();
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(OpenApiObjectGenerator.class);
    }

    private Schema parseResolvedTypeToSchema(ResolvedType resolvedType) {
        return this.schemaResolver.parseResolvedTypeToSchema(resolvedType);
    }

    private List<Schema> parseReferencedTypeAsSchema(ResolvedReferenceType resolvedType) {
        ArrayList<Schema> results = new ArrayList<Schema>();
        Schema schema = this.createSingleSchemaFromResolvedType(resolvedType);
        String qualifiedName = resolvedType.getQualifiedName();
        this.generatedSchema.add(qualifiedName);
        List directAncestors = resolvedType.getDirectAncestors().stream().filter(parent -> parent.getTypeDeclaration().isClass() && !Object.class.getName().equals(parent.getQualifiedName())).collect(Collectors.toList());
        if (directAncestors.isEmpty()) {
            results.add(schema);
            results.addAll(this.generatedRelatedSchemas(schema));
        } else {
            ComposedSchema parentSchema = new ComposedSchema();
            parentSchema.name(qualifiedName);
            results.add((Schema)parentSchema);
            for (ResolvedReferenceType directAncestor : directAncestors) {
                String ancestorQualifiedName = directAncestor.getQualifiedName();
                String parentRef = this.schemaResolver.getFullQualifiedNameRef(ancestorQualifiedName);
                parentSchema.addAllOfItem(new ObjectSchema().$ref(parentRef));
                this.schemaResolver.addFoundTypes(ancestorQualifiedName, directAncestor);
            }
            parentSchema.addAllOfItem(schema);
            results.addAll(this.generatedRelatedSchemas((Schema)parentSchema));
        }
        return results;
    }

    private List<Schema> generatedRelatedSchemas(Schema schema) {
        ArrayList<Schema> result = new ArrayList<Schema>();
        this.collectUsedTypesFromSchema(schema).entrySet().stream().filter(s -> !this.generatedSchema.contains(s.getKey())).forEach(s -> result.addAll(this.createSchemasFromQualifiedNameAndType((String)s.getKey(), (ResolvedReferenceType)s.getValue())));
        return result;
    }

    private Schema createSingleSchemaFromResolvedType(ResolvedReferenceType resolvedType) {
        Schema schema = new ObjectSchema().name(resolvedType.getQualifiedName());
        Map<String, Boolean> fieldsOptionalMap = this.getFieldsAndOptionalMap(resolvedType);
        Set serializableFields = resolvedType.getDeclaredFields().stream().filter(resolvedFieldDeclaration -> fieldsOptionalMap.containsKey(resolvedFieldDeclaration.getName())).collect(Collectors.toSet());
        schema.setProperties(new TreeMap());
        for (ResolvedFieldDeclaration resolvedFieldDeclaration2 : serializableFields) {
            String name = resolvedFieldDeclaration2.getName();
            Schema type = this.parseResolvedTypeToSchema(resolvedFieldDeclaration2.getType());
            if (!fieldsOptionalMap.get(name).booleanValue()) {
                schema.addRequiredItem(name);
            }
            schema.addProperties(name, type);
        }
        return schema;
    }

    private Map<String, Boolean> getFieldsAndOptionalMap(ResolvedReferenceType resolvedType) {
        if (!resolvedType.getTypeDeclaration().isClass() || resolvedType.getTypeDeclaration().isAnonymousClass()) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> validFields = new HashMap<String, Boolean>();
        try {
            Class<?> aClass = this.getClassFromReflection(resolvedType);
            Arrays.stream(aClass.getDeclaredFields()).filter(field -> {
                int modifiers = field.getModifiers();
                return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !field.isAnnotationPresent(JsonIgnore.class);
            }).forEach(field -> validFields.put(field.getName(), field.isAnnotationPresent(Nullable.class) || field.getType().equals(Optional.class)));
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Can't get list of fields from class '%s'.Please make sure that class '%s' is in your project's compile classpath. As the result, the generated TypeScript file will be empty.", resolvedType.getQualifiedName(), resolvedType.getQualifiedName());
            OpenApiObjectGenerator.getLogger().info(message);
            OpenApiObjectGenerator.getLogger().debug(message, (Throwable)e);
        }
        return validFields;
    }

    private Class<?> getClassFromReflection(ResolvedReferenceType resolvedType) throws ClassNotFoundException {
        String fullyQualifiedName = this.getFullyQualifiedName(resolvedType);
        if (this.typeResolverClassLoader != null) {
            return Class.forName(fullyQualifiedName, true, this.typeResolverClassLoader);
        }
        return Class.forName(fullyQualifiedName);
    }

    private String getFullyQualifiedName(ResolvedReferenceType resolvedReferenceType) {
        ResolvedReferenceTypeDeclaration typeDeclaration = resolvedReferenceType.getTypeDeclaration();
        String packageName = typeDeclaration.getPackageName();
        String canonicalName = typeDeclaration.getQualifiedName();
        if (GeneratorUtils.isBlank(packageName)) {
            return GeneratorUtils.replaceChars(canonicalName, '.', '$');
        }
        String name = GeneratorUtils.substringAfterLast(canonicalName, packageName + ".");
        return String.format("%s.%s", packageName, GeneratorUtils.replaceChars(name, '.', '$'));
    }

    private /* synthetic */ void lambda$createRequestBody$19(Map paramsDescription, Schema requestSchema, Parameter parameter) {
        Schema paramSchema = this.parseTypeToSchema(parameter.getType(), "");
        this.usedTypes.putAll(this.collectUsedTypesFromSchema(paramSchema));
        String name = (this.isReservedWord(parameter.getNameAsString()) ? "_" : "").concat(parameter.getNameAsString());
        if (GeneratorUtils.isBlank(paramSchema.get$ref())) {
            paramSchema.description((String)paramsDescription.remove(parameter.getNameAsString()));
        }
        requestSchema.addProperties(name, paramSchema);
        if (GeneratorUtils.isNotTrue(paramSchema.getNullable()) && !parameter.isAnnotationPresent(Nullable.class)) {
            requestSchema.addRequiredItem(name);
        }
        paramSchema.setNullable(null);
    }
}

